/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkConstants;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.IPackageVersion;
import com.android.sdklib.internal.repository.Package;
import com.android.sdkuilib.internal.repository.ArchiveInfo;
import com.android.sdkuilib.internal.repository.UpdaterData;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UpdateChooserDialog
extends Dialog {
    private static final int MIN_Y = SdkConstants.CURRENT_PLATFORM == 3 ? 20 : 0;
    private static Point sLastSize;
    private boolean mCancelled = true;
    private boolean mCompleted;
    private boolean mLicenseAcceptAll;
    private boolean mInternalLicenseRadioUpdate;
    private Shell mDialogShell;
    private SashForm mSashForm;
    private Composite mPackageRootComposite;
    private Button mCancelButton;
    private Button mInstallButton;
    private TableViewer mTableViewPackage;
    private Table mTablePackage;
    private TableColumn mTableColum;
    private StyledText mPackageText;
    private Button mLicenseRadioAccept;
    private Button mLicenseRadioReject;
    private Button mLicenseRadioAcceptAll;
    private Group mPackageTextGroup;
    private final UpdaterData mUpdaterData;
    private Group mTableGroup;
    private Label mErrorLabel;
    private final ArrayList<ArchiveInfo> mArchives;

    public UpdateChooserDialog(Shell parentShell, UpdaterData updaterData, ArrayList<ArchiveInfo> archives) {
        super(parentShell, 65536);
        this.mUpdaterData = updaterData;
        this.mArchives = archives;
    }

    public ArrayList<ArchiveInfo> getResult() {
        ArrayList<ArchiveInfo> ais = new ArrayList<ArchiveInfo>();
        if (!this.mCancelled) {
            for (ArchiveInfo ai : this.mArchives) {
                if (!ai.isAccepted()) continue;
                ais.add(ai);
            }
        }
        return ais;
    }

    public void open() {
        this.createContents();
        this.positionShell();
        this.mDialogShell.open();
        this.mDialogShell.layout();
        this.postCreate();
        Display display = this.getParent().getDisplay();
        while (!this.mDialogShell.isDisposed() && !this.mCompleted) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!this.mDialogShell.isDisposed()) {
            this.mDialogShell.close();
        }
    }

    private void createContents() {
        this.mDialogShell = new Shell(this.getParent(), 3312);
        this.mDialogShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                UpdateChooserDialog.this.onShellClosed(e);
            }
        });
        this.mDialogShell.setLayout((Layout)new GridLayout(3, false));
        this.mDialogShell.setSize(600, 400);
        this.mDialogShell.setText("Choose Packages to Install");
        this.mSashForm = new SashForm((Composite)this.mDialogShell, 0);
        this.mSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.mTableGroup = new Group((Composite)this.mSashForm, 0);
        this.mTableGroup.setText("Packages");
        this.mTableGroup.setLayout((Layout)new GridLayout(1, false));
        this.mTableViewPackage = new TableViewer((Composite)this.mTableGroup, 2564);
        this.mTablePackage = this.mTableViewPackage.getTable();
        this.mTablePackage.setHeaderVisible(false);
        this.mTablePackage.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mTablePackage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onPackageSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onPackageDoubleClick();
            }
        });
        this.mTableColum = new TableColumn(this.mTablePackage, 0);
        this.mTableColum.setWidth(100);
        this.mTableColum.setText("Packages");
        this.mPackageRootComposite = new Composite((Composite)this.mSashForm, 0);
        this.mPackageRootComposite.setLayout((Layout)new GridLayout(4, false));
        this.mPackageRootComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mPackageTextGroup = new Group(this.mPackageRootComposite, 0);
        this.mPackageTextGroup.setText("Package Description && License");
        this.mPackageTextGroup.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.mPackageTextGroup.setLayout((Layout)new GridLayout(1, false));
        this.mPackageText = new StyledText((Composite)this.mPackageTextGroup, 586);
        this.mPackageText.setBackground(this.getParent().getDisplay().getSystemColor(22));
        this.mPackageText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mLicenseRadioAccept = new Button(this.mPackageRootComposite, 16);
        this.mLicenseRadioAccept.setText("Accept");
        this.mLicenseRadioAccept.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onLicenseRadioSelected();
            }
        });
        this.mLicenseRadioReject = new Button(this.mPackageRootComposite, 16);
        this.mLicenseRadioReject.setText("Reject");
        this.mLicenseRadioReject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onLicenseRadioSelected();
            }
        });
        Label placeholder = new Label(this.mPackageRootComposite, 0);
        placeholder.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.mLicenseRadioAcceptAll = new Button(this.mPackageRootComposite, 16);
        this.mLicenseRadioAcceptAll.setText("Accept All");
        this.mLicenseRadioAcceptAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onLicenseRadioSelected();
            }
        });
        this.mSashForm.setWeights(new int[]{200, 300});
        this.mErrorLabel = new Label((Composite)this.mDialogShell, 0);
        this.mErrorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        placeholder = new Label((Composite)this.mDialogShell, 0);
        placeholder.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        placeholder.setText("[*] Something depends on this package");
        placeholder.setEnabled(false);
        if (SdkConstants.currentPlatform() == 3) {
            this.mCancelButton = new Button((Composite)this.mDialogShell, 8);
        }
        this.mInstallButton = new Button((Composite)this.mDialogShell, 8);
        this.mInstallButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mInstallButton.setText("Install Accepted");
        this.mInstallButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onInstallSelected();
            }
        });
        if (this.mCancelButton == null) {
            this.mCancelButton = new Button((Composite)this.mDialogShell, 8);
        }
        this.mCancelButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateChooserDialog.this.onCancelSelected();
            }
        });
    }

    private void postCreate() {
        this.setWindowImage();
        for (ArchiveInfo ai : this.mArchives) {
            Archive a = ai.getNewArchive();
            assert (a != null);
            String license = a.getParentPackage().getLicense();
            ai.setAccepted(license == null || license.trim().length() == 0);
        }
        this.mTableViewPackage.setLabelProvider((IBaseLabelProvider)new NewArchivesLabelProvider());
        this.mTableViewPackage.setContentProvider((IContentProvider)new NewArchivesContentProvider());
        this.mTableViewPackage.setInput(this.mArchives);
        this.adjustColumnsWidth();
        this.mTablePackage.select(0);
        this.onPackageSelected();
    }

    private void setWindowImage() {
        ImageFactory imgFactory;
        String imageName = "android_icon_16.png";
        if (SdkConstants.currentPlatform() == 3) {
            imageName = "android_icon_128.png";
        }
        if (this.mUpdaterData != null && (imgFactory = this.mUpdaterData.getImageFactory()) != null) {
            this.mDialogShell.setImage(imgFactory.getImageByName(imageName));
        }
    }

    private void adjustColumnsWidth() {
        ControlAdapter resizer = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = UpdateChooserDialog.this.mTablePackage.getClientArea();
                UpdateChooserDialog.this.mTableColum.setWidth(r.width);
            }
        };
        this.mTablePackage.addControlListener((ControlListener)resizer);
        resizer.controlResized(null);
    }

    private void onShellClosed(ShellEvent e) {
        sLastSize = this.mDialogShell.getSize();
    }

    private void positionShell() {
        Shell child = this.mDialogShell;
        Shell parent = this.getParent();
        if (child != null && parent != null) {
            Rectangle parentArea = parent.getClientArea();
            Point parentLoc = parent.getLocation();
            int px = parentLoc.x;
            int py = parentLoc.y;
            int pw = parentArea.width;
            int ph = parentArea.height;
            Point childSize = sLastSize != null ? sLastSize : child.getSize();
            int cw = childSize.x;
            int ch = childSize.y;
            int x = px + (pw - cw) / 2;
            int y = py + (ph - ch) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < MIN_Y) {
                y = MIN_Y;
            }
            child.setLocation(x, y);
            child.setSize(cw, ch);
        }
    }

    private void onInstallSelected() {
        this.mCancelled = false;
        this.mCompleted = true;
    }

    private void onCancelSelected() {
        this.mCancelled = true;
        this.mCompleted = true;
    }

    private void onPackageSelected() {
        ArchiveInfo ai = this.getSelectedArchive();
        this.displayInformation(ai);
        this.displayMissingDependency(ai);
        this.updateLicenceRadios(ai);
    }

    private ArchiveInfo getSelectedArchive() {
        Object elem;
        ISelection sel = this.mTableViewPackage.getSelection();
        if (sel instanceof IStructuredSelection && (elem = ((IStructuredSelection)sel).getFirstElement()) instanceof ArchiveInfo) {
            return (ArchiveInfo)elem;
        }
        return null;
    }

    private void displayInformation(ArchiveInfo ai) {
        ArchiveInfo aDep;
        if (ai == null) {
            this.mPackageText.setText("Please select a package.");
            return;
        }
        Archive aNew = ai.getNewArchive();
        Package pNew = aNew.getParentPackage();
        this.mPackageText.setText("");
        this.addSectionTitle("Package Description\n");
        this.addText(pNew.getLongDescription(), "\n\n");
        Archive aOld = ai.getReplaced();
        if (aOld != null) {
            AndroidVersion vNew;
            AndroidVersion vOld;
            Package pOld = aOld.getParentPackage();
            int rOld = pOld.getRevision();
            int rNew = pNew.getRevision();
            boolean showRev = true;
            if (pNew instanceof IPackageVersion && pOld instanceof IPackageVersion && !(vOld = ((IPackageVersion)pOld).getVersion()).equals((Object)(vNew = ((IPackageVersion)pNew).getVersion()))) {
                this.addText(String.format("This update will replace API %1$s revision %2$d with API %3$s revision %4$d.\n\n", vOld.getApiString(), rOld, vNew.getApiString(), rNew));
                showRev = false;
            }
            if (showRev) {
                this.addText(String.format("This update will replace revision %1$d with revision %2$d.\n\n", rOld, rNew));
            }
        }
        if ((aDep = ai.getDependsOn()) != null || ai.isDependencyFor()) {
            this.addSectionTitle("Dependencies\n");
            if (aDep != null) {
                this.addText(String.format("This package depends on %1$s.\n\n", aDep.getNewArchive().getParentPackage().getShortDescription()));
            }
            if (ai.isDependencyFor()) {
                this.addText("This package is a dependency for:");
                for (ArchiveInfo ai2 : ai.getDependenciesFor()) {
                    this.addText("\n- " + ai2.getNewArchive().getParentPackage().getShortDescription());
                }
                this.addText("\n\n");
            }
        }
        this.addSectionTitle("Archive Description\n");
        this.addText(aNew.getLongDescription(), "\n\n");
        String license = pNew.getLicense();
        if (license != null) {
            this.addSectionTitle("License\n");
            this.addText(license.trim(), "\n\n");
        }
        this.addSectionTitle("Site\n");
        this.addText(pNew.getParentSource().getShortDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void displayMissingDependency(ArchiveInfo ai) {
        String error = null;
        try {
            if (ai != null) {
                if (ai.isAccepted()) {
                    ArchiveInfo adep = ai.getDependsOn();
                    if (adep != null && !adep.isAccepted()) {
                        error = String.format("This package depends on '%1$s'.", adep.getNewArchive().getParentPackage().getShortDescription());
                        this.mErrorLabel.setText(error == null ? "" : error);
                        return;
                    }
                } else {
                    for (ArchiveInfo ai2 : ai.getDependenciesFor()) {
                        if (!ai2.isAccepted()) continue;
                        error = String.format("Package '%1$s' depends on this one.", ai2.getNewArchive().getParentPackage().getShortDescription());
                        this.mErrorLabel.setText(error == null ? "" : error);
                        return;
                    }
                }
            }
            for (ArchiveInfo ai2 : this.mArchives) {
                ArchiveInfo adep;
                if (!ai2.isAccepted() || (adep = ai2.getDependsOn()) == null || adep.isAccepted()) break block11;
                error = String.format("Package '%1$s' depends on '%2$s'", ai2.getNewArchive().getParentPackage().getShortDescription(), adep.getNewArchive().getParentPackage().getShortDescription());
                this.mErrorLabel.setText(error == null ? "" : error);
            }
        }
        catch (Throwable throwable) {
            this.mErrorLabel.setText(error == null ? "" : error);
            throw throwable;
        }
        {
            block11: {
                return;
            }
            continue;
        }
        this.mErrorLabel.setText(error == null ? "" : error);
    }

    private void addText(String ... string) {
        for (String s : string) {
            this.mPackageText.append(s);
        }
    }

    private void addSectionTitle(String string) {
        String s = this.mPackageText.getText();
        int start = s == null ? 0 : s.length();
        this.mPackageText.append(string);
        StyleRange sr = new StyleRange();
        sr.start = start;
        sr.length = string.length();
        sr.fontStyle = 1;
        sr.underline = true;
        this.mPackageText.setStyleRange(sr);
    }

    private void updateLicenceRadios(ArchiveInfo ai) {
        boolean missing;
        if (this.mInternalLicenseRadioUpdate) {
            return;
        }
        this.mInternalLicenseRadioUpdate = true;
        boolean oneAccepted = false;
        if (this.mLicenseAcceptAll) {
            this.mLicenseRadioAcceptAll.setSelection(true);
            this.mLicenseRadioAccept.setEnabled(true);
            this.mLicenseRadioReject.setEnabled(true);
            this.mLicenseRadioAccept.setSelection(false);
            this.mLicenseRadioReject.setSelection(false);
        } else {
            this.mLicenseRadioAcceptAll.setSelection(false);
            oneAccepted = ai != null && ai.isAccepted();
            this.mLicenseRadioAccept.setEnabled(ai != null);
            this.mLicenseRadioReject.setEnabled(ai != null);
            this.mLicenseRadioAccept.setSelection(oneAccepted);
            this.mLicenseRadioReject.setSelection(ai != null && ai.isRejected());
        }
        boolean bl = missing = this.mErrorLabel.getText() != null && this.mErrorLabel.getText().length() > 0;
        if (!missing && !oneAccepted) {
            for (ArchiveInfo ai2 : this.mArchives) {
                if (!ai2.isAccepted()) continue;
                oneAccepted = true;
                break;
            }
        }
        this.mInstallButton.setEnabled(!missing && oneAccepted);
        this.mInternalLicenseRadioUpdate = false;
    }

    private void onLicenseRadioSelected() {
        if (this.mInternalLicenseRadioUpdate) {
            return;
        }
        this.mInternalLicenseRadioUpdate = true;
        ArchiveInfo ai = this.getSelectedArchive();
        boolean needUpdate = true;
        if (!this.mLicenseAcceptAll && this.mLicenseRadioAcceptAll.getSelection()) {
            this.mLicenseAcceptAll = true;
            for (ArchiveInfo ai2 : this.mArchives) {
                ai2.setAccepted(true);
                ai2.setRejected(false);
            }
        } else if (this.mLicenseRadioAccept.getSelection()) {
            this.mLicenseAcceptAll = false;
            ai.setAccepted(true);
            ai.setRejected(false);
        } else if (this.mLicenseRadioReject.getSelection()) {
            this.mLicenseAcceptAll = false;
            ai.setAccepted(false);
            ai.setRejected(true);
        } else {
            needUpdate = false;
        }
        this.mInternalLicenseRadioUpdate = false;
        if (needUpdate) {
            if (this.mLicenseAcceptAll) {
                this.mTableViewPackage.refresh();
            } else {
                this.mTableViewPackage.refresh((Object)ai);
            }
            this.displayMissingDependency(ai);
            this.updateLicenceRadios(ai);
        }
    }

    private void onPackageDoubleClick() {
        ArchiveInfo ai;
        boolean wasAccepted = (ai = this.getSelectedArchive()).isAccepted();
        ai.setAccepted(!wasAccepted);
        ai.setRejected(wasAccepted);
        this.mLicenseAcceptAll = false;
        this.mTableViewPackage.refresh((Object)ai);
        this.updateLicenceRadios(ai);
    }

    private class NewArchivesContentProvider
    implements IStructuredContentProvider {
        private NewArchivesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return UpdateChooserDialog.this.mArchives.toArray();
        }
    }

    private class NewArchivesLabelProvider
    extends LabelProvider {
        private NewArchivesLabelProvider() {
        }

        public Image getImage(Object element) {
            assert (element instanceof ArchiveInfo);
            ArchiveInfo ai = (ArchiveInfo)element;
            ImageFactory imgFactory = UpdateChooserDialog.this.mUpdaterData.getImageFactory();
            if (imgFactory != null) {
                if (ai.isAccepted()) {
                    return imgFactory.getImageByName("accept_icon16.png");
                }
                if (ai.isRejected()) {
                    return imgFactory.getImageByName("reject_icon16.png");
                }
                return imgFactory.getImageByName("unknown_icon16.png");
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            assert (element instanceof ArchiveInfo);
            ArchiveInfo ai = (ArchiveInfo)element;
            String desc = ai.getNewArchive().getParentPackage().getShortDescription();
            if (ai.isDependencyFor()) {
                desc = desc + " [*]";
            }
            return desc;
        }
    }
}

