/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.repository.AddonPackage;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskFactory;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.LocalSdkParser;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.RepoSource;
import com.android.sdklib.internal.repository.RepoSources;
import com.android.sdklib.internal.repository.ToolPackage;
import com.android.sdkuilib.internal.repository.AdbWrapper;
import com.android.sdkuilib.internal.repository.ArchiveInfo;
import com.android.sdkuilib.internal.repository.LocalSdkAdapter;
import com.android.sdkuilib.internal.repository.RepoSourcesAdapter;
import com.android.sdkuilib.internal.repository.SettingsController;
import com.android.sdkuilib.internal.repository.UpdateChooserDialog;
import com.android.sdkuilib.internal.repository.UpdaterLogic;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.repository.UpdaterWindow;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UpdaterData {
    private String mOsSdkRoot;
    private final ISdkLog mSdkLog;
    private ITaskFactory mTaskFactory;
    private boolean mUserCanChangeSdkRoot;
    private SdkManager mSdkManager;
    private AvdManager mAvdManager;
    private final LocalSdkParser mLocalSdkParser = new LocalSdkParser();
    private final RepoSources mSources = new RepoSources();
    private final LocalSdkAdapter mLocalSdkAdapter = new LocalSdkAdapter(this);
    private final RepoSourcesAdapter mSourcesAdapter = new RepoSourcesAdapter(this);
    private ImageFactory mImageFactory;
    private final SettingsController mSettingsController;
    private final ArrayList<UpdaterWindow.ISdkListener> mListeners = new ArrayList();
    private Shell mWindowShell;

    public UpdaterData(String osSdkRoot, ISdkLog sdkLog) {
        this.mOsSdkRoot = osSdkRoot;
        this.mSdkLog = sdkLog;
        this.mSettingsController = new SettingsController(this);
        this.initSdk();
    }

    public void setOsSdkRoot(String osSdkRoot) {
        if (this.mOsSdkRoot == null || !this.mOsSdkRoot.equals(osSdkRoot)) {
            this.mOsSdkRoot = osSdkRoot;
            this.initSdk();
        }
    }

    public String getOsSdkRoot() {
        return this.mOsSdkRoot;
    }

    public void setTaskFactory(ITaskFactory taskFactory) {
        this.mTaskFactory = taskFactory;
    }

    public ITaskFactory getTaskFactory() {
        return this.mTaskFactory;
    }

    public void setUserCanChangeSdkRoot(boolean userCanChangeSdkRoot) {
        this.mUserCanChangeSdkRoot = userCanChangeSdkRoot;
    }

    public boolean canUserChangeSdkRoot() {
        return this.mUserCanChangeSdkRoot;
    }

    public RepoSources getSources() {
        return this.mSources;
    }

    public RepoSourcesAdapter getSourcesAdapter() {
        return this.mSourcesAdapter;
    }

    public LocalSdkParser getLocalSdkParser() {
        return this.mLocalSdkParser;
    }

    public LocalSdkAdapter getLocalSdkAdapter() {
        return this.mLocalSdkAdapter;
    }

    public ISdkLog getSdkLog() {
        return this.mSdkLog;
    }

    public void setImageFactory(ImageFactory imageFactory) {
        this.mImageFactory = imageFactory;
    }

    public ImageFactory getImageFactory() {
        return this.mImageFactory;
    }

    public SdkManager getSdkManager() {
        return this.mSdkManager;
    }

    public AvdManager getAvdManager() {
        return this.mAvdManager;
    }

    public SettingsController getSettingsController() {
        return this.mSettingsController;
    }

    public void addListeners(UpdaterWindow.ISdkListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(UpdaterWindow.ISdkListener listener) {
        this.mListeners.remove(listener);
    }

    public void setWindowShell(Shell windowShell) {
        this.mWindowShell = windowShell;
    }

    public Shell getWindowShell() {
        return this.mWindowShell;
    }

    private void initSdk() {
        this.mSdkManager = SdkManager.createManager((String)this.mOsSdkRoot, (ISdkLog)this.mSdkLog);
        try {
            this.mAvdManager = null;
            this.mAvdManager = new AvdManager(this.mSdkManager, this.mSdkLog);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.mSdkLog.error((Throwable)e, "Unable to read AVDs", new Object[0]);
        }
        this.notifyListeners();
    }

    public void reloadSdk() {
        this.mSdkManager.reloadSdk(this.mSdkLog);
        if (this.mAvdManager != null) {
            try {
                this.mAvdManager.reloadAvds(this.mSdkLog);
            }
            catch (AndroidLocation.AndroidLocationException androidLocationException) {
                // empty catch block
            }
        }
        this.mLocalSdkParser.clearPackages();
        this.notifyListeners();
    }

    public void reloadAvds() {
        if (this.mAvdManager != null) {
            try {
                this.mAvdManager.reloadAvds(this.mSdkLog);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                this.mSdkLog.error((Throwable)e, null, new Object[0]);
            }
        }
    }

    public Package[] getInstalledPackage() {
        LocalSdkParser parser = this.getLocalSdkParser();
        Package[] packages = parser.getPackages();
        if (packages == null) {
            packages = parser.parseSdk(this.getOsSdkRoot(), this.getSdkManager(), this.getSdkLog());
        }
        return packages;
    }

    public void notifyListeners() {
        if (this.mWindowShell != null && this.mListeners.size() > 0) {
            this.mWindowShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    for (UpdaterWindow.ISdkListener listener : UpdaterData.this.mListeners) {
                        try {
                            listener.onSdkChange();
                        }
                        catch (Throwable t) {
                            UpdaterData.this.mSdkLog.error(t, null, new Object[0]);
                        }
                    }
                }
            });
        }
    }

    public void installArchives(final ArrayList<ArchiveInfo> result) {
        if (this.mTaskFactory == null) {
            throw new IllegalArgumentException("Task Factory is null");
        }
        final boolean forceHttp = this.getSettingsController().getForceHttp();
        this.mTaskFactory.start("Installing Archives", new ITask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ITaskMonitor monitor) {
                int progressPerArchive = 200;
                monitor.setProgressMax(result.size() * 200);
                monitor.setDescription("Preparing to install archives", new Object[0]);
                boolean installedAddon = false;
                boolean installedTools = false;
                HashSet<Archive> installedArchives = new HashSet<Archive>();
                for (Package p : UpdaterData.this.getInstalledPackage()) {
                    for (Archive a : p.getArchives()) {
                        installedArchives.add(a);
                    }
                }
                int numInstalled = 0;
                for (ArchiveInfo ai : result) {
                    Archive archive = ai.getNewArchive();
                    int nextProgress = monitor.getProgress() + 200;
                    try {
                        if (monitor.isCancelRequested()) break;
                        ArchiveInfo adep = ai.getDependsOn();
                        if (adep != null && !installedArchives.contains(adep.getNewArchive())) {
                            monitor.setResult("Skipping '%1$s'; it depends on '%2$s' which was not installed.", new Object[]{archive.getParentPackage().getShortDescription(), adep.getNewArchive().getParentPackage().getShortDescription()});
                        }
                        if (!archive.install(UpdaterData.this.mOsSdkRoot, forceHttp, UpdaterData.this.mSdkManager, monitor)) continue;
                        installedArchives.add(archive);
                        ++numInstalled;
                        installedArchives.remove(ai.getReplaced());
                        if (archive.getParentPackage() instanceof AddonPackage) {
                            installedAddon = true;
                            continue;
                        }
                        if (!(archive.getParentPackage() instanceof ToolPackage)) continue;
                        installedTools = true;
                    }
                    catch (Throwable t) {
                        String msg = t.getMessage();
                        if (msg != null) {
                            monitor.setResult("Unexpected Error installing '%1$s': %2$s", new Object[]{archive.getParentPackage().getShortDescription(), msg});
                            continue;
                        }
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        t.printStackTrace(new PrintStream(baos));
                        monitor.setResult("Unexpected Error installing '%1$s'\n%2$s", new Object[]{archive.getParentPackage().getShortDescription(), baos.toString()});
                    }
                    finally {
                        monitor.incProgress(nextProgress - monitor.getProgress());
                    }
                }
                if (installedAddon) {
                    try {
                        UpdaterData.this.mSdkManager.updateAdb();
                        monitor.setResult("Updated ADB to support the USB devices declared in the SDK add-ons.", new Object[0]);
                    }
                    catch (Exception e) {
                        UpdaterData.this.mSdkLog.error((Throwable)e, "Update ADB failed", new Object[0]);
                        monitor.setResult("failed to update adb to support the USB devices declared in the SDK add-ons.", new Object[0]);
                    }
                }
                if (installedAddon || installedTools) {
                    UpdaterData.this.askForAdbRestart(monitor);
                }
                if (installedTools) {
                    UpdaterData.this.notifyToolsNeedsToBeRestarted();
                }
                if (numInstalled == 0) {
                    monitor.setDescription("Done. Nothing was installed.", new Object[0]);
                } else {
                    monitor.setDescription("Done. %1$d %2$s installed.", new Object[]{numInstalled, numInstalled == 1 ? "package" : "packages"});
                    UpdaterData.this.reloadSdk();
                }
            }
        });
    }

    private void askForAdbRestart(ITaskMonitor monitor) {
        final boolean[] canRestart = new boolean[]{true};
        if (this.getSettingsController().getAskBeforeAdbRestart()) {
            Display display = this.mWindowShell.getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    canRestart[0] = MessageDialog.openQuestion((Shell)UpdaterData.this.mWindowShell, (String)"ADB Restart", (String)"A package that depends on ADB has been updated. It is recommended to restart ADB. Is it OK to do it now? If not, you can restart it manually later.");
                }
            });
        }
        if (canRestart[0]) {
            AdbWrapper adb = new AdbWrapper(this.getOsSdkRoot(), monitor);
            adb.stopAdb();
            adb.startAdb();
        }
    }

    private void notifyToolsNeedsToBeRestarted() {
        Display display = this.mWindowShell.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)UpdaterData.this.mWindowShell, (String)"Android Tools Updated", (String)"The Android SDK and AVD Manager that you are currently using has been updated. It is recommended that you now close the manager window and re-open it. If you started this window from Eclipse, please check if the Android plug-in needs to be updated.");
            }
        });
    }

    public void updateOrInstallAll(Collection<Archive> selectedArchives) {
        if (selectedArchives == null) {
            this.refreshSources(true);
        }
        UpdaterLogic ul = new UpdaterLogic();
        ArrayList<ArchiveInfo> archives = ul.computeUpdates(selectedArchives, this.getSources(), this.getLocalSdkParser().getPackages());
        if (selectedArchives == null) {
            ul.addNewPlatforms(archives, this.getSources(), this.getLocalSdkParser().getPackages());
        }
        UpdateChooserDialog dialog = new UpdateChooserDialog(this.getWindowShell(), this, archives);
        dialog.open();
        ArrayList<ArchiveInfo> result = dialog.getResult();
        if (result != null && result.size() > 0) {
            this.installArchives(result);
        }
    }

    public void refreshSources(final boolean forceFetching) {
        assert (this.mTaskFactory != null);
        final boolean forceHttp = this.getSettingsController().getForceHttp();
        this.mTaskFactory.start("Refresh Sources", new ITask(){

            public void run(ITaskMonitor monitor) {
                RepoSource[] sources = UpdaterData.this.mSources.getSources();
                monitor.setProgressMax(sources.length);
                for (RepoSource source : sources) {
                    if (forceFetching || source.getPackages() != null || source.getFetchError() != null) {
                        source.load(monitor.createSubMonitor(1), forceHttp);
                    }
                    monitor.incProgress(1);
                }
            }
        });
    }
}

