/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.repository.AddonPackage;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.DocPackage;
import com.android.sdklib.internal.repository.ExtraPackage;
import com.android.sdklib.internal.repository.IPackageVersion;
import com.android.sdklib.internal.repository.MinToolsPackage;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.PlatformPackage;
import com.android.sdklib.internal.repository.RepoSource;
import com.android.sdklib.internal.repository.RepoSources;
import com.android.sdklib.internal.repository.ToolPackage;
import com.android.sdkuilib.internal.repository.ArchiveInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UpdaterLogic {
    UpdaterLogic() {
    }

    public ArrayList<ArchiveInfo> computeUpdates(Collection<Archive> selectedArchives, RepoSources sources, Package[] localPkgs) {
        ArrayList<ArchiveInfo> archives = new ArrayList<ArchiveInfo>();
        ArrayList<Package> remotePkgs = new ArrayList<Package>();
        RepoSource[] remoteSources = sources.getSources();
        if (selectedArchives == null) {
            selectedArchives = this.findUpdates(localPkgs, remotePkgs, remoteSources);
        }
        for (Archive a : selectedArchives) {
            this.insertArchive(a, archives, selectedArchives, remotePkgs, remoteSources, localPkgs, false);
        }
        return archives;
    }

    public void addNewPlatforms(ArrayList<ArchiveInfo> archives, RepoSources sources, Package[] localPkgs) {
        float currentPlatformScore = 0.0f;
        float currentAddonScore = 0.0f;
        float currentDocScore = 0.0f;
        HashMap<String, Float> currentExtraScore = new HashMap<String, Float>();
        for (Package p : localPkgs) {
            int rev = p.getRevision();
            int api = 0;
            boolean isPreview = false;
            if (p instanceof IPackageVersion) {
                AndroidVersion vers = ((IPackageVersion)p).getVersion();
                api = vers.getApiLevel();
                isPreview = vers.isPreview();
            }
            float score = (float)(api * 10 + (isPreview ? 1 : 0)) + (float)rev / 100.0f;
            if (p instanceof PlatformPackage) {
                currentPlatformScore = Math.max(currentPlatformScore, score);
                continue;
            }
            if (p instanceof AddonPackage) {
                currentAddonScore = Math.max(currentAddonScore, score);
                continue;
            }
            if (p instanceof ExtraPackage) {
                currentExtraScore.put(((ExtraPackage)p).getPath(), Float.valueOf(score));
                continue;
            }
            if (!(p instanceof DocPackage)) continue;
            currentDocScore = Math.max(currentDocScore, score);
        }
        RepoSource[] remoteSources = sources.getSources();
        ArrayList<Package> remotePkgs = new ArrayList<Package>();
        this.fetchRemotePackages(remotePkgs, remoteSources);
        Package suggestedDoc = null;
        for (Package p : remotePkgs) {
            int rev = p.getRevision();
            int api = 0;
            boolean isPreview = false;
            if (p instanceof IPackageVersion) {
                AndroidVersion vers = ((IPackageVersion)p).getVersion();
                api = vers.getApiLevel();
                isPreview = vers.isPreview();
            }
            float score = (float)(api * 10 + (isPreview ? 1 : 0)) + (float)rev / 100.0f;
            boolean shouldAdd = false;
            if (p instanceof PlatformPackage) {
                shouldAdd = score > currentPlatformScore;
            } else if (p instanceof AddonPackage) {
                shouldAdd = score > currentAddonScore;
            } else if (p instanceof ExtraPackage) {
                String key = ((ExtraPackage)p).getPath();
                shouldAdd = !currentExtraScore.containsKey(key) || score > ((Float)currentExtraScore.get(key)).floatValue();
            } else if (p instanceof DocPackage && score > currentDocScore) {
                suggestedDoc = p;
                currentDocScore = score;
            }
            if (!shouldAdd) continue;
            for (Archive a : p.getArchives()) {
                if (!a.isCompatible()) continue;
                this.insertArchive(a, archives, null, remotePkgs, remoteSources, localPkgs, true);
            }
        }
        if (suggestedDoc != null) {
            for (Archive a : suggestedDoc.getArchives()) {
                if (!a.isCompatible()) continue;
                this.insertArchive(a, archives, null, remotePkgs, remoteSources, localPkgs, true);
            }
        }
    }

    private Collection<Archive> findUpdates(Package[] localPkgs, ArrayList<Package> remotePkgs, RepoSource[] remoteSources) {
        ArrayList<Archive> updates = new ArrayList<Archive>();
        this.fetchRemotePackages(remotePkgs, remoteSources);
        for (Package localPkg : localPkgs) {
            block1: for (Package remotePkg : remotePkgs) {
                if (localPkg.canBeUpdatedBy(remotePkg) != Package.UpdateInfo.UPDATE) continue;
                for (Archive a : remotePkg.getArchives()) {
                    if (!a.isCompatible()) continue;
                    updates.add(a);
                    continue block1;
                }
            }
        }
        return updates;
    }

    private ArchiveInfo insertArchive(Archive archive, ArrayList<ArchiveInfo> outArchives, Collection<Archive> selectedArchives, ArrayList<Package> remotePkgs, RepoSource[] remoteSources, Package[] localPkgs, boolean automated) {
        Package p = archive.getParentPackage();
        Archive updatedArchive = null;
        for (Package lp : localPkgs) {
            assert (lp.getArchives().length == 1);
            if (lp.getArchives().length <= 0 || lp.canBeUpdatedBy(p) != Package.UpdateInfo.UPDATE) continue;
            updatedArchive = lp.getArchives()[0];
        }
        ArchiveInfo dep = this.findDependency(p, outArchives, selectedArchives, remotePkgs, remoteSources, localPkgs);
        ArchiveInfo ai = null;
        for (ArchiveInfo ai2 : outArchives) {
            if (!ai2.getNewArchive().getParentPackage().sameItemAs(archive.getParentPackage())) continue;
            ai = ai2;
            break;
        }
        if (ai == null) {
            ai = new ArchiveInfo(archive, updatedArchive, dep);
            outArchives.add(ai);
        }
        if (dep != null) {
            dep.addDependencyFor(ai);
        }
        return ai;
    }

    private ArchiveInfo findDependency(Package pkg, ArrayList<ArchiveInfo> outArchives, Collection<Archive> selectedArchives, ArrayList<Package> remotePkgs, RepoSource[] remoteSources, Package[] localPkgs) {
        if (pkg instanceof AddonPackage) {
            AddonPackage addon = (AddonPackage)pkg;
            return this.findPlatformDependency(addon, outArchives, selectedArchives, remotePkgs, remoteSources, localPkgs);
        }
        if (pkg instanceof MinToolsPackage) {
            MinToolsPackage platformOrExtra = (MinToolsPackage)pkg;
            return this.findToolsDependency(platformOrExtra, outArchives, selectedArchives, remotePkgs, remoteSources, localPkgs);
        }
        return null;
    }

    protected ArchiveInfo findToolsDependency(MinToolsPackage platformOrExtra, ArrayList<ArchiveInfo> outArchives, Collection<Archive> selectedArchives, ArrayList<Package> remotePkgs, RepoSource[] remoteSources, Package[] localPkgs) {
        int rev = platformOrExtra.getMinToolsRevision();
        if (rev == 0) {
            return null;
        }
        for (Package p : localPkgs) {
            if (!(p instanceof ToolPackage) || ((ToolPackage)p).getRevision() < rev) continue;
            return null;
        }
        for (ArchiveInfo ai : outArchives) {
            Package p = ai.getNewArchive().getParentPackage();
            if (!(p instanceof ToolPackage) || ((ToolPackage)p).getRevision() < rev) continue;
            return ai;
        }
        if (selectedArchives != null) {
            for (Archive a : selectedArchives) {
                Package p = a.getParentPackage();
                if (!(p instanceof ToolPackage) || ((ToolPackage)p).getRevision() < rev) continue;
                return this.insertArchive(a, outArchives, selectedArchives, remotePkgs, remoteSources, localPkgs, true);
            }
        }
        this.fetchRemotePackages(remotePkgs, remoteSources);
        for (Package p : remotePkgs) {
            if (!(p instanceof ToolPackage) || ((ToolPackage)p).getRevision() < rev) continue;
            for (Archive a : p.getArchives()) {
                if (!a.isCompatible()) continue;
                return this.insertArchive(a, outArchives, selectedArchives, remotePkgs, remoteSources, localPkgs, true);
            }
        }
        return null;
    }

    protected ArchiveInfo findPlatformDependency(AddonPackage addon, ArrayList<ArchiveInfo> outArchives, Collection<Archive> selectedArchives, ArrayList<Package> remotePkgs, RepoSource[] remoteSources, Package[] localPkgs) {
        AndroidVersion v = addon.getVersion();
        for (Package p : localPkgs) {
            if (!(p instanceof PlatformPackage) || !v.equals((Object)((PlatformPackage)p).getVersion())) continue;
            return null;
        }
        for (ArchiveInfo ai : outArchives) {
            Package p = ai.getNewArchive().getParentPackage();
            if (!(p instanceof PlatformPackage) || !v.equals((Object)((PlatformPackage)p).getVersion())) continue;
            return ai;
        }
        if (selectedArchives != null) {
            for (Archive a : selectedArchives) {
                Package p = a.getParentPackage();
                if (!(p instanceof PlatformPackage) || !v.equals((Object)((PlatformPackage)p).getVersion())) continue;
                return this.insertArchive(a, outArchives, selectedArchives, remotePkgs, remoteSources, localPkgs, true);
            }
        }
        this.fetchRemotePackages(remotePkgs, remoteSources);
        for (Package p : remotePkgs) {
            if (!(p instanceof PlatformPackage) || !v.equals((Object)((PlatformPackage)p).getVersion())) continue;
            for (Archive a : p.getArchives()) {
                if (!a.isCompatible()) continue;
                return this.insertArchive(a, outArchives, selectedArchives, remotePkgs, remoteSources, localPkgs, true);
            }
        }
        return null;
    }

    protected void fetchRemotePackages(ArrayList<Package> remotePkgs, RepoSource[] remoteSources) {
        if (remotePkgs.size() > 0) {
            return;
        }
        for (RepoSource remoteSrc : remoteSources) {
            Package[] pkgs = remoteSrc.getPackages();
            if (pkgs == null) continue;
            block1: for (Package pkg : pkgs) {
                for (Archive a : pkg.getArchives()) {
                    if (!a.isCompatible()) continue;
                    remotePkgs.add(pkg);
                    continue block1;
                }
            }
        }
    }
}

