/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.tasks;

import com.android.sdklib.SdkConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

final class ProgressDialog
extends Dialog {
    private static final int MIN_Y = SdkConstants.CURRENT_PLATFORM == 3 ? 20 : 0;
    private CancelMode mCancelMode = CancelMode.ACTIVE;
    private static Point sLastSize;
    private Shell mDialogShell;
    private Composite mRootComposite;
    private Label mLabel;
    private ProgressBar mProgressBar;
    private Button mCancelButton;
    private Text mResultText;
    private final Thread mTaskThread;

    public ProgressDialog(Shell parent, Thread taskThread) {
        super(parent, 65536);
        this.mTaskThread = taskThread;
    }

    public void open() {
        this.createContents();
        this.positionShell();
        this.mDialogShell.open();
        this.mDialogShell.layout();
        this.startThread();
        Display display = this.getParent().getDisplay();
        while (!this.mDialogShell.isDisposed() && this.mCancelMode != CancelMode.CLOSE_AUTO) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.setCancelRequested();
        if (!this.mDialogShell.isDisposed()) {
            sLastSize = this.mDialogShell.getSize();
            this.mDialogShell.close();
        }
    }

    private void createContents() {
        this.mDialogShell = new Shell(this.getParent(), 2160);
        this.mDialogShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ProgressDialog.this.onShellClosed(e);
            }
        });
        this.mDialogShell.setLayout((Layout)new GridLayout(1, false));
        this.mDialogShell.setSize(450, 300);
        this.mDialogShell.setText(this.getText());
        this.mRootComposite = new Composite((Composite)this.mDialogShell, 0);
        this.mRootComposite.setLayout((Layout)new GridLayout(2, false));
        this.mRootComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mLabel = new Label(this.mRootComposite, 0);
        this.mLabel.setText("Task");
        this.mLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.mProgressBar = new ProgressBar(this.mRootComposite, 0);
        this.mProgressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mCancelButton = new Button(this.mRootComposite, 0);
        this.mCancelButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressDialog.this.onCancelSelected();
            }
        });
        this.mResultText = new Text(this.mRootComposite, 2890);
        this.mResultText.setEditable(true);
        this.mResultText.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
    }

    public boolean isCancelRequested() {
        return this.mCancelMode != CancelMode.ACTIVE;
    }

    public void setCancelRequested() {
        if (!this.mDialogShell.isDisposed()) {
            this.mDialogShell.getDisplay().syncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    CancelMode cancelMode = ProgressDialog.this.mCancelMode;
                    synchronized (cancelMode) {
                        if (ProgressDialog.this.mCancelMode == CancelMode.ACTIVE) {
                            ProgressDialog.this.mCancelMode = CancelMode.CANCEL_PENDING;
                            if (!ProgressDialog.this.mCancelButton.isDisposed()) {
                                ProgressDialog.this.mCancelButton.setEnabled(false);
                            }
                        }
                    }
                }
            });
        } else if (this.mCancelMode == CancelMode.ACTIVE) {
            this.mCancelMode = CancelMode.CANCEL_PENDING;
        }
    }

    public void setManualCloseRequested() {
        if (!this.mDialogShell.isDisposed()) {
            this.mDialogShell.getDisplay().syncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    CancelMode cancelMode = ProgressDialog.this.mCancelMode;
                    synchronized (cancelMode) {
                        if (ProgressDialog.this.mCancelMode != CancelMode.CLOSE_MANUAL && ProgressDialog.this.mCancelMode != CancelMode.CLOSE_AUTO) {
                            ProgressDialog.this.mCancelMode = CancelMode.CLOSE_MANUAL;
                            if (!ProgressDialog.this.mCancelButton.isDisposed()) {
                                ProgressDialog.this.mCancelButton.setEnabled(true);
                                ProgressDialog.this.mCancelButton.setText("Close");
                            }
                        }
                    }
                }
            });
        } else if (this.mCancelMode != CancelMode.CLOSE_MANUAL && this.mCancelMode != CancelMode.CLOSE_AUTO) {
            this.mCancelMode = CancelMode.CLOSE_MANUAL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoCloseRequested() {
        CancelMode cancelMode = this.mCancelMode;
        synchronized (cancelMode) {
            if (this.mCancelMode != CancelMode.CLOSE_AUTO) {
                this.mCancelMode = CancelMode.CLOSE_AUTO;
            }
        }
    }

    private void onCancelSelected() {
        if (this.mCancelMode == CancelMode.CLOSE_MANUAL) {
            this.setAutoCloseRequested();
        } else {
            this.setCancelRequested();
        }
    }

    private void onShellClosed(ShellEvent e) {
        if (this.mCancelMode != CancelMode.CLOSE_AUTO) {
            e.doit = false;
            this.onCancelSelected();
        }
    }

    public void setDescription(final String descriptionFormat, final Object ... args) {
        this.mDialogShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (!ProgressDialog.this.mLabel.isDisposed()) {
                    ProgressDialog.this.mLabel.setText(String.format(descriptionFormat, args));
                }
            }
        });
    }

    public void setResult(final String resultFormat, final Object ... args) {
        if (!this.mDialogShell.isDisposed()) {
            this.mDialogShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!ProgressDialog.this.mResultText.isDisposed()) {
                        ProgressDialog.this.mResultText.setVisible(true);
                        String newText = String.format(resultFormat, args);
                        String lastText = ProgressDialog.this.mResultText.getText();
                        if (lastText != null && lastText.length() > 0 && !lastText.endsWith("\n") && !newText.startsWith("\n")) {
                            ProgressDialog.this.mResultText.append("\n");
                        }
                        ProgressDialog.this.mResultText.append(newText);
                    }
                }
            });
        }
    }

    public void setProgressMax(final int max) {
        if (!this.mDialogShell.isDisposed()) {
            this.mDialogShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!ProgressDialog.this.mProgressBar.isDisposed()) {
                        ProgressDialog.this.mProgressBar.setMaximum(max);
                    }
                }
            });
        }
    }

    public void setProgress(final int value) {
        if (!this.mDialogShell.isDisposed()) {
            this.mDialogShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!ProgressDialog.this.mProgressBar.isDisposed()) {
                        ProgressDialog.this.mProgressBar.setSelection(value);
                    }
                }
            });
        }
    }

    public int getProgress() {
        final int[] result = new int[]{0};
        if (!this.mDialogShell.isDisposed()) {
            this.mDialogShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!ProgressDialog.this.mProgressBar.isDisposed()) {
                        result[0] = ProgressDialog.this.mProgressBar.getSelection();
                    }
                }
            });
        }
        return result[0];
    }

    private void startThread() {
        if (this.mTaskThread != null) {
            this.mTaskThread.start();
        }
    }

    private void positionShell() {
        Shell child = this.mDialogShell;
        Shell parent = this.getParent();
        if (child != null && parent != null) {
            int y;
            Rectangle parentArea = parent.getClientArea();
            Point parentLoc = parent.getLocation();
            int px = parentLoc.x;
            int py = parentLoc.y;
            int pw = parentArea.width;
            int ph = parentArea.height;
            Point childSize = sLastSize != null ? sLastSize : child.getSize();
            int cw = childSize.x;
            int ch = childSize.y;
            int x = px + (pw - cw) / 2;
            if (x < 0) {
                x = 0;
            }
            if ((y = py + (ph - ch) / 2) < MIN_Y) {
                y = MIN_Y;
            }
            child.setLocation(x, y);
            child.setSize(cw, ch);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CancelMode {
        ACTIVE,
        CANCEL_PENDING,
        CLOSE_MANUAL,
        CLOSE_AUTO;

    }
}

