/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkConstants;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.internal.widgets.AvdSelector;
import com.android.sdkuilib.internal.widgets.HardwarePropertyChooser;
import com.android.sdkuilib.ui.GridDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

final class AvdCreationDialog
extends GridDialog {
    private final AvdManager mAvdManager;
    private final TreeMap<String, IAndroidTarget> mCurrentTargets = new TreeMap();
    private final Map<String, HardwareProperties.HardwareProperty> mHardwareMap;
    private final Map<String, String> mProperties = new HashMap<String, String>();
    private final ArrayList<String> mEditedProperties = new ArrayList();
    private Text mAvdName;
    private Combo mTargetCombo;
    private Button mSdCardSizeRadio;
    private Text mSdCardSize;
    private Combo mSdCardSizeCombo;
    private Text mSdCardFile;
    private Button mBrowseSdCard;
    private Button mSdCardFileRadio;
    private Button mSkinListRadio;
    private Combo mSkinCombo;
    private Button mSkinSizeRadio;
    private Text mSkinSizeWidth;
    private Text mSkinSizeHeight;
    private TableViewer mHardwareViewer;
    private Button mDeleteHardwareProp;
    private Button mForceCreation;
    private Button mOkButton;
    private Label mStatusIcon;
    private Label mStatusLabel;
    private Composite mStatusComposite;
    private final ImageFactory mImageFactory;
    private final VerifyListener mDigitVerifier = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            int count = event.text.length();
            for (int i = 0; i < count; ++i) {
                char c = event.text.charAt(i);
                if (c >= '0' && c <= '9') continue;
                event.doit = false;
                return;
            }
        }
    };

    protected AvdCreationDialog(Shell parentShell, AvdManager avdManager, ImageFactory imageFactory) {
        super(parentShell, 2, false);
        this.mAvdManager = avdManager;
        this.mImageFactory = imageFactory;
        File hardwareDefs = new File(avdManager.getSdkManager().getLocation() + File.separator + SdkConstants.OS_SDK_TOOLS_LIB_FOLDER, "hardware-properties.ini");
        this.mHardwareMap = HardwareProperties.parseHardwareDefinitions((File)hardwareDefs, null);
    }

    public void create() {
        super.create();
        Point p = this.getShell().getSize();
        if (p.x < 400) {
            p.x = 400;
        }
        this.getShell().setSize(p);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setText("Create new AVD");
        this.mOkButton = this.getButton(0);
        this.validatePage();
        return control;
    }

    public void createDialogContent(final Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Name:");
        this.mAvdName = new Text(parent, 2048);
        this.mAvdName.setLayoutData((Object)new GridData(768));
        this.mAvdName.addModifyListener((ModifyListener)new CreateNameModifyListener());
        label = new Label(parent, 0);
        label.setText("Target:");
        this.mTargetCombo = new Combo(parent, 12);
        this.mTargetCombo.setLayoutData((Object)new GridData(768));
        this.mTargetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                AvdCreationDialog.this.reloadSkinCombo();
                AvdCreationDialog.this.validatePage();
            }
        });
        label = new Label(parent, 0);
        label.setText("SD Card:");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        Group sdCardGroup = new Group(parent, 0);
        sdCardGroup.setLayoutData((Object)new GridData(768));
        sdCardGroup.setLayout((Layout)new GridLayout(3, false));
        this.mSdCardSizeRadio = new Button((Composite)sdCardGroup, 16);
        this.mSdCardSizeRadio.setText("Size:");
        this.mSdCardSizeRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                boolean sizeMode = AvdCreationDialog.this.mSdCardSizeRadio.getSelection();
                AvdCreationDialog.this.enableSdCardWidgets(sizeMode);
                AvdCreationDialog.this.validatePage();
            }
        });
        ValidateListener validateListener = new ValidateListener();
        this.mSdCardSize = new Text((Composite)sdCardGroup, 2048);
        this.mSdCardSize.setLayoutData((Object)new GridData(768));
        this.mSdCardSize.addVerifyListener(this.mDigitVerifier);
        this.mSdCardSizeCombo = new Combo((Composite)sdCardGroup, 12);
        this.mSdCardSizeCombo.add("KiB");
        this.mSdCardSizeCombo.add("MiB");
        this.mSdCardSizeCombo.select(1);
        this.mSdCardFileRadio = new Button((Composite)sdCardGroup, 16);
        this.mSdCardFileRadio.setText("File:");
        this.mSdCardFile = new Text((Composite)sdCardGroup, 2048);
        this.mSdCardFile.setLayoutData((Object)new GridData(768));
        this.mSdCardFile.addModifyListener((ModifyListener)validateListener);
        this.mBrowseSdCard = new Button((Composite)sdCardGroup, 8);
        this.mBrowseSdCard.setText("Browse...");
        this.mBrowseSdCard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AvdCreationDialog.this.onBrowseSdCard();
                AvdCreationDialog.this.validatePage();
            }
        });
        this.mSdCardSizeRadio.setSelection(true);
        this.enableSdCardWidgets(true);
        label = new Label(parent, 0);
        label.setText("Skin:");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        Group skinGroup = new Group(parent, 0);
        skinGroup.setLayoutData((Object)new GridData(768));
        skinGroup.setLayout((Layout)new GridLayout(4, false));
        this.mSkinListRadio = new Button((Composite)skinGroup, 16);
        this.mSkinListRadio.setText("Built-in:");
        this.mSkinListRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                boolean listMode = AvdCreationDialog.this.mSkinListRadio.getSelection();
                AvdCreationDialog.this.enableSkinWidgets(listMode);
                AvdCreationDialog.this.validatePage();
            }
        });
        this.mSkinCombo = new Combo((Composite)skinGroup, 12);
        GridData gd = new GridData(768);
        this.mSkinCombo.setLayoutData((Object)gd);
        gd.horizontalSpan = 3;
        this.mSkinCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AvdCreationDialog.this.loadSkin();
            }
        });
        this.mSkinSizeRadio = new Button((Composite)skinGroup, 16);
        this.mSkinSizeRadio.setText("Resolution:");
        this.mSkinSizeWidth = new Text((Composite)skinGroup, 2048);
        this.mSkinSizeWidth.setLayoutData((Object)new GridData(768));
        this.mSkinSizeWidth.addVerifyListener(this.mDigitVerifier);
        this.mSkinSizeWidth.addModifyListener((ModifyListener)validateListener);
        new Label((Composite)skinGroup, 0).setText("x");
        this.mSkinSizeHeight = new Text((Composite)skinGroup, 2048);
        this.mSkinSizeHeight.setLayoutData((Object)new GridData(768));
        this.mSkinSizeHeight.addVerifyListener(this.mDigitVerifier);
        this.mSkinSizeHeight.addModifyListener((ModifyListener)validateListener);
        this.mSkinListRadio.setSelection(true);
        this.enableSkinWidgets(true);
        label = new Label(parent, 0);
        label.setText("Hardware:");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        Group hwGroup = new Group(parent, 0);
        hwGroup.setLayoutData((Object)new GridData(768));
        hwGroup.setLayout((Layout)new GridLayout(2, false));
        this.createHardwareTable((Composite)hwGroup);
        Composite hwButtons = new Composite((Composite)hwGroup, 0);
        hwButtons.setLayoutData((Object)new GridData(1040));
        GridLayout gl = new GridLayout(1, false);
        hwButtons.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        Button b = new Button(hwButtons, 0x800008);
        b.setText("New...");
        b.setLayoutData((Object)new GridData(768));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HardwareProperties.HardwareProperty choice;
                HardwarePropertyChooser dialog = new HardwarePropertyChooser(parent.getShell(), AvdCreationDialog.this.mHardwareMap, AvdCreationDialog.this.mProperties.keySet());
                if (dialog.open() == 0 && (choice = dialog.getProperty()) != null) {
                    AvdCreationDialog.this.mProperties.put(choice.getName(), choice.getDefault());
                    AvdCreationDialog.this.mHardwareViewer.refresh();
                }
            }
        });
        this.mDeleteHardwareProp = new Button(hwButtons, 0x800008);
        this.mDeleteHardwareProp.setText("Delete");
        this.mDeleteHardwareProp.setLayoutData((Object)new GridData(768));
        this.mDeleteHardwareProp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ISelection selection = AvdCreationDialog.this.mHardwareViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    String hwName = (String)((IStructuredSelection)selection).getFirstElement();
                    AvdCreationDialog.this.mProperties.remove(hwName);
                    AvdCreationDialog.this.mHardwareViewer.refresh();
                }
            }
        });
        this.mDeleteHardwareProp.setEnabled(false);
        this.mForceCreation = new Button(parent, 32);
        this.mForceCreation.setText("Force create");
        this.mForceCreation.setToolTipText("Select this to override any existing AVD");
        this.mForceCreation.setLayoutData((Object)new GridData(3, 2, true, false, 2, 1));
        this.mForceCreation.setEnabled(false);
        this.mForceCreation.addSelectionListener((SelectionListener)validateListener);
        label = new Label(parent, 258);
        label.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        this.mStatusComposite = new Composite(parent, 0);
        this.mStatusComposite.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        gl = new GridLayout(2, false);
        this.mStatusComposite.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.mStatusIcon = new Label(this.mStatusComposite, 0);
        this.mStatusIcon.setLayoutData((Object)new GridData(1, 1, false, false));
        this.mStatusLabel = new Label(this.mStatusComposite, 0);
        this.mStatusLabel.setLayoutData((Object)new GridData(768));
        this.mStatusLabel.setText(" \n ");
        this.reloadTargetCombo();
    }

    private void createHardwareTable(Composite parent) {
        final Table hardwareTable = new Table(parent, 65540);
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        gd.heightHint = 100;
        hardwareTable.setLayoutData((Object)gd);
        hardwareTable.setHeaderVisible(true);
        hardwareTable.setLinesVisible(true);
        this.mHardwareViewer = new TableViewer(hardwareTable);
        this.mHardwareViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AvdCreationDialog.this.mDeleteHardwareProp.setEnabled(hardwareTable.getSelectionIndex() != -1);
            }
        });
        this.mHardwareViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object arg0) {
                return AvdCreationDialog.this.mProperties.keySet().toArray();
            }

            public void dispose() {
            }
        });
        TableColumn col1 = new TableColumn(hardwareTable, 16384);
        col1.setText("Property");
        col1.setWidth(150);
        TableViewerColumn tvc1 = new TableViewerColumn(this.mHardwareViewer, col1);
        tvc1.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                HardwareProperties.HardwareProperty prop = (HardwareProperties.HardwareProperty)AvdCreationDialog.this.mHardwareMap.get(cell.getElement());
                cell.setText(prop != null ? prop.getAbstract() : "");
            }
        });
        TableColumn col2 = new TableColumn(hardwareTable, 16384);
        col2.setText("Value");
        col2.setWidth(50);
        TableViewerColumn tvc2 = new TableViewerColumn(this.mHardwareViewer, col2);
        tvc2.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                String value = (String)AvdCreationDialog.this.mProperties.get(cell.getElement());
                cell.setText(value != null ? value : "");
            }
        });
        tvc2.setEditingSupport(new EditingSupport((ColumnViewer)this.mHardwareViewer){

            protected void setValue(Object element, Object value) {
                String hardwareName = (String)element;
                HardwareProperties.HardwareProperty property = (HardwareProperties.HardwareProperty)AvdCreationDialog.this.mHardwareMap.get(hardwareName);
                switch (property.getType()) {
                    case INTEGER: {
                        AvdCreationDialog.this.mProperties.put((String)element, (String)value);
                        break;
                    }
                    case DISKSIZE: {
                        if (!HardwareProperties.DISKSIZE_PATTERN.matcher((String)value).matches()) break;
                        AvdCreationDialog.this.mProperties.put((String)element, (String)value);
                        break;
                    }
                    case BOOLEAN: {
                        int index = (Integer)value;
                        AvdCreationDialog.this.mProperties.put((String)element, HardwareProperties.BOOLEAN_VALUES[index]);
                    }
                }
                AvdCreationDialog.this.mHardwareViewer.refresh(element);
            }

            protected Object getValue(Object element) {
                String hardwareName = (String)element;
                HardwareProperties.HardwareProperty property = (HardwareProperties.HardwareProperty)AvdCreationDialog.this.mHardwareMap.get(hardwareName);
                String value = (String)AvdCreationDialog.this.mProperties.get(hardwareName);
                switch (property.getType()) {
                    case INTEGER: 
                    case DISKSIZE: {
                        return value;
                    }
                    case BOOLEAN: {
                        return HardwareProperties.getBooleanValueIndex((String)value);
                    }
                }
                return null;
            }

            protected CellEditor getCellEditor(Object element) {
                String hardwareName = (String)element;
                HardwareProperties.HardwareProperty property = (HardwareProperties.HardwareProperty)AvdCreationDialog.this.mHardwareMap.get(hardwareName);
                switch (property.getType()) {
                    case INTEGER: 
                    case DISKSIZE: {
                        return new TextCellEditor((Composite)hardwareTable);
                    }
                    case BOOLEAN: {
                        return new ComboBoxCellEditor((Composite)hardwareTable, HardwareProperties.BOOLEAN_VALUES, 12);
                    }
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                String hardwareName = (String)element;
                HardwareProperties.HardwareProperty property = (HardwareProperties.HardwareProperty)AvdCreationDialog.this.mHardwareMap.get(hardwareName);
                return property != null;
            }
        });
        this.mHardwareViewer.setInput(this.mProperties);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = "Create AVD";
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected void okPressed() {
        if (this.createAvd()) {
            super.okPressed();
        }
    }

    private void enableSdCardWidgets(boolean sizeMode) {
        this.mSdCardSize.setEnabled(sizeMode);
        this.mSdCardSizeCombo.setEnabled(sizeMode);
        this.mSdCardFile.setEnabled(!sizeMode);
        this.mBrowseSdCard.setEnabled(!sizeMode);
    }

    private void enableSkinWidgets(boolean listMode) {
        this.mSkinCombo.setEnabled(listMode);
        this.mSkinSizeWidth.setEnabled(!listMode);
        this.mSkinSizeHeight.setEnabled(!listMode);
    }

    private void onBrowseSdCard() {
        FileDialog dlg = new FileDialog(this.getContents().getShell(), 4096);
        dlg.setText("Choose SD Card image file.");
        String fileName = dlg.open();
        if (fileName != null) {
            this.mSdCardFile.setText(fileName);
        }
    }

    private void reloadTargetCombo() {
        String selected = null;
        int index = this.mTargetCombo.getSelectionIndex();
        if (index >= 0) {
            selected = this.mTargetCombo.getItem(index);
        }
        this.mCurrentTargets.clear();
        this.mTargetCombo.removeAll();
        boolean found = false;
        index = -1;
        SdkManager sdkManager = this.mAvdManager.getSdkManager();
        if (sdkManager != null) {
            for (IAndroidTarget target : sdkManager.getTargets()) {
                String name = target.isPlatform() ? String.format("%s - API Level %s", target.getName(), target.getVersion().getApiString()) : String.format("%s (%s) - API Level %s", target.getName(), target.getVendor(), target.getVersion().getApiString());
                this.mCurrentTargets.put(name, target);
                this.mTargetCombo.add(name);
                if (found) continue;
                ++index;
                found = name.equals(selected);
            }
        }
        this.mTargetCombo.setEnabled(this.mCurrentTargets.size() > 0);
        if (found) {
            this.mTargetCombo.select(index);
        }
        this.reloadSkinCombo();
    }

    private void reloadSkinCombo() {
        String selected = null;
        int index = this.mSkinCombo.getSelectionIndex();
        if (index >= 0) {
            selected = this.mSkinCombo.getItem(index);
        }
        this.mSkinCombo.removeAll();
        this.mSkinCombo.setEnabled(false);
        index = this.mTargetCombo.getSelectionIndex();
        if (index >= 0) {
            String targetName = this.mTargetCombo.getItem(index);
            boolean found = false;
            IAndroidTarget target = this.mCurrentTargets.get(targetName);
            if (target != null) {
                this.mSkinCombo.add(String.format("Default (%s)", target.getDefaultSkin()));
                index = -1;
                for (String skin : target.getSkins()) {
                    this.mSkinCombo.add(skin);
                    if (found) continue;
                    ++index;
                    found = skin.equals(selected);
                }
                this.mSkinCombo.setEnabled(true);
                if (found) {
                    this.mSkinCombo.select(index);
                } else {
                    this.mSkinCombo.select(0);
                    this.loadSkin();
                }
            }
        }
    }

    private void validatePage() {
        boolean can_create;
        AvdManager.AvdInfo avdMatch;
        String sdName;
        boolean sdcardFileMode;
        boolean hasAvdName;
        String error = null;
        String avdName = this.mAvdName.getText().trim();
        boolean bl = hasAvdName = avdName.length() > 0;
        if (hasAvdName && !AvdManager.RE_AVD_NAME.matcher(avdName).matches()) {
            error = String.format("AVD name '%1$s' contains invalid characters.\nAllowed characters are: %2$s", avdName, "a-z A-Z 0-9 . _ -");
        }
        if (hasAvdName && error == null && this.mTargetCombo.getSelectionIndex() < 0) {
            error = "A target must be selected in order to create an AVD.";
        }
        if (error == null && (sdcardFileMode = this.mSdCardFileRadio.getSelection()) && (sdName = this.mSdCardFile.getText().trim()).length() > 0 && !new File(sdName).isFile()) {
            error = "SD Card path isn't valid.";
        }
        if (error == null && this.mSkinSizeRadio.getSelection()) {
            String width = this.mSkinSizeWidth.getText();
            String height = this.mSkinSizeHeight.getText();
            if (width.length() == 0 || height.length() == 0) {
                error = "Skin size is incorrect.\nBoth dimensions must be > 0";
            }
        }
        if (hasAvdName && error == null && (avdMatch = this.mAvdManager.getAvd(avdName, false)) != null && !this.mForceCreation.getSelection()) {
            error = String.format("The AVD name '%s' is already used.\nCheck \"Force create\" to override existing AVD.", avdName);
        }
        boolean bl2 = can_create = hasAvdName && error == null;
        if (can_create) {
            can_create &= this.mTargetCombo.getSelectionIndex() >= 0;
        }
        this.mOkButton.setEnabled(can_create);
        if (error != null) {
            this.mStatusIcon.setImage(this.mImageFactory.getImageByName("reject_icon16.png"));
            this.mStatusLabel.setText(error);
        } else {
            this.mStatusIcon.setImage(null);
            this.mStatusLabel.setText(" \n ");
        }
        this.mStatusComposite.pack(true);
    }

    private void loadSkin() {
        Map skinHardwareConfig;
        File skinHardwareFile;
        Map targetHardwareConfig;
        File targetHardwareFile;
        int targetIndex = this.mTargetCombo.getSelectionIndex();
        if (targetIndex < 0) {
            return;
        }
        String targetName = this.mTargetCombo.getItem(targetIndex);
        IAndroidTarget target = this.mCurrentTargets.get(targetName);
        if (target == null) {
            return;
        }
        String skinName = null;
        int skinIndex = this.mSkinCombo.getSelectionIndex();
        if (skinIndex < 0) {
            return;
        }
        skinName = skinIndex == 0 ? target.getDefaultSkin() : this.mSkinCombo.getItem(skinIndex);
        String path = target.getPath(5);
        File skin = new File(path, skinName);
        if (!skin.isDirectory() && !target.isPlatform()) {
            path = target.getParent().getPath(5);
            skin = new File(path, skinName);
        }
        if (!skin.isDirectory()) {
            return;
        }
        HashMap hardwareValues = new HashMap();
        if (!target.isPlatform() && (targetHardwareFile = new File(target.getLocation(), "hardware.ini")).isFile() && (targetHardwareConfig = SdkManager.parsePropertyFile((File)targetHardwareFile, null)) != null) {
            hardwareValues.putAll(targetHardwareConfig);
        }
        if ((skinHardwareFile = new File(skin, "hardware.ini")).isFile() && (skinHardwareConfig = SdkManager.parsePropertyFile((File)skinHardwareFile, null)) != null) {
            hardwareValues.putAll(skinHardwareConfig);
        }
        for (Map.Entry entry : hardwareValues.entrySet()) {
            if (this.mEditedProperties.contains(entry.getKey())) continue;
            this.mProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        this.mHardwareViewer.refresh();
    }

    private boolean createAvd() {
        File avdFolder;
        String avdName = this.mAvdName.getText().trim();
        int targetIndex = this.mTargetCombo.getSelectionIndex();
        if (avdName.length() == 0 || targetIndex < 0) {
            return false;
        }
        String targetName = this.mTargetCombo.getItem(targetIndex);
        IAndroidTarget target = this.mCurrentTargets.get(targetName);
        if (target == null) {
            return false;
        }
        String sdName = null;
        if (this.mSdCardSizeRadio.getSelection()) {
            String value = this.mSdCardSize.getText().trim();
            if (value.length() > 0) {
                sdName = value;
                switch (this.mSdCardSizeCombo.getSelectionIndex()) {
                    case 0: {
                        sdName = sdName + "K";
                        break;
                    }
                    case 1: {
                        sdName = sdName + "M";
                        break;
                    }
                    default: {
                        assert (false);
                        {
                            break;
                        }
                    }
                }
            }
        } else {
            sdName = this.mSdCardFile.getText().trim();
        }
        String skinName = null;
        if (this.mSkinListRadio.getSelection()) {
            int skinIndex = this.mSkinCombo.getSelectionIndex();
            if (skinIndex > 0) {
                skinName = this.mSkinCombo.getItem(skinIndex);
            }
        } else {
            skinName = this.mSkinSizeWidth.getText() + "x" + this.mSkinSizeHeight.getText();
        }
        AvdSelector.SdkLog log = new AvdSelector.SdkLog(String.format("Result of creating AVD '%s':", avdName), this.getContents().getDisplay());
        try {
            avdFolder = new File(AndroidLocation.getFolder() + "avd", avdName + ".avd");
        }
        catch (AndroidLocation.AndroidLocationException e) {
            return false;
        }
        boolean force = this.mForceCreation.getSelection();
        boolean success = false;
        AvdManager.AvdInfo avdInfo = this.mAvdManager.createAvd(avdFolder, avdName, target, skinName, sdName, this.mProperties, force, (ISdkLog)log);
        success = avdInfo != null;
        log.displayResult(success);
        return success;
    }

    private class ValidateListener
    extends SelectionAdapter
    implements ModifyListener {
        private ValidateListener() {
        }

        public void modifyText(ModifyEvent e) {
            AvdCreationDialog.this.validatePage();
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            AvdCreationDialog.this.validatePage();
        }
    }

    private class CreateNameModifyListener
    implements ModifyListener {
        private CreateNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String name = AvdCreationDialog.this.mAvdName.getText().trim();
            AvdManager.AvdInfo avdMatch = AvdCreationDialog.this.mAvdManager.getAvd(name, false);
            if (avdMatch != null) {
                AvdCreationDialog.this.mForceCreation.setEnabled(true);
            } else {
                AvdCreationDialog.this.mForceCreation.setEnabled(false);
                AvdCreationDialog.this.mForceCreation.setSelection(false);
            }
            AvdCreationDialog.this.validatePage();
        }
    }
}

