/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdkuilib.ui.GridDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HardwarePropertyChooser
extends GridDialog {
    private final Map<String, HardwareProperties.HardwareProperty> mProperties;
    private final Collection<String> mExceptProperties;
    private HardwareProperties.HardwareProperty mChosenProperty;
    private Label mTypeLabel;
    private Label mDescriptionLabel;

    HardwarePropertyChooser(Shell parentShell, Map<String, HardwareProperties.HardwareProperty> properties, Collection<String> exceptProperties) {
        super(parentShell, 2, false);
        this.mProperties = properties;
        this.mExceptProperties = exceptProperties;
    }

    public HardwareProperties.HardwareProperty getProperty() {
        return this.mChosenProperty;
    }

    @Override
    public void createDialogContent(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText("Property:");
        final Combo c = new Combo(parent, 12);
        final ArrayList<String> indexToName = new ArrayList<String>();
        for (Map.Entry<String, HardwareProperties.HardwareProperty> entry : this.mProperties.entrySet()) {
            if (this.mExceptProperties.contains(entry.getKey())) continue;
            c.add(entry.getValue().getAbstract());
            indexToName.add(entry.getKey());
        }
        boolean hasValues = true;
        if (indexToName.size() == 0) {
            hasValues = false;
            c.add("No properties");
            c.select(0);
            c.setEnabled(false);
        }
        c.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = c.getSelectionIndex();
                String name = (String)indexToName.get(index);
                HardwarePropertyChooser.this.processSelection(name, true);
            }
        });
        l = new Label(parent, 0);
        l.setText("Type:");
        this.mTypeLabel = new Label(parent, 0);
        l = new Label(parent, 0);
        l.setText("Description:");
        this.mDescriptionLabel = new Label(parent, 0);
        if (hasValues) {
            c.select(0);
            this.processSelection((String)indexToName.get(0), false);
        }
    }

    private void processSelection(String name, boolean pack) {
        this.mChosenProperty = this.mProperties.get(name);
        this.mTypeLabel.setText(this.mChosenProperty.getType().getValue());
        String desc = this.mChosenProperty.getDescription();
        if (desc != null) {
            this.mDescriptionLabel.setText(this.mChosenProperty.getDescription());
        } else {
            this.mDescriptionLabel.setText("N/A");
        }
        if (pack) {
            this.getShell().pack();
        }
    }
}

