/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.sdklib.IAndroidTarget;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SdkTargetSelector {
    private IAndroidTarget[] mTargets;
    private final boolean mAllowSelection;
    private SelectionListener mSelectionListener;
    private Table mTable;
    private Label mDescription;
    private Composite mInnerGroup;

    public SdkTargetSelector(Composite parent, IAndroidTarget[] targets) {
        this(parent, targets, true);
    }

    public SdkTargetSelector(Composite parent, IAndroidTarget[] targets, boolean allowSelection) {
        this.mInnerGroup = new Composite(parent, 0);
        this.mInnerGroup.setLayout((Layout)new GridLayout());
        this.mInnerGroup.setLayoutData((Object)new GridData(1808));
        this.mInnerGroup.setFont(parent.getFont());
        this.mAllowSelection = allowSelection;
        int style = 67588;
        if (allowSelection) {
            style |= 0x20;
        }
        this.mTable = new Table(this.mInnerGroup, style);
        this.mTable.setHeaderVisible(true);
        this.mTable.setLinesVisible(false);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.mTable.setLayoutData((Object)data);
        this.mDescription = new Label(this.mInnerGroup, 64);
        this.mDescription.setLayoutData((Object)new GridData(768));
        TableColumn column0 = new TableColumn(this.mTable, 0);
        column0.setText("Target Name");
        TableColumn column1 = new TableColumn(this.mTable, 0);
        column1.setText("Vendor");
        TableColumn column2 = new TableColumn(this.mTable, 0);
        column2.setText("Platform");
        TableColumn column3 = new TableColumn(this.mTable, 0);
        column3.setText("API Level");
        this.adjustColumnsWidth(this.mTable, column0, column1, column2, column3);
        this.setupSelectionListener(this.mTable);
        this.setTargets(targets);
        this.setupTooltip(this.mTable);
    }

    public Object getLayoutData() {
        return this.mInnerGroup.getLayoutData();
    }

    public IAndroidTarget[] getTargets() {
        return this.mTargets;
    }

    public void setTargets(IAndroidTarget[] targets) {
        this.mTargets = targets;
        this.fillTable(this.mTable);
    }

    public void setSelectionListener(SelectionListener selectionListener) {
        this.mSelectionListener = selectionListener;
    }

    public boolean setSelection(IAndroidTarget target) {
        if (!this.mAllowSelection) {
            return false;
        }
        boolean found = false;
        boolean modified = false;
        if (this.mTable != null && !this.mTable.isDisposed()) {
            for (TableItem i : this.mTable.getItems()) {
                if ((IAndroidTarget)i.getData() == target) {
                    found = true;
                    if (i.getChecked()) continue;
                    modified = true;
                    i.setChecked(true);
                    continue;
                }
                if (!i.getChecked()) continue;
                modified = true;
                i.setChecked(false);
            }
        }
        if (modified && this.mSelectionListener != null) {
            this.mSelectionListener.widgetSelected(null);
        }
        return found;
    }

    public IAndroidTarget getSelected() {
        if (this.mTable == null || this.mTable.isDisposed()) {
            return null;
        }
        for (TableItem i : this.mTable.getItems()) {
            if (!i.getChecked()) continue;
            return (IAndroidTarget)i.getData();
        }
        return null;
    }

    private void adjustColumnsWidth(final Table table, final TableColumn column0, final TableColumn column1, final TableColumn column2, final TableColumn column3) {
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = table.getClientArea();
                column0.setWidth(r.width * 30 / 100);
                column1.setWidth(r.width * 45 / 100);
                column2.setWidth(r.width * 15 / 100);
                column3.setWidth(r.width * 10 / 100);
            }
        });
    }

    private void setupSelectionListener(Table table) {
        if (!this.mAllowSelection) {
            return;
        }
        table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    TableItem i;
                    i.setChecked(!(i = (TableItem)e.item).getChecked());
                    this.enforceSingleSelection(i);
                    SdkTargetSelector.this.updateDescription(i);
                }
                if (SdkTargetSelector.this.mSelectionListener != null) {
                    SdkTargetSelector.this.mSelectionListener.widgetDefaultSelected(e);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    TableItem i = (TableItem)e.item;
                    this.enforceSingleSelection(i);
                    SdkTargetSelector.this.updateDescription(i);
                }
                if (SdkTargetSelector.this.mSelectionListener != null) {
                    SdkTargetSelector.this.mSelectionListener.widgetSelected(e);
                }
            }

            private void enforceSingleSelection(TableItem item) {
                if (item.getChecked()) {
                    Table parentTable = item.getParent();
                    for (TableItem i2 : parentTable.getItems()) {
                        if (i2 == item || !i2.getChecked()) continue;
                        i2.setChecked(false);
                    }
                }
            }
        });
    }

    private void fillTable(Table table) {
        if (table == null || table.isDisposed()) {
            return;
        }
        table.removeAll();
        if (this.mTargets != null && this.mTargets.length > 0) {
            table.setEnabled(true);
            for (IAndroidTarget target : this.mTargets) {
                TableItem item = new TableItem(table, 0);
                item.setData((Object)target);
                item.setText(0, target.getName());
                item.setText(1, target.getVendor());
                item.setText(2, target.getVersionName());
                item.setText(3, target.getVersion().getApiString());
            }
        } else {
            table.setEnabled(false);
            TableItem item = new TableItem(table, 0);
            item.setData(null);
            item.setText(0, "--");
            item.setText(1, "No target available");
            item.setText(2, "--");
            item.setText(3, "--");
        }
    }

    private void setupTooltip(final Table table) {
        if (table == null || table.isDisposed()) {
            return;
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 3: 
                    case 7: {
                        return;
                    }
                    case 32: {
                        SdkTargetSelector.this.updateDescription(table.getItem(new Point(event.x, event.y)));
                        break;
                    }
                    case 13: {
                        if (!(event.item instanceof TableItem)) break;
                        SdkTargetSelector.this.updateDescription((TableItem)event.item);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        };
        table.addListener(12, listener);
        table.addListener(1, listener);
        table.addListener(5, listener);
        table.addListener(32, listener);
    }

    private void updateDescription(TableItem item) {
        Object data;
        if (item != null && (data = item.getData()) instanceof IAndroidTarget) {
            String newTooltip = ((IAndroidTarget)data).getDescription();
            this.mDescription.setText(newTooltip == null ? "" : newTooltip);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.mInnerGroup != null && this.mTable != null && !this.mTable.isDisposed()) {
            this.enableControl((Control)this.mInnerGroup, enabled);
        }
    }

    private void enableControl(Control c, boolean enabled) {
        c.setEnabled(enabled);
        if (c instanceof Composite) {
            for (Control c2 : ((Composite)c).getChildren()) {
                this.enableControl(c2, enabled);
            }
        }
    }
}

