/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.apkbuilder.ApkBuilder;
import com.android.apkbuilder.internal.ApkBuilderImpl;
import com.android.sdklib.internal.project.ApkConfigurationHelper;
import com.android.sdklib.internal.project.ApkSettings;
import com.android.sdklib.internal.project.ProjectProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class ApkBuilderTask
extends Task {
    private static final String REF_APK_PATH = "android.apks.path";
    private String mOutFolder;
    private String mBaseName;
    private boolean mVerbose = false;
    private boolean mSigned = true;
    private final ArrayList<Value> mZipList = new ArrayList();
    private final ArrayList<Value> mFileList = new ArrayList();
    private final ArrayList<Value> mSourceList = new ArrayList();
    private final ArrayList<Value> mJarfolderList = new ArrayList();
    private final ArrayList<Value> mJarfileList = new ArrayList();
    private final ArrayList<Value> mNativeList = new ArrayList();
    private final ArrayList<FileInputStream> mZipArchives = new ArrayList();
    private final ArrayList<File> mArchiveFiles = new ArrayList();
    private final ArrayList<ApkBuilderImpl.ApkFile> mJavaResources = new ArrayList();
    private final ArrayList<FileInputStream> mResourcesJars = new ArrayList();
    private final ArrayList<ApkBuilderImpl.ApkFile> mNativeLibraries = new ArrayList();

    public void setOutfolder(Path outFolder) {
        this.mOutFolder = outFolder.toString();
    }

    public void setBasename(String baseName) {
        this.mBaseName = baseName;
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public void setSigned(boolean signed) {
        this.mSigned = signed;
    }

    public Object createZip() {
        Value zip = new Value();
        this.mZipList.add(zip);
        return zip;
    }

    public Object createFile() {
        Value file = new Value();
        this.mFileList.add(file);
        return file;
    }

    public Object createSourcefolder() {
        Value file = new Value();
        this.mSourceList.add(file);
        return file;
    }

    public Object createJarfolder() {
        Value file = new Value();
        this.mJarfolderList.add(file);
        return file;
    }

    public Object createJarfile() {
        Value file = new Value();
        this.mJarfileList.add(file);
        return file;
    }

    public Object createNativefolder() {
        Value file = new Value();
        this.mNativeList.add(file);
        return file;
    }

    public void execute() throws BuildException {
        Project antProject = this.getProject();
        ApkBuilderImpl apkBuilder = new ApkBuilderImpl();
        apkBuilder.setVerbose(this.mVerbose);
        apkBuilder.setSignedPackage(this.mSigned);
        try {
            Map apkFilters;
            for (Value v : this.mZipList) {
                FileInputStream input = new FileInputStream(v.mPath);
                this.mZipArchives.add(input);
            }
            for (Value v : this.mFileList) {
                this.mArchiveFiles.add(ApkBuilderImpl.getInputFile((String)v.mPath));
            }
            for (Value v : this.mSourceList) {
                ApkBuilderImpl.processSourceFolderForResource((String)v.mPath, this.mJavaResources);
            }
            for (Value v : this.mJarfolderList) {
                ApkBuilderImpl.processJarFolder((String)v.mPath, this.mResourcesJars);
            }
            for (Value v : this.mJarfileList) {
                ApkBuilderImpl.processJarFile((String)v.mPath, this.mResourcesJars);
            }
            for (Value v : this.mNativeList) {
                String parameter = v.mPath;
                File f = new File(parameter);
                int offset = parameter.length();
                if (!parameter.endsWith(File.separator)) {
                    ++offset;
                }
                ApkBuilderImpl.processNativeFolder((int)offset, (File)f, this.mNativeLibraries);
            }
            Path path = new Path(antProject);
            String debugPackageSuffix = "-debug-unaligned.apk";
            if (antProject.getProperty("out.debug.unaligned.package") == null && antProject.getProperty("out-debug-unaligned-package") == null) {
                debugPackageSuffix = "-debug.apk";
            }
            this.createApk(apkBuilder, null, null, path, debugPackageSuffix);
            File baseDir = antProject.getBaseDir();
            ProjectProperties properties = ProjectProperties.load((String)baseDir.getAbsolutePath(), (ProjectProperties.PropertyType)ProjectProperties.PropertyType.DEFAULT);
            ApkSettings apkSettings = ApkConfigurationHelper.getSettings((ProjectProperties)properties);
            if (apkSettings != null && (apkFilters = apkSettings.getResourceFilters()).size() > 0) {
                for (Map.Entry entry : apkFilters.entrySet()) {
                    this.createApk(apkBuilder, (String)entry.getKey(), (String)entry.getValue(), path, debugPackageSuffix);
                }
            }
            antProject.addReference(REF_APK_PATH, (Object)path);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BuildException((Throwable)e);
        }
        catch (ApkBuilder.ApkCreationException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void createApk(ApkBuilderImpl apkBuilder, String configName, String resourceFilter, Path path, String debugPackageSuffix) throws FileNotFoundException, ApkBuilder.ApkCreationException {
        String filename = configName != null && resourceFilter != null ? this.mBaseName + "-" + configName + ".ap_" : this.mBaseName + ".ap_";
        FileInputStream resoucePackageZipFile = new FileInputStream(new File(this.mOutFolder, filename));
        this.mZipArchives.add(resoucePackageZipFile);
        filename = configName != null && resourceFilter != null ? this.mBaseName + "-" + configName : this.mBaseName;
        filename = this.mSigned ? filename + debugPackageSuffix : filename + "-unsigned.apk";
        if (configName == null || resourceFilter == null) {
            if (this.mSigned) {
                System.out.println(String.format("Creating %s and signing it with a debug key...", filename));
            } else {
                System.out.println(String.format("Creating %s for release...", filename));
            }
        } else if (this.mSigned) {
            System.out.println(String.format("Creating %1$s (with %2$s) and signing it with a debug key...", filename, resourceFilter));
        } else {
            System.out.println(String.format("Creating %1$s (with %2$s) for release...", filename, resourceFilter));
        }
        File f = new File(this.mOutFolder, filename);
        Path.PathElement element = path.createPathElement();
        element.setLocation(f);
        apkBuilder.createPackage(f.getAbsoluteFile(), this.mZipArchives, this.mArchiveFiles, this.mJavaResources, this.mResourcesJars, this.mNativeLibraries);
        this.mZipArchives.remove(resoucePackageZipFile);
    }

    public static final class Value
    extends ProjectComponent {
        String mPath;

        public void setPath(Path path) {
            this.mPath = path.toString();
        }
    }
}

