/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.scene;

import com.android.ddmlib.IDevice;
import com.android.hierarchyviewer.device.DeviceBridge;
import com.android.hierarchyviewer.device.Window;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;

public class ViewManager {
    public static void invalidate(IDevice device, Window window, String params) {
        ViewManager.sendCommand("INVALIDATE", device, window, params);
    }

    public static void requestLayout(IDevice device, Window window, String params) {
        ViewManager.sendCommand("REQUEST_LAYOUT", device, window, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendCommand(String command, IDevice device, Window window, String params) {
        Socket socket = null;
        BufferedWriter out = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress("127.0.0.1", DeviceBridge.getDeviceLocalPort(device)));
            out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            out.write(command + " " + window.encode() + " " + params);
            out.newLine();
            out.flush();
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

