/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.ui;

import com.android.hierarchyviewer.scene.ViewNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class CaptureRenderer
extends JLabel {
    private ViewNode node;
    private boolean showExtras;

    CaptureRenderer(ImageIcon icon, ViewNode node) {
        super(icon);
        this.node = node;
        this.setBackground(Color.BLACK);
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.node.hasMargins) {
            d.width += this.node.marginLeft + this.node.marginRight;
            d.height += this.node.marginTop + this.node.marginBottom;
        }
        return d;
    }

    public void setShowExtras(boolean showExtras) {
        this.showExtras = showExtras;
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        Icon icon = this.getIcon();
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        int x = (this.getWidth() - width) / 2;
        int y = (this.getHeight() - height) / 2;
        icon.paintIcon(this, g, x, y);
        if (this.showExtras) {
            g.translate(x, y);
            g.setXORMode(Color.WHITE);
            if ((this.node.paddingBottom | this.node.paddingLeft | this.node.paddingTop | this.node.paddingRight) != 0) {
                g.setColor(Color.RED);
                g.drawRect(this.node.paddingLeft, this.node.paddingTop, width - this.node.paddingRight - this.node.paddingLeft, height - this.node.paddingBottom - this.node.paddingTop);
            }
            if (this.node.baseline != -1) {
                g.setColor(Color.BLUE);
                g.drawLine(0, this.node.baseline, width, this.node.baseline);
            }
            if (this.node.hasMargins && (this.node.marginLeft | this.node.marginBottom | this.node.marginRight | this.node.marginRight) != 0) {
                g.setColor(Color.BLACK);
                g.drawRect(-this.node.marginLeft, -this.node.marginTop, this.node.marginLeft + width + this.node.marginRight, this.node.marginTop + height + this.node.marginBottom);
            }
            g.translate(-x, -y);
        }
    }
}

