/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.ui;

import com.android.hierarchyviewer.scene.ViewHierarchyScene;
import com.android.hierarchyviewer.scene.ViewNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

class LayoutRenderer
extends JComponent {
    private static final int EMULATED_SCREEN_WIDTH = 320;
    private static final int EMULATED_SCREEN_HEIGHT = 480;
    private static final int SCREEN_MARGIN = 24;
    private boolean showExtras;
    private ViewHierarchyScene scene;
    private JComponent sceneView;

    LayoutRenderer(ViewHierarchyScene scene, JComponent sceneView) {
        this.scene = scene;
        this.sceneView = sceneView;
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        this.setBackground(Color.BLACK);
        this.setForeground(Color.WHITE);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                LayoutRenderer.this.selectChild(event.getX(), event.getY());
            }
        });
    }

    public Dimension getPreferredSize() {
        return new Dimension(344, 504);
    }

    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Insets insets = this.getInsets();
        g.clipRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        if (this.scene == null) {
            return;
        }
        ViewNode root = this.scene.getRoot();
        if (root == null) {
            return;
        }
        int x = (this.getWidth() - insets.left - insets.right - root.width) / 2;
        int y = (this.getHeight() - insets.top - insets.bottom - root.height) / 2;
        g.translate(insets.left + x, insets.top + y);
        g.setColor(this.getForeground());
        g.drawRect(root.left, root.top, root.width - 1, root.height - 1);
        g.clipRect(root.left - 1, root.top - 1, root.width + 1, root.height + 1);
        this.drawChildren(g, root, -root.scrollX, -root.scrollY);
        Set selection = this.scene.getSelectedObjects();
        if (selection.size() > 0) {
            ViewNode node = (ViewNode)selection.iterator().next();
            g.setColor(Color.RED);
            Graphics s = g.create();
            ViewNode p = node.parent;
            while (p != null) {
                s.translate(p.left - p.scrollX, p.top - p.scrollY);
                p = p.parent;
            }
            if (this.showExtras && node.image != null) {
                s.drawImage(node.image, node.left, node.top, null);
            }
            s.drawRect(node.left, node.top, node.width - 1, node.height - 1);
            s.dispose();
        }
        g.translate(-insets.left - x, -insets.top - y);
    }

    private void drawChildren(Graphics g, ViewNode root, int x, int y) {
        g.translate(x, y);
        for (ViewNode node : root.children) {
            if (!node.willNotDraw) {
                g.drawRect(node.left, node.top, node.width - 1, node.height - 1);
            }
            if (node.children.size() <= 0) continue;
            this.drawChildren(g, node, node.left - node.parent.scrollX, node.top - node.parent.scrollY);
        }
        g.translate(-x, -y);
    }

    public void setShowExtras(boolean showExtras) {
        this.showExtras = showExtras;
        this.repaint();
    }

    private void selectChild(int x, int y) {
        if (this.scene == null) {
            return;
        }
        ViewNode root = this.scene.getRoot();
        if (root == null) {
            return;
        }
        Insets insets = this.getInsets();
        int xoffset = (this.getWidth() - insets.left - insets.right - root.width) / 2 + insets.left + 1;
        int yoffset = (this.getHeight() - insets.top - insets.bottom - root.height) / 2 + insets.top + 1;
        if ((x -= xoffset) >= 0 && x < 320 && (y -= yoffset) >= 0 && y < 480) {
            ViewNode hit = this.findChild(root, root, x, y);
            this.scene.setFocusedObject(hit);
            this.sceneView.repaint();
        }
    }

    private ViewNode findChild(ViewNode root, ViewNode besthit, int x, int y) {
        ViewNode hit = besthit;
        for (ViewNode node : root.children) {
            if (node.left <= x && x < node.left + node.width && node.top <= y && y < node.top + node.height && node.width <= hit.width && node.height <= hit.height) {
                hit = node;
            }
            if (node.children.size() <= 0) continue;
            hit = this.findChild(node, hit, x - (node.left - node.parent.scrollX), y - (node.top - node.parent.scrollY));
        }
        return hit;
    }
}

