/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.ui;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.RawImage;
import com.android.hierarchyviewer.scene.ViewNode;
import com.android.hierarchyviewer.ui.Workspace;
import com.android.hierarchyviewer.ui.util.IconLoader;
import com.android.hierarchyviewer.ui.util.PngFileFilter;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScreenViewer
extends JPanel
implements ActionListener {
    private final Workspace workspace;
    private final IDevice device;
    private GetScreenshotTask task;
    private BufferedImage image;
    private int[] scanline;
    private volatile boolean isLoading;
    private BufferedImage overlay;
    private AlphaComposite overlayAlpha = AlphaComposite.getInstance(3, 0.3f);
    private LoupeStatus status;
    private LoupeViewer loupe;
    private Crosshair crosshair;
    private int zoom = 8;
    private int y = 0;
    private Timer timer;
    private ViewNode node;
    private JSlider zoomSlider;

    ScreenViewer(Workspace workspace, IDevice device, int spacing) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.workspace = workspace;
        this.device = device;
        this.timer = new Timer(5000, this);
        this.timer.setInitialDelay(0);
        this.timer.setRepeats(true);
        JPanel panel = this.buildViewerAndControls();
        this.add((Component)panel, "West");
        JPanel loupePanel = this.buildLoupePanel(spacing);
        this.add((Component)loupePanel, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ScreenViewer.this.timer.start();
            }
        });
    }

    private JPanel buildLoupePanel(int spacing) {
        this.loupe = new LoupeViewer();
        this.loupe.addMouseWheelListener(new WheelZoomListener());
        CrosshairPanel crosshairPanel = new CrosshairPanel(this.loupe);
        JPanel loupePanel = new JPanel(new BorderLayout());
        loupePanel.add(crosshairPanel);
        this.status = new LoupeStatus();
        loupePanel.add((Component)this.status, "South");
        loupePanel.setBorder(BorderFactory.createEmptyBorder(0, spacing, 0, 0));
        return loupePanel;
    }

    private JPanel buildViewerAndControls() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.crosshair = new Crosshair(new ScreenshotViewer());
        this.crosshair.addMouseWheelListener(new WheelZoomListener());
        panel.add((Component)this.crosshair, new GridBagConstraints(0, this.y++, 2, 1, 1.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buildSlider(panel, "Overlay:", "0%", "100%", 0, 100, 30, 1).addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                float opacity = (float)((JSlider)event.getSource()).getValue() / 100.0f;
                ScreenViewer.this.overlayAlpha = AlphaComposite.getInstance(3, opacity);
                ScreenViewer.this.repaint();
            }
        });
        this.buildOverlayExtraControls(panel);
        this.buildSlider(panel, "Refresh Rate:", "1s", "40s", 1, 40, 5, 1).addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                int rate = ((JSlider)event.getSource()).getValue() * 1000;
                ScreenViewer.this.timer.setDelay(rate);
                ScreenViewer.this.timer.setInitialDelay(0);
                ScreenViewer.this.timer.restart();
            }
        });
        this.zoomSlider = this.buildSlider(panel, "Zoom:", "2x", "24x", 2, 24, 8, 2);
        this.zoomSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                ScreenViewer.this.zoom = ((JSlider)event.getSource()).getValue();
                ((ScreenViewer)ScreenViewer.this).loupe.clearGrid = true;
                ScreenViewer.this.loupe.moveToPoint(((ScreenViewer)ScreenViewer.this).crosshair.crosshair.x, ((ScreenViewer)ScreenViewer.this).crosshair.crosshair.y);
                ScreenViewer.this.repaint();
            }
        });
        panel.add(Box.createVerticalGlue(), new GridBagConstraints(0, this.y++, 2, 1, 1.0, 1.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void buildOverlayExtraControls(JPanel panel) {
        JPanel extras = new JPanel(new FlowLayout(0, 0, 0));
        JButton loadOverlay = new JButton("Load...");
        loadOverlay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SwingWorker<?, ?> worker = ScreenViewer.this.openOverlay();
                if (worker != null) {
                    worker.execute();
                }
            }
        });
        extras.add(loadOverlay);
        JCheckBox showInLoupe = new JCheckBox("Show in Loupe");
        showInLoupe.setSelected(false);
        showInLoupe.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ScreenViewer.this.loupe.showOverlay = ((JCheckBox)event.getSource()).isSelected();
                ScreenViewer.this.loupe.repaint();
            }
        });
        extras.add(showInLoupe);
        panel.add((Component)extras, new GridBagConstraints(1, this.y++, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public SwingWorker<?, ?> openOverlay() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new PngFileFilter());
        int choice = chooser.showOpenDialog(this);
        if (choice == 0) {
            return new OpenOverlayTask(chooser.getSelectedFile());
        }
        return null;
    }

    private JSlider buildSlider(JPanel panel, String title, String minName, String maxName, int min, int max, int value, int tick) {
        panel.add((Component)new JLabel(title), new GridBagConstraints(0, this.y, 1, 1, 1.0, 0.0, 22, 0, new Insets(0, 0, 0, 6), 0, 0));
        JPanel sliderPanel = new JPanel(new FlowLayout(0, 0, 0));
        sliderPanel.add(new JLabel(minName));
        JSlider slider = new JSlider(min, max, value);
        slider.setMinorTickSpacing(tick);
        slider.setMajorTickSpacing(tick);
        slider.setSnapToTicks(true);
        sliderPanel.add(slider);
        sliderPanel.add(new JLabel(maxName));
        panel.add((Component)sliderPanel, new GridBagConstraints(1, this.y++, 1, 1, 1.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        return slider;
    }

    void stop() {
        this.timer.stop();
    }

    void start() {
        this.timer.start();
    }

    void select(ViewNode node) {
        this.node = node;
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.task != null && !this.task.isDone()) {
            return;
        }
        this.task = new GetScreenshotTask();
        this.task.execute();
    }

    static /* synthetic */ int[] access$2002(ScreenViewer x0, int[] x1) {
        x0.scanline = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OpenOverlayTask
    extends SwingWorker<BufferedImage, Void> {
        private File file;

        private OpenOverlayTask(File file) {
            this.file = file;
            ScreenViewer.this.workspace.beginTask();
        }

        @Override
        protected BufferedImage doInBackground() {
            try {
                return IconLoader.toCompatibleImage(ImageIO.read(this.file));
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                ScreenViewer.this.overlay = (BufferedImage)this.get();
                ScreenViewer.this.repaint();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            finally {
                ScreenViewer.this.workspace.endTask();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetScreenshotTask
    extends SwingWorker<Boolean, Void> {
        private GetScreenshotTask() {
            ScreenViewer.this.workspace.beginTask();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Boolean doInBackground() throws Exception {
            RawImage rawImage;
            try {
                rawImage = ScreenViewer.this.device.getScreenshot();
            }
            catch (IOException ioe) {
                return false;
            }
            boolean resize = false;
            ScreenViewer.this.isLoading = true;
            try {
                if (rawImage != null && rawImage.bpp == 16) {
                    if (ScreenViewer.this.image == null || rawImage.width != ScreenViewer.this.image.getWidth() || rawImage.height != ScreenViewer.this.image.getHeight()) {
                        ScreenViewer.this.image = new BufferedImage(rawImage.width, rawImage.height, 2);
                        ScreenViewer.access$2002(ScreenViewer.this, new int[rawImage.width]);
                        resize = true;
                    }
                    byte[] buffer = rawImage.data;
                    int index = 0;
                    for (int y = 0; y < rawImage.height; ++y) {
                        for (int x = 0; x < rawImage.width; ++x) {
                            int value = buffer[index++] & 0xFF;
                            int r = ((value |= buffer[index++] << 8 & 0xFF00) >> 11 & 0x1F) << 3;
                            int g = (value >> 5 & 0x3F) << 2;
                            int b = (value & 0x1F) << 3;
                            ((ScreenViewer)ScreenViewer.this).scanline[x] = 0xFF000000 | r << 16 | g << 8 | b;
                        }
                        ScreenViewer.this.image.setRGB(0, y, rawImage.width, 1, ScreenViewer.this.scanline, 0, rawImage.width);
                    }
                }
            }
            finally {
                ScreenViewer.this.isLoading = false;
            }
            return resize;
        }

        @Override
        protected void done() {
            ScreenViewer.this.workspace.endTask();
            try {
                if (((Boolean)this.get()).booleanValue()) {
                    ScreenViewer.this.validate();
                    ((ScreenViewer)ScreenViewer.this).crosshair.crosshair = new Point(ScreenViewer.this.image.getWidth() / 2, ScreenViewer.this.image.getHeight() / 2);
                    ScreenViewer.this.status.showPixel(ScreenViewer.this.image.getWidth() / 2, ScreenViewer.this.image.getHeight() / 2);
                    ScreenViewer.this.loupe.moveToPoint(ScreenViewer.this.image.getWidth() / 2, ScreenViewer.this.image.getHeight() / 2);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            ScreenViewer.this.repaint();
        }
    }

    private class CrosshairPanel
    extends JPanel {
        private final Color crosshairColor = new Color(0xFF5EFE);
        private final Insets insets = new Insets(0, 0, 0, 0);

        CrosshairPanel(LoupeViewer loupe) {
            this.setLayout(new BorderLayout());
            this.add(loupe);
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(this.crosshairColor);
            int width = this.getWidth();
            int height = this.getHeight();
            this.getInsets(this.insets);
            int x = (width - this.insets.left - this.insets.right) / 2;
            int y = (height - this.insets.top - this.insets.bottom) / 2;
            g.drawLine(this.insets.left + x, this.insets.top, this.insets.left + x, height - this.insets.bottom);
            g.drawLine(this.insets.left, this.insets.top + y, width - this.insets.right, this.insets.top + y);
        }

        protected void paintComponent(Graphics g) {
            g.setColor(Color.BLACK);
            Insets insets = this.getInsets();
            g.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        }
    }

    class ScreenshotViewer
    extends JComponent {
        private final Color boundsColor = new Color(0xFF5EFE);

        ScreenshotViewer() {
            this.setOpaque(true);
        }

        protected void paintComponent(Graphics g) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (ScreenViewer.this.isLoading) {
                return;
            }
            if (ScreenViewer.this.image != null) {
                g.drawImage(ScreenViewer.this.image, 0, 0, null);
                if (ScreenViewer.this.overlay != null) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    g2.setComposite(ScreenViewer.this.overlayAlpha);
                    g2.drawImage((Image)ScreenViewer.this.overlay, 0, ScreenViewer.this.image.getHeight() - ScreenViewer.this.overlay.getHeight(), null);
                }
            }
            if (ScreenViewer.this.node != null) {
                Graphics s = g.create();
                s.setColor(this.boundsColor);
                ViewNode p = ((ScreenViewer)ScreenViewer.this).node.parent;
                while (p != null) {
                    s.translate(p.left - p.scrollX, p.top - p.scrollY);
                    p = p.parent;
                }
                s.drawRect(((ScreenViewer)ScreenViewer.this).node.left, ((ScreenViewer)ScreenViewer.this).node.top, ((ScreenViewer)ScreenViewer.this).node.width - 1, ((ScreenViewer)ScreenViewer.this).node.height - 1);
                s.translate(((ScreenViewer)ScreenViewer.this).node.left, ((ScreenViewer)ScreenViewer.this).node.top);
                s.setXORMode(Color.WHITE);
                if ((((ScreenViewer)ScreenViewer.this).node.paddingBottom | ((ScreenViewer)ScreenViewer.this).node.paddingLeft | ((ScreenViewer)ScreenViewer.this).node.paddingTop | ((ScreenViewer)ScreenViewer.this).node.paddingRight) != 0) {
                    s.setColor(Color.BLACK);
                    s.drawRect(((ScreenViewer)ScreenViewer.this).node.paddingLeft, ((ScreenViewer)ScreenViewer.this).node.paddingTop, ((ScreenViewer)ScreenViewer.this).node.width - ((ScreenViewer)ScreenViewer.this).node.paddingRight - ((ScreenViewer)ScreenViewer.this).node.paddingLeft - 1, ((ScreenViewer)ScreenViewer.this).node.height - ((ScreenViewer)ScreenViewer.this).node.paddingBottom - ((ScreenViewer)ScreenViewer.this).node.paddingTop - 1);
                }
                if (((ScreenViewer)ScreenViewer.this).node.hasMargins && (((ScreenViewer)ScreenViewer.this).node.marginLeft | ((ScreenViewer)ScreenViewer.this).node.marginBottom | ((ScreenViewer)ScreenViewer.this).node.marginRight | ((ScreenViewer)ScreenViewer.this).node.marginRight) != 0) {
                    s.setColor(Color.BLACK);
                    s.drawRect(-((ScreenViewer)ScreenViewer.this).node.marginLeft, -((ScreenViewer)ScreenViewer.this).node.marginTop, ((ScreenViewer)ScreenViewer.this).node.marginLeft + ((ScreenViewer)ScreenViewer.this).node.width + ((ScreenViewer)ScreenViewer.this).node.marginRight - 1, ((ScreenViewer)ScreenViewer.this).node.marginTop + ((ScreenViewer)ScreenViewer.this).node.height + ((ScreenViewer)ScreenViewer.this).node.marginBottom - 1);
                }
                s.dispose();
            }
        }

        public Dimension getPreferredSize() {
            if (ScreenViewer.this.image == null) {
                return new Dimension(320, 480);
            }
            return new Dimension(ScreenViewer.this.image.getWidth(), ScreenViewer.this.image.getHeight());
        }
    }

    class Crosshair
    extends JPanel {
        private final Color crosshairColor = new Color(65535);
        Point crosshair = new Point();
        private int width;
        private int height;

        Crosshair(ScreenshotViewer screenshotViewer) {
            this.setOpaque(true);
            this.setLayout(new BorderLayout());
            this.add(screenshotViewer);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent event) {
                    Crosshair.this.moveToPoint(event);
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent event) {
                    Crosshair.this.moveToPoint(event);
                }
            });
        }

        void moveToPoint(int x, int y) {
            this.crosshair.x = x;
            this.crosshair.y = y;
            ScreenViewer.this.status.showPixel(this.crosshair.x, this.crosshair.y);
            this.repaint();
        }

        private void moveToPoint(MouseEvent event) {
            this.crosshair.x = Math.max(0, Math.min(ScreenViewer.this.image.getWidth() - 1, event.getX()));
            this.crosshair.y = Math.max(0, Math.min(ScreenViewer.this.image.getHeight() - 1, event.getY()));
            ScreenViewer.this.loupe.moveToPoint(this.crosshair.x, this.crosshair.y);
            ScreenViewer.this.status.showPixel(this.crosshair.x, this.crosshair.y);
            this.repaint();
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.crosshair == null || this.width != this.getWidth() || this.height != this.getHeight()) {
                this.width = this.getWidth();
                this.height = this.getHeight();
                this.crosshair = new Point(this.width / 2, this.height / 2);
            }
            g.setColor(this.crosshairColor);
            g.drawLine(this.crosshair.x, 0, this.crosshair.x, this.height);
            g.drawLine(0, this.crosshair.y, this.width, this.crosshair.y);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    class LoupeStatus
    extends JPanel {
        private JLabel xLabel;
        private JLabel yLabel;
        private JLabel rLabel;
        private JLabel gLabel;
        private JLabel bLabel;
        private JLabel hLabel;
        private ColoredSquare square;
        private Color color;

        LoupeStatus() {
            this.setOpaque(true);
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.square = new ColoredSquare();
            this.add((Component)this.square, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 12), 0, 0));
            JLabel label = new JLabel("#ffffff");
            this.add((Component)label, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 12), 0, 0));
            label.setForeground(Color.WHITE);
            this.hLabel = label;
            label = new JLabel("R:");
            this.add((Component)label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 6, 0, 6), 0, 0));
            label.setForeground(Color.WHITE);
            label = new JLabel("255");
            this.add((Component)label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 12), 0, 0));
            label.setForeground(Color.WHITE);
            this.rLabel = label;
            label = new JLabel("G:");
            this.add((Component)label, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 6, 0, 6), 0, 0));
            label.setForeground(Color.WHITE);
            label = new JLabel("255");
            this.add((Component)label, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 12), 0, 0));
            label.setForeground(Color.WHITE);
            this.gLabel = label;
            label = new JLabel("B:");
            this.add((Component)label, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 6, 0, 6), 0, 0));
            label.setForeground(Color.WHITE);
            label = new JLabel("255");
            this.add((Component)label, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 12), 0, 0));
            label.setForeground(Color.WHITE);
            this.bLabel = label;
            label = new JLabel("X:");
            this.add((Component)label, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 6, 0, 6), 0, 0));
            label.setForeground(Color.WHITE);
            label = new JLabel("0 px");
            this.add((Component)label, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 12), 0, 0));
            label.setForeground(Color.WHITE);
            this.xLabel = label;
            label = new JLabel("Y:");
            this.add((Component)label, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 6, 0, 6), 0, 0));
            label.setForeground(Color.WHITE);
            label = new JLabel("0 px");
            this.add((Component)label, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 12), 0, 0));
            label.setForeground(Color.WHITE);
            this.yLabel = label;
            this.add(Box.createHorizontalGlue(), new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        protected void paintComponent(Graphics g) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }

        void showPixel(int x, int y) {
            this.xLabel.setText(x + " px");
            this.yLabel.setText(y + " px");
            int pixel = ScreenViewer.this.image.getRGB(x, y);
            this.color = new Color(pixel);
            this.hLabel.setText("#" + Integer.toHexString(pixel));
            this.rLabel.setText(String.valueOf(pixel >> 16 & 0xFF));
            this.gLabel.setText(String.valueOf(pixel >> 8 & 0xFF));
            this.bLabel.setText(String.valueOf(pixel & 0xFF));
            this.square.repaint();
        }

        private class ColoredSquare
        extends JComponent {
            private ColoredSquare() {
            }

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 60;
                d.height = 30;
                return d;
            }

            protected void paintComponent(Graphics g) {
                g.setColor(LoupeStatus.this.color);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(Color.WHITE);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
    }

    class LoupeViewer
    extends JComponent {
        private final Color lineColor = new Color(1.0f, 1.0f, 1.0f, 0.3f);
        private int width;
        private int height;
        private BufferedImage grid;
        private int left;
        private int top;
        public boolean clearGrid;
        private final Rectangle clip = new Rectangle();
        private boolean showOverlay = false;

        LoupeViewer() {
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent event) {
                    LoupeViewer.this.moveToPoint(event);
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent event) {
                    LoupeViewer.this.moveToPoint(event);
                }
            });
        }

        protected void paintComponent(Graphics g) {
            if (ScreenViewer.this.isLoading) {
                return;
            }
            g.translate(-this.left, -this.top);
            if (ScreenViewer.this.image != null) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                g2.scale(ScreenViewer.this.zoom, ScreenViewer.this.zoom);
                g2.drawImage((Image)ScreenViewer.this.image, 0, 0, null);
                if (ScreenViewer.this.overlay != null && this.showOverlay) {
                    g2.setComposite(ScreenViewer.this.overlayAlpha);
                    g2.drawImage((Image)ScreenViewer.this.overlay, 0, ScreenViewer.this.image.getHeight() - ScreenViewer.this.overlay.getHeight(), null);
                }
                g2.dispose();
            }
            int width = this.getWidth();
            int height = this.getHeight();
            Graphics2D g2 = null;
            if (width != this.width || height != this.height) {
                this.width = width;
                this.height = height;
                this.grid = new BufferedImage(width + ScreenViewer.this.zoom + 1, height + ScreenViewer.this.zoom + 1, 2);
                this.clearGrid = true;
                g2 = this.grid.createGraphics();
            } else if (this.clearGrid) {
                g2 = this.grid.createGraphics();
                g2.setComposite(AlphaComposite.Clear);
                g2.fillRect(0, 0, this.grid.getWidth(), this.grid.getHeight());
                g2.setComposite(AlphaComposite.SrcOver);
            }
            if (this.clearGrid) {
                this.clearGrid = false;
                g2.setColor(this.lineColor);
                width += ScreenViewer.this.zoom;
                height += ScreenViewer.this.zoom;
                for (int x = ScreenViewer.this.zoom; x <= width; x += ScreenViewer.this.zoom) {
                    g2.drawLine(x, 0, x, height);
                }
                for (int y = 0; y <= height; y += ScreenViewer.this.zoom) {
                    g2.drawLine(0, y, width, y);
                }
                g2.dispose();
            }
            if (ScreenViewer.this.image != null) {
                g.getClipBounds(this.clip);
                g.clipRect(0, 0, ScreenViewer.this.image.getWidth() * ScreenViewer.this.zoom + 1, ScreenViewer.this.image.getHeight() * ScreenViewer.this.zoom + 1);
                g.drawImage(this.grid, this.clip.x - this.clip.x % ScreenViewer.this.zoom, this.clip.y - this.clip.y % ScreenViewer.this.zoom, null);
            }
            g.translate(this.left, this.top);
        }

        void moveToPoint(MouseEvent event) {
            int x = Math.max(0, Math.min((event.getX() + this.left) / ScreenViewer.this.zoom, ScreenViewer.this.image.getWidth() - 1));
            int y = Math.max(0, Math.min((event.getY() + this.top) / ScreenViewer.this.zoom, ScreenViewer.this.image.getHeight() - 1));
            this.moveToPoint(x, y);
            ScreenViewer.this.crosshair.moveToPoint(x, y);
        }

        void moveToPoint(int x, int y) {
            this.left = x * ScreenViewer.this.zoom - this.width / 2 + ScreenViewer.this.zoom / 2;
            this.top = y * ScreenViewer.this.zoom - this.height / 2 + ScreenViewer.this.zoom / 2;
            this.repaint();
        }
    }

    private class WheelZoomListener
    implements MouseWheelListener {
        private WheelZoomListener() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (ScreenViewer.this.zoomSlider != null) {
                int val = ScreenViewer.this.zoomSlider.getValue();
                ScreenViewer.this.zoomSlider.setValue(val -= e.getWheelRotation() * 2);
            }
        }
    }
}

