/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AllocationInfo;
import com.android.ddmlib.Client;
import com.android.ddmlib.HeapSegment;
import com.android.ddmlib.NativeAllocationInfo;
import com.android.ddmlib.NativeLibraryMapInfo;
import com.android.ddmlib.ThreadInfo;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientData {
    private static final String PRE_INITIALIZED = "<pre-initialized>";
    public static final String HEAP_MAX_SIZE_BYTES = "maxSizeInBytes";
    public static final String HEAP_SIZE_BYTES = "sizeInBytes";
    public static final String HEAP_BYTES_ALLOCATED = "bytesAllocated";
    public static final String HEAP_OBJECTS_ALLOCATED = "objectsAllocated";
    public static final String FEATURE_PROFILING = "method-trace-profiling";
    public static final String FEATURE_HPROF = "hprof-heap-dump";
    private static IHprofDumpHandler sHprofDumpHandler;
    private static IMethodProfilingHandler sMethodProfilingHandler;
    private boolean mIsDdmAware;
    private final int mPid;
    private String mVmIdentifier;
    private String mClientDescription;
    private DebuggerStatus mDebuggerInterest;
    private final HashSet<String> mFeatures = new HashSet();
    private TreeMap<Integer, ThreadInfo> mThreadMap;
    private final HeapData mHeapData = new HeapData();
    private final HeapData mNativeHeapData = new HeapData();
    private HashMap<Integer, HashMap<String, Long>> mHeapInfoMap = new HashMap();
    private ArrayList<NativeLibraryMapInfo> mNativeLibMapInfo = new ArrayList();
    private ArrayList<NativeAllocationInfo> mNativeAllocationList = new ArrayList();
    private int mNativeTotalMemory;
    private AllocationInfo[] mAllocations;
    private AllocationTrackingStatus mAllocationStatus = AllocationTrackingStatus.UNKNOWN;
    private String mPendingHprofDump;
    private MethodProfilingStatus mProfilingStatus = MethodProfilingStatus.UNKNOWN;
    private String mPendingMethodProfiling;

    public static void setHprofDumpHandler(IHprofDumpHandler handler) {
        sHprofDumpHandler = handler;
    }

    static IHprofDumpHandler getHprofDumpHandler() {
        return sHprofDumpHandler;
    }

    public static void setMethodProfilingHandler(IMethodProfilingHandler handler) {
        sMethodProfilingHandler = handler;
    }

    static IMethodProfilingHandler getMethodProfilingHandler() {
        return sMethodProfilingHandler;
    }

    ClientData(int pid) {
        this.mPid = pid;
        this.mDebuggerInterest = DebuggerStatus.DEFAULT;
        this.mThreadMap = new TreeMap();
    }

    public boolean isDdmAware() {
        return this.mIsDdmAware;
    }

    void isDdmAware(boolean aware) {
        this.mIsDdmAware = aware;
    }

    public int getPid() {
        return this.mPid;
    }

    public String getVmIdentifier() {
        return this.mVmIdentifier;
    }

    void setVmIdentifier(String ident) {
        this.mVmIdentifier = ident;
    }

    public String getClientDescription() {
        return this.mClientDescription;
    }

    void setClientDescription(String description) {
        if (this.mClientDescription == null && description.length() > 0 && !PRE_INITIALIZED.equals(description)) {
            this.mClientDescription = description;
        }
    }

    public DebuggerStatus getDebuggerConnectionStatus() {
        return this.mDebuggerInterest;
    }

    void setDebuggerConnectionStatus(DebuggerStatus status) {
        this.mDebuggerInterest = status;
    }

    synchronized void setHeapInfo(int heapId, long maxSizeInBytes, long sizeInBytes, long bytesAllocated, long objectsAllocated) {
        HashMap<String, Long> heapInfo = new HashMap<String, Long>();
        heapInfo.put(HEAP_MAX_SIZE_BYTES, maxSizeInBytes);
        heapInfo.put(HEAP_SIZE_BYTES, sizeInBytes);
        heapInfo.put(HEAP_BYTES_ALLOCATED, bytesAllocated);
        heapInfo.put(HEAP_OBJECTS_ALLOCATED, objectsAllocated);
        this.mHeapInfoMap.put(heapId, heapInfo);
    }

    public HeapData getVmHeapData() {
        return this.mHeapData;
    }

    HeapData getNativeHeapData() {
        return this.mNativeHeapData;
    }

    public synchronized Iterator<Integer> getVmHeapIds() {
        return this.mHeapInfoMap.keySet().iterator();
    }

    public synchronized Map<String, Long> getVmHeapInfo(int heapId) {
        return this.mHeapInfoMap.get(heapId);
    }

    synchronized void addThread(int threadId, String threadName) {
        ThreadInfo attr = new ThreadInfo(threadId, threadName);
        this.mThreadMap.put(threadId, attr);
    }

    synchronized void removeThread(int threadId) {
        this.mThreadMap.remove(threadId);
    }

    public synchronized ThreadInfo[] getThreads() {
        Collection<ThreadInfo> threads = this.mThreadMap.values();
        return threads.toArray(new ThreadInfo[threads.size()]);
    }

    synchronized ThreadInfo getThread(int threadId) {
        return this.mThreadMap.get(threadId);
    }

    synchronized void clearThreads() {
        this.mThreadMap.clear();
    }

    public synchronized List<NativeAllocationInfo> getNativeAllocationList() {
        return Collections.unmodifiableList(this.mNativeAllocationList);
    }

    synchronized void addNativeAllocation(NativeAllocationInfo allocInfo) {
        this.mNativeAllocationList.add(allocInfo);
    }

    synchronized void clearNativeAllocationInfo() {
        this.mNativeAllocationList.clear();
    }

    public synchronized int getTotalNativeMemory() {
        return this.mNativeTotalMemory;
    }

    synchronized void setTotalNativeMemory(int totalMemory) {
        this.mNativeTotalMemory = totalMemory;
    }

    synchronized void addNativeLibraryMapInfo(long startAddr, long endAddr, String library) {
        this.mNativeLibMapInfo.add(new NativeLibraryMapInfo(startAddr, endAddr, library));
    }

    public synchronized Iterator<NativeLibraryMapInfo> getNativeLibraryMapInfo() {
        return this.mNativeLibMapInfo.iterator();
    }

    synchronized void setAllocationStatus(AllocationTrackingStatus status) {
        this.mAllocationStatus = status;
    }

    public synchronized AllocationTrackingStatus getAllocationStatus() {
        return this.mAllocationStatus;
    }

    synchronized void setAllocations(AllocationInfo[] allocs) {
        this.mAllocations = allocs;
    }

    public synchronized AllocationInfo[] getAllocations() {
        return this.mAllocations;
    }

    void addFeature(String feature) {
        this.mFeatures.add(feature);
    }

    public boolean hasFeature(String feature) {
        return this.mFeatures.contains(feature);
    }

    void setPendingHprofDump(String pendingHprofDump) {
        this.mPendingHprofDump = pendingHprofDump;
    }

    String getPendingHprofDump() {
        return this.mPendingHprofDump;
    }

    public boolean hasPendingHprofDump() {
        return this.mPendingHprofDump != null;
    }

    synchronized void setMethodProfilingStatus(MethodProfilingStatus status) {
        this.mProfilingStatus = status;
    }

    public synchronized MethodProfilingStatus getMethodProfilingStatus() {
        return this.mProfilingStatus;
    }

    void setPendingMethodProfiling(String pendingMethodProfiling) {
        this.mPendingMethodProfiling = pendingMethodProfiling;
    }

    String getPendingMethodProfiling() {
        return this.mPendingMethodProfiling;
    }

    public static interface IMethodProfilingHandler {
        public void onSuccess(String var1, Client var2);

        public void onFailure(Client var1);
    }

    public static interface IHprofDumpHandler {
        public void onSuccess(String var1, Client var2);

        public void onFailure(Client var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HeapData {
        private TreeSet<HeapSegment> mHeapSegments = new TreeSet();
        private boolean mHeapDataComplete = false;
        private byte[] mProcessedHeapData;
        private Map<Integer, ArrayList<HeapSegment.HeapSegmentElement>> mProcessedHeapMap;

        public synchronized void clearHeapData() {
            this.mHeapSegments = new TreeSet();
            this.mHeapDataComplete = false;
        }

        synchronized void addHeapData(ByteBuffer data) {
            HeapSegment hs;
            if (this.mHeapDataComplete) {
                this.clearHeapData();
            }
            try {
                hs = new HeapSegment(data);
            }
            catch (BufferUnderflowException e) {
                System.err.println("Discarding short HPSG data (length " + data.limit() + ")");
                return;
            }
            this.mHeapSegments.add(hs);
        }

        synchronized void sealHeapData() {
            this.mHeapDataComplete = true;
        }

        public boolean isHeapDataComplete() {
            return this.mHeapDataComplete;
        }

        public Collection<HeapSegment> getHeapSegments() {
            if (this.isHeapDataComplete()) {
                return this.mHeapSegments;
            }
            return null;
        }

        public void setProcessedHeapData(byte[] heapData) {
            this.mProcessedHeapData = heapData;
        }

        public byte[] getProcessedHeapData() {
            return this.mProcessedHeapData;
        }

        public void setProcessedHeapMap(Map<Integer, ArrayList<HeapSegment.HeapSegmentElement>> heapMap) {
            this.mProcessedHeapMap = heapMap;
        }

        public Map<Integer, ArrayList<HeapSegment.HeapSegmentElement>> getProcessedHeapMap() {
            return this.mProcessedHeapMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MethodProfilingStatus {
        UNKNOWN,
        OFF,
        ON;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AllocationTrackingStatus {
        UNKNOWN,
        OFF,
        ON;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DebuggerStatus {
        DEFAULT,
        WAITING,
        ATTACHED,
        ERROR;

    }
}

