require 'rexml/document'
require 'uconv'
require 'socket'

include REXML
include Uconv

class Packet
  def initialize(socket, method_name, *argv)
    @socket = socket
    doc = Document.new
    doc << XMLDecl.new(nil, "UTF-8")
    e = Element.new "packet"
    e.attributes['method_name'] = method_name
    argv.each do |arg|
      ei = Element.new "arg"
      ei.text = euctou8(arg.to_s)
      e.add ei
    end
    doc.add e
    @doc = doc
  end
  def send
#    @doc.write($stdout, 0)
#    $stdout.flush
    @doc.write(@socket, 0)
    @socket.write "\n\n"
    @socket.flush
  end
end

class PacketListener
  def initialize(sock, dbh, sock_arr = nil)
    @sock = sock
    @dbh  = dbh
    @sock_arr = sock_arr
    xml = buff = ''
    while true do
      begin
	xml = ''
	while "\n" != (buff = @sock.gets) do
	  xml += buff
	end
	# puts u8toeuc(xml)
	xml.gsub!(/\n/, '')
	doc = Document.new(xml)
	argv = []
	doc.elements.each("packet/arg") do |e|
	  argv.push u8toeuc("#{e.text}")
	end
	method_name = doc.root.attributes['method_name']
	send method_name, *argv
      rescue
	# puts $!, $@
	@sock.close
	sock_arr.delete @sock
	Thread.exit
      end
    end
  end
end
