#!/usr/bin/env ruby

#----------------------------------------------------#
# Edit followings line to fit your environment.
#----------------------------------------------------#

POS_MASTER_PORT    = 7654
POS_DBI_DRIVER = 'DBI:Pg:pos_master'
POS_DB_USER   = 'sino'
POS_DB_PASSWD = ''

#----------------------------------------------------#
# Do NOT edit from here!
#----------------------------------------------------#

require 'socket'
require 'dbi'
require 'lib/Packet.rb'

class PacketListener
  def insert_item(item_name, price, barcode, maker)
    args = [item_name, price, barcode, maker]
    args = args.collect do |arg| (arg.length == 0 ? nil : arg) end    
    sql = "insert into tbl_item_master(item_name, price, barcode, maker) " +
    "values (?, ?, ?, ?) "
    @dbh.do(sql, *args)
    sql = "select item_id, item_name, price, barcode, maker " +
    "from tbl_item_master where barcode = '#{barcode}'"
    sth = @dbh.prepare(sql)
    sth.execute
    rtn = sth.fetch
    rtn = rtn.collect do |r| r.to_s end
    @sock_arr.each do |si|
      Packet.new(si, "insert_item", *rtn).send
    end
  end
  def sync_item(dummy)
    sql = "select count(*) from tbl_item_master"
    sth = @dbh.prepare(sql)
    sth.execute
    max = sth.fetch[0].to_i
    Packet.new(@sock, "item_sync", max).send
    sql = "select item_id, item_name, price, barcode, maker " +
          "from tbl_item_master"
    sth = @dbh.prepare(sql)
    sth.execute
    while rtn = sth.fetch do
      rtn = rtn.collect do |r| r.to_s end
      Packet.new(@sock, "insert_item", *rtn).send
    end
    Packet.new(@sock, "destroy_sync_win", "hoge").send
  end
  def delete_item(item_id)
    sql = "delete from tbl_item_master where item_id = ? "
    @dbh.do(sql, item_id)
    @sock_arr.each do |si|
      Packet.new(si, "delete_item", item_id).send
    end
  end
  def update_item(item_id, item_name, maker, barcode,  price)
    args = [item_id, item_name, maker, barcode,  price]
    args = args.collect do |arg| (arg.length == 0 ? nil : arg) end    
    sql = "update tbl_item_master set item_name = ?, "+
          "price = ?, barcode = ?, maker = ? "+
	  "where item_id = ? "
    begin
      @dbh.do(sql, item_name, price, barcode, maker, item_id)
    rescue
      print $!, $@
    end
    @sock_arr.each do |si|
      packet = Packet.new(si, "update_item", item_id, item_name, price, barcode, maker)
      packet.send
    end
  end
end


dbh = DBI.connect(POS_DBI_DRIVER, POS_DB_USER, POS_DB_PASSWD)
gs = TCPServer.open(7654)
addr = gs.addr

sock_arr = []
while true
  Thread.start(gs.accept, dbh, sock_arr) do |sock, dbh, sock_arr|
    sock_arr.push sock
    PacketListener.new(sock, dbh, sock_arr)
  end
end
