//
//	OrangePekoe Leaf API
//
//	(c)2004 The OrangePekoe project
//

#ifndef	_LEAFAPI_H_
#define	_LEAFAPI_H_

//	CRT
extern "C"{
#define	main64	main
extern	pvoid	native_api;
void*	malloc(size_t);
void	free(void*);
inline	void*	operator new(size_t n){return malloc(n);}
inline	void	operator delete(void* p){free(p);}
inline	void*	operator new[](size_t n){return malloc(n);}
inline	void	operator delete[](void* p){free(p);}
}

//	
extern "C++"{
byte	rol(byte,int8);
uint16	rol(uint16,int8);
uint32	rol(uint32,int8);
uint64	rol(uint64,int8);
inline	uint32	bswap(uint32 d){ uint32 r; asm volatile("bswap %%eax":"=a"(r):"a"(d)); return r; }
inline	int32	bswap(int32 d){ return bswap((uint32)d); }
inline	uint64	bswap(uint64 d){ uint64 r; asm volatile("bswap %%rax":"=a"(r):"a"(d)); return r; }
inline	int64	bswap(int64 d){ return bswap((uint64)d); }
inline	uint16	bswap(uint16 i){ return rol(i,8); }
inline	int16	bswap(int16 i){ return rol((uint16)i,8); }
inline	int		cpl(){
	int r;
	asm volatile(
		"movl %%cs,%%eax \n"
		"and $0x3,%%eax \n"
		:"=a"(r));
	return r;
}
intptr	pekoe64_syscall(uint);
intptr	pekoe64_syscall(uint,intptr);
intptr	pekoe64_syscall(uint,intptr,intptr);
intptr	pekoe64_syscall(uint,intptr,intptr,intptr);
intptr	pekoe64_syscall(uint,intptr,intptr,intptr,intptr);
}


//	SELF MAPPING AREA
const	intptr	__SELF_PT	= 0xFFFFFF0000000000;
const	intptr	__SELF_PDT	= 0xFFFFFF7F80000000;
const	intptr	__SELF_PDPT	= 0xFFFFFF7FBFC00000;
const	intptr	__SELF_PML4	= 0xFFFFFF7FBFDFE000;


struct KMODE_SPINLOCK{
	intptr	lock;
};

//	RAISE NATIVE EXCEPTION
struct NATIVE_EXCEPTION_PARAM {
	intptr	save_cr2;
	intptr	ax,cx,dx,bx,bp,si,di,r8,r9,r10,r11,r12,r13,r14,r15;
	intptr	intnum,errcode,rip,cs,rflags,rsp,ss;
};


//	BIOS Service
struct CALLBIOSPARAM {
	uint32	intnum;
	uint32	eax,ecx,edx,ebx,ebp,esi,edi;
	uint16	es,ds;
	uint32	eflags;
};


//	FILESYSTEM
struct CALLFS_OPEN {
	intptr	fscmd;
	intptr	device;
	intptr	index;
};
struct CALLFS_IOCTL {
	intptr	fscmd;
	intptr	device;
	intptr	ioctl_cmd,length;
	pvoid	data;
};
struct CALLFS_DTX {
	intptr	fscmd;
	intptr	device;
	intptr	index,offset;
	pvoid	data;
	intptr	count;
};
enum {
	devcall_open=0,		//	CALLFS_OPEN
	devcall_close,		//	CALLFS_OPEN
	devcall_ioctl,		//	CALLFS_IOCTL
	devcall_read,		//	CALLFS_DTX
	devcall_write,		//	CALLFS_DTX
	devcall_read_dir,	//	CALLFS_DTX
};
enum {
	ioctl_reset_device=0,	//	ALL DEVICE
	ioctl_read_toc,			//	FS ONLY
	ioctl_get_information,	//	ALL DEVICE
	ioctl_sync,				//	FS/STORAGE
};
struct record_info{
	uint64	nTotalRecords;
	uint32	BytesParRecord;
	uint32	reserved1;
	uint64	nFreeRecords;
	uint64	NextRecord;
};
struct volume_info{
	uint64	nTotalSector;
	uint32	BytesParSector;
	uint32	reserved1;
	uint64	reserved2;
	uint64	FirstRecord;
	record_info	records;
};
struct readdir_t{
	uint8	raw[32];
	uint32	attr;
	uint32	devid;
	uint64	index;
	uint64	size;
	time_t	cdate,adate,mdate;
	uint64	fp;					// in FCB only
	uint32	BytesParRecord;		// in FCB only
	uint32	nReferenceCounter;	// in FCB only
	char	filename[32];
};


//	Graphics Server
struct	GSSTATUS{
	uint8	bpp,flags;
	uint16	width,height,length;
	byte*	framebuffer;
};


//	virtual alloc
const uint	MEM_COMMIT		= 0x00001000;
const uint	MEM_RESERVE		= 0x00002000;
const uint	MEM_DECOMMIT	= 0x00004000;
const uint	MEM_RELEASE		= 0x00008000;


inline	void	sys_yield(void){ pekoe64_syscall(0x0000); }
inline	void	sys_wait(void){ pekoe64_syscall(0x0001); }
inline	void	sys_sleep(intptr ms){ pekoe64_syscall(0x0002,ms); }
inline	intptr	sys_get_tick_count(void){ return pekoe64_syscall(0x0003); }
inline	int		sys_try_to_acquire_spinlock(KMODE_SPINLOCK* p){ return pekoe64_syscall(0x0004,(intptr)p); }
inline	void	sys_acquire_spinlock(KMODE_SPINLOCK* p){ pekoe64_syscall(0x0005,(intptr)p); }
inline	void	sys_release_spinlock(KMODE_SPINLOCK* p){ pekoe64_syscall(0x0006,(intptr)p); }
inline	void	sys_beep(uint32 sw){ pekoe64_syscall(0x0007,sw); }
inline	intptr	sys_get_memory_status(int t){ return pekoe64_syscall(0x000D,t); }
inline	pvoid	sys_alloc_page(size_t n){ return(pvoid)pekoe64_syscall(0x0012,n); }
inline	void	sys_free_page(pvoid p){ pekoe64_syscall(0x0013,(intptr)p); }
inline	pvoid	sys_alloc_system_resource(size_t n){ return(pvoid)pekoe64_syscall(0x0014,n); }
inline	intptr	sys_virtual_protect(pvoid addr,intptr size,uint protect)
	{ return pekoe64_syscall(0x0015,(intptr)addr,size,protect); }
inline	pvoid	sys_virtual_alloc(pvoid addr,intptr size,uint type,uint protect)
	{ return(pvoid)pekoe64_syscall(0x0016,(intptr)addr,size,type,protect); }
inline	void	sys_ginit(void){ pekoe64_syscall(0x001D); }
inline	uint64	sys_get_version(void){ return pekoe64_syscall(0x001E); }
inline	void	sys_raise_exception(NATIVE_EXCEPTION_PARAM* p){ pekoe64_syscall(0x001F,(intptr)p); }
inline	void	sys_set_color(int d){ pekoe64_syscall(0x0020,d); }
inline	void	sys_set_color(int f,int b){ pekoe64_syscall(0x0020,f+b*16); }
inline	void	sys_clearconsole(void){ pekoe64_syscall(0x0021); }
inline	void	sys_set_cursor(uint32 d){ pekoe64_syscall(0x0022,d); }
inline	intptr	sys_call_filesys(void* fs){ return pekoe64_syscall(0x0023,(intptr)fs); }
inline	void	sys_callbios(CALLBIOSPARAM* cb){ pekoe64_syscall(0x0024,(intptr)cb); }
inline	void	sys_powerdown(void){ pekoe64_syscall(0x0026); }
inline	void	sys_reboot(void){ pekoe64_syscall(0x0027); }
inline	pvoid	sys_alloc_firstfit(size_t n){ return (pvoid)pekoe64_syscall(0x0028,n); }
inline	pvoid	sys_realloc_firstfit(pvoid p,size_t n){ return (pvoid)pekoe64_syscall(0x0029,(intptr)p,n); }
inline	pvoid	sys_alloc_real(size_t n){ return (pvoid)pekoe64_syscall(0x002A,n); }
inline	intptr	sys_free_real(pvoid p){ return pekoe64_syscall(0x002B,(intptr)p); }
inline	void	sys_select_memory_map(uint map){ pekoe64_syscall(0x002C,map); }	//	UNSAFE
inline	uint	sys_get_current_memory_map(void){ return pekoe64_syscall(0x002D); }
inline	intptr	sys_get_physical_address(pvoid p){ return pekoe64_syscall(0x002F,(intptr)p); }
inline	byte*	sys_read_rom_font(void){ return (byte*)pekoe64_syscall(0x0030); }
inline	int		sys_gs_set_mode(int w,int h,uint8 bpp){ return pekoe64_syscall(0x0032,(intptr)((uint64)h<<32)+(w<<16)+(bpp)); }
inline	int		sys_gs_set_mode(GSSTATUS* p){ return pekoe64_syscall(0x0032,*(uint64*)p); }
inline	int		sys_gs_get_status(GSSTATUS* p){ return pekoe64_syscall(0x0033,(intptr)p); }
inline	int		sys_gs_draw_pixel(int x,int y){ return pekoe64_syscall(0x0034,x,y); }
inline	int		sys_gs_set_pixel_RGB(int x,int y,uint32 color){ return pekoe64_syscall(0x0035,x,y,color); }
inline	int		sys_gs_set_pixel(int x,int y,uint8 color){ return pekoe64_syscall(0x0036,x,y,color); }
inline	int		sys_nls_get_codepage(){ return pekoe64_syscall(0x003C,0x00); }
inline	int		sys_nls_set_codepage(int cp){ return pekoe64_syscall(0x003C,0x01,cp); }
inline	uint32	sys_nls_convert_ucs_to_oem(int cp,uint32 code){ return pekoe64_syscall(0x003C,0x02,cp,code); }
inline	uint32	sys_dosx_get_current_drive_devid(){ return pekoe64_syscall(0x003F,1,0); }
inline	uint64	sys_dosx_get_current_directory_index(){ return pekoe64_syscall(0x003F,1,1); }
inline	pvoid	sys_get_address(intptr p){ return (pvoid)(0xFFFFFE0000000000+p); }
inline	intptr	sys_get_real_address(pvoid p){ return ((intptr)p&0xFFFFFF); }

inline	int	sys_fs_open(uint32 devid,intptr index){
	CALLFS_OPEN param;
	param.fscmd=devcall_open;
	param.device=devid;
	param.index=index;
	return sys_call_filesys(&param);
}
inline	int	sys_fs_close(uint32 devid,intptr index){
	CALLFS_OPEN param;
	param.fscmd=devcall_close;
	param.device=devid;
	param.index=index;
	return sys_call_filesys(&param);
}
inline	int	sys_fs_ioctl(uint32 devid,intptr cmd,intptr length,pvoid data){
	CALLFS_IOCTL param;
	param.fscmd=devcall_ioctl;
	param.device=devid;
	param.ioctl_cmd=cmd;
	param.length=length;
	param.data=data;
	return sys_call_filesys(&param);
}
inline	int	sys_fs_read(uint32 devid,intptr index,intptr offset,pvoid buffer,int count){
	CALLFS_DTX param;
	param.fscmd=devcall_read;
	param.device=devid;
	param.index=index;
	param.offset=offset;
	param.data=buffer;
	param.count=count;
	int err=sys_call_filesys(&param);
	return (err<0)?err:count-param.count;
}
inline	int	sys_fs_write(uint32 devid,intptr index,intptr offset,pvoid buffer,int count){
	CALLFS_DTX param;
	param.fscmd=devcall_write;
	param.device=devid;
	param.index=index;
	param.offset=offset;
	param.data=buffer;
	param.count=count;
	int err=sys_call_filesys(&param);
	return (err<0)?err:count-param.count;
}
inline	int	sys_fs_read_dir(uint32 devid,intptr index,intptr offset,pvoid buffer){
	CALLFS_DTX param;
	param.fscmd=devcall_read_dir;
	param.device=devid;
	param.index=index;
	param.offset=offset;
	param.data=buffer;
	param.count=1;
	return sys_call_filesys(&param);
}

#endif
