//
//	OrangePekoe GBC Packet Function
//
//	(c)2004 The OrangePekoe project
//

#ifndef	_GBC_H_
#define	_GBC_H_


//	GBC packet
struct	GBC_NOP {
	uint32	cmd;
};
struct	GBC_XY {
	uint32	cmd,x,y;
};
struct	GBC_SET_PIXEL {
	uint32	cmd,x,y,color;
};

struct	GBC_BLT_FAST {
	uint32	cmd,bpp,x,y,w,h;
	uint64	pattern;
};



inline	int gbc_clear_screen(){
	GBC_NOP gbc;
	gbc.cmd=0x00000010;
	return sys_gs_send_packet(&gbc);
}

inline	int gbc_set_color(uint8 index){
	GBC_NOP gbc;
	gbc.cmd=0x00000012+(index<<24);
	return sys_gs_send_packet(&gbc);
}

inline	int gbc_set_bk_color(uint8 index){
	GBC_NOP gbc;
	gbc.cmd=0x00000013+(index<<24);
	return sys_gs_send_packet(&gbc);
}

inline	int gbc_save_cursor_block(uint x,uint y){
	GBC_XY gbc;
	gbc.cmd=0x0000001D;
	gbc.x=x;
	gbc.y=y;
	return sys_gs_send_packet(&gbc);
}

inline	int gbc_restore_cursor_block(){
	GBC_NOP gbc;
	gbc.cmd=0x0000001E;
	return sys_gs_send_packet(&gbc);
}

inline	int gbc_destroy_cursor_block(){
	GBC_NOP gbc;
	gbc.cmd=0x0000001F;
	return sys_gs_send_packet(&gbc);
}

inline	int gbc_set_pixel_index(uint x,uint y,uint8 index){
	GBC_SET_PIXEL gbc;
	gbc.cmd=0x00000020;
	gbc.x=x;
	gbc.y=y;
	gbc.color=index;
	return sys_gs_send_packet(&gbc);
}

inline	int gbc_set_pixel_argb(uint x,uint y,uint32 argb){
	GBC_SET_PIXEL gbc;
	gbc.cmd=0x00000021;
	gbc.x=x;
	gbc.y=y;
	gbc.color=argb;
	return sys_gs_send_packet(&gbc);
}

inline	int gbc_set_pixel_native(uint x,uint y,uint32 color){
	GBC_SET_PIXEL gbc;
	gbc.cmd=0x00000022;
	gbc.x=x;
	gbc.y=y;
	gbc.color=color;
	return sys_gs_send_packet(&gbc);
}

inline	int gbc_draw_pixel(uint x,uint y){
	GBC_XY gbc;
	gbc.cmd=0x00000023;
	gbc.x=x;
	gbc.y=y;
	return sys_gs_send_packet(&gbc);
}

inline	int gbc_blt_fast (uint bpp,uint x,uint y,uint w,uint h,void* pattern){
	GBC_BLT_FAST gbc;
	gbc.cmd=0x00000024;
	gbc.bpp=bpp;
	gbc.x=x;
	gbc.y=y;
	gbc.w=w;
	gbc.h=h;
	gbc.pattern=(uint64)(intptr)pattern;
	return sys_gs_send_packet(&gbc);
}

inline	int gbc_blt_trans (uint bpp,uint x,uint y,uint w,uint h,void* pattern){
	GBC_BLT_FAST gbc;
	gbc.cmd=0x00000024;
	gbc.bpp=0x80000000|bpp;
	gbc.x=x;
	gbc.y=y;
	gbc.w=w;
	gbc.h=h;
	gbc.pattern=(uint64)(intptr)pattern;
	return sys_gs_send_packet(&gbc);
}

inline	int gbc_blt_screen (uint bpp,uint x,uint y,uint w,uint h,void* pattern){
	GBC_BLT_FAST gbc;
	gbc.cmd=0x00000025;
	gbc.bpp=bpp;
	gbc.x=x;
	gbc.y=y;
	gbc.w=w;
	gbc.h=h;
	gbc.pattern=(uint64)(intptr)pattern;
	return sys_gs_send_packet(&gbc);
}

#endif
