//
//	pseudo-winapi
//

#ifndef _WINDOWS_
#define _WINDOWS_

#include "pekoe.h"
#include "string.h"

extern "C" {

#define	__Win64HandleToDosHandle(h)	(HFILE)(intptr)(h)
#define	__DosHandleToWin64Handle(h)	(HANDLE)(intptr)(h)
const	HANDLE	INVALID_HANDLE_VALUE	= (HANDLE)-1;
const	DWORD	INVALID_FILE_SIZE		= 0xFFFFFFFF;

typedef	LPVOID	LPOVERLAPPED,LPSECURITY_ATTRIBUTES;


BOOL	Beep(DWORD dwFreq,DWORD dwDuration);
inline	void Sleep(DWORD dwMilliseconds){ sys_sleep(dwMilliseconds); }
inline	void ExitProcess(UINT uExitCode){ _dos_exit(uExitCode); }

LPVOID	VirtualAlloc(LPVOID lpAddress,DWORD dwSize,DWORD flAllocationType,DWORD flProtect);
BOOL	VirtualFree(LPVOID lpAddress,DWORD dwSize,DWORD dwFreeType);
BOOL	VirtualProtect(LPVOID lpAddress,DWORD dwSize,DWORD flNewProtect,PDWORD lpflOldProtect);


inline	VOID	CopyMemory(PVOID Destination,CONST VOID *Source,DWORD Length){ memcpy(Destination,Source,Length); }
inline	VOID	MoveMemory(PVOID Destination,CONST VOID *Source,DWORD Length){ memmove(Destination,Source,Length); }
inline	VOID	FillMemory(PVOID Destination,DWORD Length,BYTE Fill){ memset(Destination,Length,Fill); }
VOID	ZeroMemory(PVOID Destination,DWORD Length);


enum { STD_INPUT_HANDLE=-10,STD_OUTPUT_HANDLE=-11,STD_ERROR_HANDLE=-12 };
HANDLE	GetStdHandle(DWORD nStdHandle);
BOOL	SetStdHandle(DWORD nStdHandle,HANDLE hHandle);

struct COORD {
	SHORT X;
	SHORT Y;
}; 

const	WORD	FOREGROUND_BLUE			=0x0001;
const	WORD	FOREGROUND_GREEN		=0x0002;
const	WORD	FOREGROUND_RED			=0x0004;
const	WORD	FOREGROUND_INTENSITY	=0x0008;
const	WORD	BACKGROUND_BLUE			=0x0010;
const	WORD	BACKGROUND_GREEN		=0x0020;
const	WORD	BACKGROUND_RED			=0x0040;
const	WORD	BACKGROUND_INTENSITY	=0x0080;

#define	WriteConsole	WriteConsoleA
BOOL	WriteConsole(HANDLE,CONST LPVOID,DWORD,LPDWORD,LPVOID);
BOOL	SetConsoleTextAttribute(HANDLE hConsoleOutput,WORD wAttributes);
BOOL	SetConsoleCursorPosition(HANDLE hConsoleOutput,COORD dwCursorPosition);


inline	int	_getdrive(void){ return _dos_get_current_drive(); }
inline	int	_chdrive(int drive){ _dos_select_disk(drive); return 0; }
inline	int	_chdir(const char *dirname){ return 0; }
inline	char	*_getcwd(char *buffer,int maxlen){ return NULL; }
inline	int	_mkdir(const char *dirname){ return 0; }
inline	int	_rmdir(const char *dirname){ return 0; }
inline	HFILE	_lcreat(LPCTSTR lpPathName,int iAttribute){ return _dos_create(lpPathName,iAttribute); }
inline	HFILE	_lopen(LPCTSTR lpPathName,int iReadWrite){ return _dos_open(iReadWrite,lpPathName);}
inline	HFILE	_lclose(HFILE hFile){ return _dos_close(hFile);}
inline	UINT	_lread(HFILE hFile,LPVOID lpBuffer,UINT uBytes){ return _dos_read(hFile,lpBuffer,uBytes); }
inline	UINT	_lwrite(HFILE hFile,LPVOID lpBuffer,UINT uBytes){ return _dos_write(hFile,lpBuffer,uBytes); }
#ifdef _PEKOE32_
inline	LONG	_lseek(HFILE handle,LONG offset,int origin ){ return _dos_seek(handle,offset,origin); }
inline	LONG64	_lseeki64(HFILE handle,LONG64 offset,int origin ){ return _dos_seeki64(handle,offset,origin); }
#else
inline	LONG64	_lseek(HFILE handle,LONG64 offset,int origin ){ return _dos_seek(handle,offset,origin); }
#define	_lseeki64	_lseek
#endif

#define	GENERIC_READ					(0x80000000L)
#define	GENERIC_WRITE					(0x40000000L)
#define	GENERIC_EXECUTE					(0x20000000L)
#define	GENERIC_ALL						(0x10000000L)

enum MoveMethod {
	FILE_BEGIN=0,FILE_CURRENT,FILE_END 
};

enum CreationDisposition{
	CREATE_NEW=1,CREATE_ALWAYS,OPEN_EXISTING,OPEN_ALWAYS,TRUNCATE_EXISTING
};

#define	CreateFile CreateFileA
HANDLE	CreateFile(LPCTSTR lpFileName,DWORD dwDesiredAccess,DWORD dwShareMode,
	LPSECURITY_ATTRIBUTES lpSecurityAttributes,DWORD dwCreationDisposition,DWORD dwFlagsAndAttributes,HANDLE hTemplateFile);
BOOL	CloseHandle(HANDLE);
BOOL	ReadFile(HANDLE,LPVOID,DWORD,LPDWORD,LPOVERLAPPED);
BOOL	WriteFile(HANDLE,LPVOID,DWORD,LPDWORD,LPOVERLAPPED);
#ifdef _PEKOE32_
LONG	SetFilePointer(HANDLE hFile,LONG lDistanceToMove,PLONG lpDistanceToMoveHigh,DWORD dwMoveMethod);
LONG	GetFileSize(HANDLE hFile,LPDWORD lpFileSizeHigh);
#else
LONG64	SetFilePointer(HANDLE hFile,LONG64 lDistanceToMove,PLONG lpDistanceToMoveHigh,DWORD dwMoveMethod);
LONG64	GetFileSize(HANDLE hFile,LPDWORD lpFileSizeHigh);
#endif
DWORD	GetLastError(void);
DWORD	GetCurrentDirectory(DWORD nBufferLength,LPTSTR lpBuffer);
BOOL	CreateDirectory(LPCTSTR lpPathName,LPSECURITY_ATTRIBUTES lpSecurityAttributes);
BOOL	RemoveDirectory(LPCTSTR lpPathName);
BOOL	CreateDirectoryEx(LPCTSTR lpTemplateDirectory,LPCTSTR lpNewDirectory,LPSECURITY_ATTRIBUTES lpSecurityAttributes);

}
#endif
