#!

@files	= <*.cpp>;
push(@files,<../libcommon/*.cpp>);
for(@files){
	$obj = $_;
	/([\w\-\.]+)\.cpp$/;
	$obj{$_}=$1.".o";
}

for(sort(keys %obj)){
	open(FILE,"gcc -MM -I ../include $_ |");
	push(@lines,<FILE>);
	close(FILE);
	push(@lines,"\t\$(CC) \$(CF64) \$(CFBASE) \$(CFINCLUDE) -o $obj{$_} $_ \n\n");
}

open(FILE,">Makefile");
binmode(FILE);
print FILE <<EOT;
include ../user/Makefile.inc

CFINCLUDE	= -I../include

EOT
print FILE "all:\t" . join("\\\n\t",sort(values %obj)) . "\n\n";
print FILE "clean:\n\t-rm -f *.o\n\n";
print FILE @lines;
close(FILE);
