//
//	おれんじぺこ コマンドプロセッサ
//
//	とても汚いので将来綺麗にしたい
//
// this file is encoded in utf-8
//

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/errno.h>


//	1で常にecho on (デバグ用)
#define	_FORCE_ECHO		0


#define	MAX_CMDLINE	512
static	char	cmdname[MAX_CMDLINE];
static	char	cmdname2[MAX_CMDLINE];
static	char	cmdbuff[MAX_CMDLINE];
static	char	cmdline[MAX_CMDLINE];

static	readdir_t	dirbuff;

static	int		in_batfile=0;
static	int 	opt_p=0;
static	int		opt_echo=0;
static	int		error_level=0;


int	_htoi(char);
char* _gets(char*);
char* get_err_string(int);
int do_cmd(const char*);
char* lgets();
int do_bat(char*);

#define	SZ_LGETSBUFF	0x1000
static char	lgbuff[SZ_LGETSBUFF];
static uint	lgptr,lgfp=0;
static int	lgfd;

int	bcd2bin(int bcd){
	return (bcd&0x0F)+(bcd>>4)*10;
}


int	_htoi(char c){
	switch(c){
	case '0'...'9':
		return c&0xF;
	case 'A'...'Z':
		return c-55;
	case 'a'...'z':
		return c-87;
	default:
		return -1;
	}
}

static char getsbuff[72+2];
char* _gets(char* s){
	getsbuff[0]=72;
	_dos_get_string(getsbuff);
	getsbuff[2+getsbuff[1]]=0;
	strcpy(s,getsbuff+2);
	return s;
}

char* get_err_string(int errno){
	switch(errno>0?errno:-errno){
		case ENOENT:
			return "No such file or directory";
		case EIO:
			return "Input/output error";
		case ENOEXEC:
			return "Exec format error";
		case EBADF:
			return "Bad file descriptor";
		case ENOMEM:
			return "Cannot allocate memory";
		case EACCES:
			return "Permission denied";
		case EFAULT:
			return "Bad address";
		case EBUSY:
			return "Device busy";
		case EINVAL:
			return "Invalid argument";
		case ENFILE:
			return "Too many open files in system";
		case EMFILE:
			return "Too many open files";
		case EROFS:
			return "Read-only filesystem";
		case ENODEV:
			return "Operation not supported by device";
		default:
			return "Unknown Error";
	}
}

void cmd_dir(){
	//	ここだけDOSから遠くかけ離れてる・・・
	uint32	devid=sys_dosx_get_current_drive_devid();
	intptr	dirid=sys_dosx_get_current_directory_index();
	for(intptr index=0;!sys_fs_read_dir(devid,dirid,index,&dirbuff);index++){
		if(!dirbuff.raw[0])
			break;
		if(dirbuff.raw[0]!=0xE5){
			printf(" %c%c%c%c %12d %.16s\n"
				,(dirbuff.attr&0x10 ? 'd':'-' )
				,(dirbuff.attr&0x20 ? 'a':'-' )
				,(dirbuff.attr&0x01 ? '-':'w' )
				,(dirbuff.attr&0x08 ? '-':'r' )
				,(long)dirbuff.size,dirbuff.filename);
		}
	}
	volume_info vi;
	int err=sys_fs_ioctl(devid,ioctl_get_information,sizeof(vi),&vi);
	if(err<0){
		puts(get_err_string(err));
	}else{
		printf("      %12d Bytes free\n      %12d Bytes total\n"
			,(long)vi.records.BytesParRecord*(long)vi.records.nFreeRecords
			,(long)vi.records.BytesParRecord*(long)vi.records.nTotalRecords);
	}
}

int cmd_type(const char* file){
	int fd=open(file,O_RDONLY,0);
	if(fd>=0){
		int count;
		char* readbuff=new char[4096];
		while(count=read(fd,readbuff,4096),count>0){
			write(1,readbuff,count);
		}
		delete readbuff;
		close(fd);
		putch('\n');
		return 0;
	}else{
		return fd;
	}
}

int do_cmd(const char* cmd){
	for(;*cmd==' '||*cmd=='\t';cmd++);
	strncpy(cmdbuff,cmd+(*cmd=='@'),MAX_CMDLINE-1);
	strcpy(cmdline,cmdbuff);
	strcpy(cmdname,strtok(cmdbuff," "));
	string param=strtok(NULL," ");
	if(!param) param="";

	if(!*cmdname||!stricmp(cmdname,"rem")){
		;
	}else if(cmdname[0]=='!' && cmdname[1]=='\0'){	//	!
//		asm volatile("int $3");
		volatile int i=*(int*)NULL; // ぬるぽ
	}else if(cmdname[1]==':' && cmdname[2]=='\0'){	//	x:
		_dos_select_disk((cmdname[0]&0x1F)-1);
	}else if(!stricmp(cmdname,"echo")){
		if(!stricmp(param,"on")){
			opt_echo=1;
		}else if(!stricmp(param,"off")){
			opt_echo=0;
		}else if(*param){
			puts(cmdline+5);
		}else{
			printf("ECHO is %s\n",opt_echo?"on":"off");
		}
	}else if(!stricmp(cmdname,"echo.")){
		puts("");
	}else if(!stricmp(cmdname,"pause")){
		if(*param){
			puts(cmdline+6);
		}else{
			puts("Press any key to continue...");
		}
		getch();
	}else if(!stricmp(cmdname,"if")){
		string param2=strtok(NULL," ");
		if(!stricmp(param,"exist")){
			if(!param2){
				puts("syntax error in if");
			}else{
				int fd=open(param2);
				if(fd>=0){
					close(fd);
					char* cmdbuff=new char[MAX_CMDLINE];
					cmdbuff[0]=0;
					char* s;
					do{
						s=strtok(NULL," ");
						if(s) sprintf(cmdbuff,"%s %s",cmdbuff,s);
					}while(s);
					if(cmdbuff[0]) do_cmd(cmdbuff);
					delete cmdbuff;
				}
			}
		}else if(!stricmp(param,"errorlevel")){
			if(!param2){
				puts("syntax error in if");
			}else if(error_level>=atoi(param2)){
				char* cmdbuff=new char[MAX_CMDLINE];
				cmdbuff[0]=0;
				char* s;
				do{
					s=strtok(NULL," ");
					if(s) sprintf(cmdbuff,"%s %s",cmdbuff,s);
				}while(s);
				if(cmdbuff[0]) do_cmd(cmdbuff);
				delete cmdbuff;
			}
		}else{
			puts("feature not available");
		}
	}else if(!stricmp(cmdname,"set")){
		puts("feature not available");
	}else if(!stricmp(cmdname,"for")){
		puts("feature not available");
	}else if(!stricmp(cmdname,"goto")){
		if(in_batfile){
			uint save_lgptr=lgptr;
			if(param[0]==':') param++;
			lgptr=0;
			char* s;
			do{
				s=lgets();
			}while(s&&(s[0]!=':'||stricmp(s+1,param)));
			if(!s){
				printf("label not found - %s\n",param);
				lgptr=save_lgptr;
			}
		}
	}else if(!stricmp(cmdname,"shift")){
		puts("feature not available");
	}else if(!stricmp(cmdname,"type")){
		int fd=cmd_type(param);
		if(fd) puts(get_err_string(fd));
	}else if(!stricmp(cmdname,"cd")||!stricmp(cmdname,"chdir")){
		if(*param){
			int err=_dos_chdir(param);
			if(err<0){
				puts(get_err_string(err));
			}
		}else{
			puts("A:\\");
		}
	}else if(!stricmp(cmdname,"md")||!stricmp(cmdname,"mkdir")){
		puts("feature not available");
	}else if(!stricmp(cmdname,"rd")||!stricmp(cmdname,"rmdir")){
		puts("feature not available");
	}else if(!stricmp(cmdname,"del")||!stricmp(cmdname,"erase")){
		puts("feature not available");
	}else if(!stricmp(cmdname,"copy")){
		puts("feature not available");
	}else if(!stricmp(cmdname,"ren")){
		puts("feature not available");
	}else if(!stricmp(cmdname,"cls")){
		sys_clearconsole();
	}else if(!stricmp(cmdname,"color")){
		if(param[0]&&param[1]){
			sys_set_color(_htoi(param[0])*0x10+_htoi(param[1]));
		}else{
			sys_set_color(0);
		}
	}else if(!stricmp(cmdname,"chcp")){
		printf("codepage: %d\n",sys_nls_get_codepage());
	}else if(!stricmp(cmdname,"dir")){
		cmd_dir();
	}else if(!stricmp(cmdname,"date")||!stricmp(cmdname,"time")){
		SYS_READ_CLOCK rc;
		sys_read_clock(&rc);
		printf("%d-%02d-%02d %02d:%02d:%02d\n",2000+bcd2bin(rc.year),bcd2bin(rc.month)
			,bcd2bin(rc.date),bcd2bin(rc.hour),bcd2bin(rc.min),bcd2bin(rc.sec));
	}else if(!stricmp(cmdname,"ver")){
		if(!stricmp(param,"/r")){
			uint ver=_dos_get_version();
			printf(
				"OrangePekoe DOS Version %d.%02d\n"
				"Revision A (Unicode Version)\n"
				"DOS is in Protected Memory\n"
				,LOBYTE(ver),HIBYTE(ver)
				);
		}else{
			uint64	ver=sys_get_version();
			printf(
				"OrangePekoe%s version %d.%02d.%04d\n"
				"  (C)2004 The OrangePekoe project\n"
				"  (C)2004 Open Source Software for OrangePekoe\n"
				"    http://orange-pekoe.64b.org/\n"
				,(ver&0x80000000)?" Fannings":""
				,LOBYTE(ver),HIBYTE(ver),HIWORD(ver)&0x7FFF
				);
		}
	}else if(!stricmp(cmdname,"exit")){
		if(opt_p){
			printf("exit: Can't exit from permanent shell.\n");
		}else{
			exit(0);
		}
	}else if(!stricmp(cmdname,"mem")){
		printf(
			"Total Physical Memory:	%dKB\n"
			"Paged Pool Available:	%dKB\n"
			"System Resource Left:	%dKB\n"
			"Current Process:	%dKB/%dKB\n"
			,(sys_get_memory_status(0)>>10)
			,(sys_get_memory_status(1)>>10)
			,(sys_get_memory_status(2)>>10)
			,(sys_get_memory_status(0x1001)>>10)
			,(sys_get_memory_status(0x1000)>>10)
		);
	}else if(!stricmp(cmdname,"mode")){
		if(param&&!stricmp(param,"cpu")){
			printf("Shell is %dbit, Kernel is %dbit.\n",sizeof(void*)*8,(sys_get_version()&0x80000000)?32:64);
		}else{
			GSSTATUS	gs;
			sys_gs_get_status(&gs);
			if(param&&!stricmp(param,"video"))
				param=strtok(NULL," ");
			string param2=strtok(NULL," ");
			string param3=strtok(NULL," ");
			int p3=param3?atoi(param3):0;
			if(param&&param2){
				if(sys_gs_set_mode(atoi(param),atoi(param2),p3?p3:gs.bpp)){
					printf("mode: couldn't connect video server.\n");
				}
			}else{
				printf("screen mode: %dx%d %dbpp,%s,vram=%p\n",gs.width,gs.height,gs.bpp,
					(gs.flags&0x10 ? "graphics":"text"),gs.framebuffer);
			}
		}
	}else if(!stricmp(cmdname,"shutdown")){
		puts("Shutting down now!!!");
		_dos_sync();
		_dos_select_disk(-1);
		sys_set_color(0x0E);
		sys_gs_set_mode(80,25,3);
		puts("It is now safe to turn off your computer\nor Press ctrl-alt-del to restart computer");
		sys_sleep(500);
		sys_powerdown();
	}else{
		int exec_return;
		strcpy(cmdname2,cmdname);
		int cmdlen=strlen(cmdname2);
		if(cmdlen>4&&!stricmp(cmdname2+cmdlen-4,".bat")){
			exec_return = do_bat(cmdname2);
		}else{
			exec_return = _dos_exec(cmdname2,cmdline);
		}
		switch(exec_return){
		case -ENOENT:
		case -ENOEXEC:
			strcpy(cmdname2,cmdname);
			strcat(cmdname2,".com");
			exec_return = _dos_exec(cmdname2,cmdline);
			break;
		}
		switch(exec_return){
		case -ENOENT:
			strcpy(cmdname2,cmdname);
			strcat(cmdname2,".exe");
			exec_return = _dos_exec(cmdname2,cmdline);
			break;
		}
		switch(exec_return){
		case -ENOENT:
			strcpy(cmdname2,cmdname);
			strcat(cmdname2,".bat");
			exec_return = do_bat(cmdname2);
			break;
		}
		if(exec_return>=0){
			return error_level=exec_return;
		}else if(exec_return<0){
			switch(exec_return){
			case -ENOENT:
				puts("Bad command of file name");
				break;
			default:
				puts(get_err_string(exec_return));
			}
			return exec_return;
		}
	}
	return 0;
}



char* lgets(){
	static uint	sz;
	if(!lgptr){
		lseek(lgfd,0,lgfp);
		sz=read(lgfd,lgbuff,SZ_LGETSBUFF);
		if(!sz) return NULL;
		if(!memcmp(lgbuff,"\xEF\xBB\xBF",3)){ // SKIP BOM
			lgptr=3;
		}else{
			lgptr=0;
		}
	}
	uint p;
	do{
		p=lgptr;
		for(;lgptr<sz&&lgbuff[lgptr]!=0&&lgbuff[lgptr]!='\n'&&lgbuff[lgptr]!='\r';lgptr++){}
		if(lgptr>=sz) return NULL;
		lgbuff[lgptr]=0;lgptr++;
	}while(!lgbuff[p]);
	return lgbuff+p;
}

int do_bat(char* batfile){
	if(in_batfile) return -EACCES;
	lgptr=0;
	lgfd=open(batfile);
	if(lgfd>0){
		lgfp=0;
		in_batfile++;
		opt_echo=1;
		char*s;
		do{
			s=lgets();
			if(s){
				for(;*s==' '||*s=='\t';s++);
#if _FORCE_ECHO
				puts(s);
#else
				if(opt_echo&&*s!='@') puts(s);
#endif
				if(*s!=':') do_cmd(s);
			}
		}while(s);
		close(lgfd);
		in_batfile--;
		return 0;
	}else{
		return lgfd;
	}
}

int main(int argc,char **argv){
	if(argc>1){
		int opt_c=0,opt_k=0;
		for(int i=1;i<argc;i++){
			if(argv[i][0]=='-'||argv[i][0]=='/'){
				switch(argv[i][1]&0xDF){
				case 'P':
					opt_p=1;
					break;
				case 'C':
					opt_c=1;
					break;
				case 'K':
					opt_k=1;
					break;
				default:
					printf("Unknown option - %s\n",argv[i]);
				}
				if(opt_c||opt_k){
					char* cmdbuff=new char[MAX_CMDLINE];
					cmdbuff[0]=0;
					for(i++;i<argc;i++){
						sprintf(cmdbuff,"%s %s",cmdbuff,argv[i]);
					}
					do_cmd(cmdbuff);
					if(opt_c) exit(0);
					delete cmdbuff;
				}
			}else{
				printf("Unknown command line - %s\n",argv[i]);
			}
		}
	}
	{
		uint64	ver=sys_get_version();
		printf("OrangePekoe Command Processor version %d.%02d.%04d\n"
			,LOBYTE(ver),HIBYTE(ver),HIWORD(ver)&0x7FFF);
	}
	for(;;){
		printf("[%c]",('A'+_dos_get_current_drive()));
		char getbuff[MAX_CMDLINE];
		_gets(getbuff);
		int exec_return = do_cmd(getbuff);
		if(exec_return>0) printf("cmd: A program terminated with error code %d\n",exec_return);
	}
}
