//
//	definitions for OrangePekoe DOS64
//

#ifndef	_DOS64_H_
#define	_DOS64_H_

#include "types.h"

extern "C++" {
DOSRESULT	bdos(uint8 funcno,intptr param);
}
extern "C"{
extern	pvoid	__ebss;
extern	pvoid	__psp;
intptr	_dos_AXCXDX(uint32 ax,intptr cx=0,intptr dx=0);
intptr	_dos_AXCXDXBX(uint32 ax,intptr cx,intptr dx,intptr bx);
void	_dos_exit(uint8 exitcode=0);
uint	_dos_get_version(void);
char**	parse_cmdline(int& __argc);
}
inline	pvoid	_dos_get_psp(void){ return __psp; }

const	HFILE	__stdin		=0;
const	HFILE	__stdout	=1;
const	HFILE	__stderr	=2;
const	HFILE	__stdaux	=3;
const	HFILE	__stdprn	=4;

enum {
	SEEK_SET=0,SEEK_CUR,SEEK_END
};

inline	DOSRESULT	bdos(uint8 funcno,pvoid param){ return bdos(funcno,(intptr)param); }
inline	DOSRESULT	bdos(uint8 funcno){ return bdos(funcno,(intptr)0); }
inline	char	_dos_getche(void){ return bdos(0x01); }
inline	void	_dos_putch(char c){ bdos(0x02,c); }
inline	char	_dos_getch(void){ return bdos(0x08); }
inline	void	_dos_put_string(char*s){ bdos(0x09,s); }
inline	void	_dos_get_string(char*s){ bdos(0x0A,s); }
inline	char	_dos_kbhit(void){ return bdos(0x0B); }
inline	DOSRESULT	_dos_sync(void){ return bdos(0x0D); }
inline	DOSRESULT	_dos_select_disk(int8 d){ return bdos(0x0E,d); }
inline	int8			_dos_get_current_drive(){ return bdos(0x19); }
inline	void	_dos_keep_process(uint8 exitcode=0){ _dos_AXCXDX(0x3100+exitcode); }
inline	DOSRESULT	_dos_mkdir(string name){ return _dos_AXCXDX(0x3900,0,(intptr)name); }
inline	DOSRESULT	_dos_rmdir(string name){ return _dos_AXCXDX(0x3A00,0,(intptr)name); }
inline	DOSRESULT	_dos_chdir(string name){ return _dos_AXCXDX(0x3B00,0,(intptr)name); }
inline	HFILE	_dos_create(string name,uint32 attributes){ return _dos_AXCXDX(0x3C00,attributes,(intptr)name); }
inline	HFILE	_dos_open(uint8 mode,string name){ return _dos_AXCXDX(0x3D00+mode,0,(intptr)name); }
inline	DOSRESULT	_dos_close(HFILE file){ return _dos_AXCXDXBX(0x3E00,0,0,file); }
inline	int32	_dos_read(HFILE file,pvoid buffer,int32 count){ return _dos_AXCXDXBX(0x3F00,count,(intptr)buffer,file); }
inline	int32	_dos_write(HFILE file,pvoid buffer,int32 count){ return _dos_AXCXDXBX(0x4000,count,(intptr)buffer,file); }
inline	int64	_dos_seek(HFILE file,int64 offset,int8 origin){ return _dos_AXCXDXBX(0x4200+origin,0,offset,file); }
inline	HFILE	_dos_dup(HFILE file){ return _dos_AXCXDXBX(0x4500,0,0,file); }
inline	DOSRESULT	_dos_dup2(HFILE file1,HFILE file2){ return _dos_AXCXDXBX(0x4600,file2,0,file1); }
inline	int		_dos_exec(string name){ return _dos_AXCXDXBX(0x4B00,0,(intptr)name,0); }
inline	int		_dos_exec(string name,string arg){ return _dos_AXCXDXBX(0x4B00,0,(intptr)name,(intptr)arg); }
inline	int		_dos_getlasterr(void){ return bdos(0x59); }
inline	HFILE	_dos_create_new(string name,uint32 attributes){ return _dos_AXCXDX(0x5B00,attributes,(intptr)name); }
inline	pvoid	_dos_psp(void){ return _dos_get_psp(); }
inline	void	_dos_idle(void){ asm volatile("int $0x28 \n"); }

#endif
