//
//	64bit types
//

#ifndef	_TYPES_H_
#define	_TYPES_H_


#ifndef NULL
#define	NULL 0
#endif


//	Native types
#ifndef _MSC_VER
#define	__int64 long long
#endif
typedef	unsigned char		byte,uint8;
typedef	signed char			sbyte,int8;
typedef	unsigned short		word,uint16;
typedef	signed short		int16;
typedef	unsigned int		dword,uint,uint32;
typedef	signed int			int32;
typedef	unsigned __int64	qword,uint64,intptr;
typedef	signed __int64		int64,ssize_t;
typedef	void				*pvoid;
typedef	int32				HFILE;
typedef	int8				DOSRESULT;
typedef	const char			*string;
#define	interface			struct

#ifndef __SIZE_TYPE__
#define __SIZE_TYPE__ unsigned long
#endif
typedef	__SIZE_TYPE__ size_t;

#ifndef __TIME_TYPE__
#define __TIME_TYPE__ unsigned long
#endif
typedef	__TIME_TYPE__ time_t;


//	WIN64 types
#undef FAR
#undef NEAR
#define FAR
#define NEAR
#ifndef CONST
#define CONST		const
#endif

#ifndef FALSE
#define FALSE				0
#endif

#ifndef TRUE
#define TRUE				1
#endif

#ifndef IN
#define IN
#endif

#ifndef OUT
#define OUT
#endif

#ifndef OPTIONAL
#define OPTIONAL
#endif

typedef	uint32				UINT32,ULONG32;
typedef	int32				INT32,LONG32;
typedef	uint64				UINT64,ULONG64,SIZE_T,UINT_PTR,ULONG_PTR;
typedef	int64				INT64,LONG64,SSIZE_T,INT_PTR,LONG_PTR;

typedef	uint32				ULONG,*PULONG;
typedef	unsigned int		UINT,*PUINT;
typedef	unsigned short		USHORT,*PUSHORT;
typedef	unsigned char		UCHAR,*PUCHAR;
typedef	int32				LONG,*PLONG,*LPLONG;
typedef	int					INT,*PINT;
typedef	short				SHORT,*PSHORT;
typedef	signed char			CHAR,*PCHAR;
typedef	char				*PSZ;

typedef	int					BOOL,*PBOOL,*LPBOOL;
typedef	uint8				BYTE,*PBYTE,*LPBYTE;
typedef	uint16				WORD,*PWORD,*LPWORD;
typedef	uint32				DWORD,*PDWORD,*LPDWORD;
typedef	uint64				QWORD,*PQWORD,*LPQWORD;
typedef	uint32				DWORD32,*PDWORD32;
typedef	uint64				DWORD64,*PDWORD64;
typedef	float				FLOAT,*PFLOAT;
typedef	void FAR			*LPVOID;
typedef	CONST void FAR		*LPCVOID;

typedef	void				VOID,*LPVOID,*PVOID,*HANDLE;
typedef	char				*LPSTR;
typedef	const char			*LPCSTR;
typedef	char				TCHAR;
typedef	TCHAR				*LPTSTR;
typedef	const TCHAR			*LPCTSTR;
interface	IUnknown;

#define LODWORD(q)	((dword)(q))
#define HIDWORD(q)	((dword)(((qword)(q) >> 32) & 0xFFFFFFFF))
#define LOWORD(l)	((WORD)(l))
#define HIWORD(l)	((WORD)(((DWORD)(l) >> 16) & 0xFFFF))
#define LOBYTE(w)	((BYTE)(w))
#define HIBYTE(w)	((BYTE)(((WORD)(w) >> 8) & 0xFF))


#endif
