#if !defined(_IDT_H_INCLUDED_)
#define _IDT_H_INCLUDED_

#define AMD64_INVS   0x0   /* 0 */
#define AMD64_KCS    0x8   /* 1, RPL = 0 */
#define AMD64_KDS    0x10  /* 2, RPL = 0 */
#define AMD64_UCS32  0x1b  /* 3, RPL = 3 */
#define AMD64_UDS    0x23  /* 4, RPL = 3 */
#define AMD64_UCS    0x2b  /* 5, RPL = 3 */
#define AMD64_UTCBS  0x33  /* 6, RPL = 3 */
#define AMD64_KDBS   0x38  /* 7, RPL = 0 */
#define AMD64_TBS    0x43  /* 8, RPL = 0 */
#define AMD64_TSS    0x48  /* 9, RPL = 0 */

#define AMD64_EXC_DIVIDE_ERROR          0
#define AMD64_EXC_DEBUG                 1
#define AMD64_EXC_NMI                   2
#define AMD64_EXC_BREAKPOINT            3
#define AMD64_EXC_OVERFLOW              4
#define AMD64_EXC_BOUNDRANGE            5
#define AMD64_EXC_INVALIDOPCODE         6
#define AMD64_EXC_NOMATH_COPROC         7
#define AMD64_EXC_DOUBLEFAULT           8
#define AMD64_EXC_COPSEG_OVERRUN        9
#define AMD64_EXC_INVALID_TSS          10
#define AMD64_EXC_SEGMENT_NOT_PRESENT  11
#define AMD64_EXC_STACKSEG_FAULT       12
#define AMD64_EXC_GENERAL_PROTECTION   13
#define AMD64_EXC_PAGEFAULT            14
#define AMD64_EXC_RESERVED             15
#define AMD64_EXC_FPU_FAULT            16
#define AMD64_EXC_ALIGNEMENT_CHECK     17
#define AMD64_EXC_MACHINE_CHECK        18
#define AMD64_EXC_SIMD_FAULT           19

struct __idt {
	uint16 size;
	uint64 address;
};

struct __descriptor {
	uint64 offset_low  : 16;
	uint64 selector    : 16;
	uint64 ist         :  3;
	uint64 res0        :  5;
	uint64 type        :  4;
	uint64 s           :  1;
	uint64 dpl         :  2;
	uint64 p           :  1;
	uint64 offset_high : 48 __attribute__((packed));
	uint64 res1        : 32;
};

void loadIDT(uint16 size, uint64 address);
void loadIDTR(uint16 selector);
void set_handler(int index, uint16 selector, void (*address)(), int type, int dpl, int ist);
void add_int_gate(uint16 index, void (*address)());
void add_syscall_gate(uint16 index, void (*address)());
void add_trap_gate(uint16 index, void (*address)());
void error_handler(void);
void syscall_handler(void);
void init_handler();

#endif /* _IDT_H_INCLUDED_ */
