;;
;;  Initial Program Loader
;;
;;  platform:
;;      AT COMPATIBLE
;;      PC-98
;;      FM TOWNS
;;
;;  program:
;;      Sakky
;;
;;  to build:
;;      nasm -o ipl.bin -f bin ipl.nas
;;
[bits 16]

_HEAD:
	jmp short main
	nop
	db "IPL4OP  "
	dw 00200h
	db 1
	dw 1
	db 2
	dw 000E0h
	dw 2880
	db 0F0h
	dw 9
	dw 18
	dw 2
	times 10 db 0
	db 029h
	dd 0FFFFFFFFh
	;;  123456789AB
	db "NOS        "
	db "FAT12   "
forever:
	jmp short $
main:
	push sp
	pop si
	xor si,sp
	jnz forever
	push si
	popf
	mov ss,si
	mov sp,400h

	mov ax,cs
	mov cx,07C0h
	push cx
	cmp ah,0x1F
	ja initFMT
	jz init98
initAT:
	push byte (main0-_HEAD)
	retf
main0:
	push cs
	pop ds
	inc byte [_arch]
	xor ax,ax
	int 013h
	jmp short _next

initFMT:
	push cs
	pop ds
	mov ax,0x2002
	or  ah,bh
	mov [__PDA],ah
	mov [_arch],al
	jmp short init2

init98:
	push cs
	pop ds
	mov al,[ss:0584h]
	mov [__PDA],al
init2:
	mov al,[000Ch]
	shr al,1
	inc al
	mov [__N],al
	pop es
	xor di,di
	mov cx,200h/2
	rep movsw
	push es
	call _retf
	push cs
	pop ds

_next:
	push word 1000h
	pop es
	push es

	;; read Root DIR
	mov ax,[00011h]
	shl ax,5
	mov cx,ax
	mov si,[00016h]
	add si,si
	inc si
	xor dx,dx
	div word [0000Bh]
	add ax,si
	mov [fat2],ax
	xor bp,bp
	call diskread

	;; Read FAT
	mov ax,[00016h]
	mul word [0000Bh]
	xchg ax,cx
	mov si,1
	push cs
	pop es
	mov bp,00400h
	call diskread
	pop es

	;; Find System
	mov cx,[00011h]
	xor di,di
cfnl:
	push cx
	mov si,sysname
	mov cx,11
	rep cmpsb
	pop cx
	jz ff
	or di,byte 0001Fh
	inc di
	loop cfnl
	jmp forever
ff:
	and di,byte 0E0h
	mov bx,[0000Bh]
	mov si,[es:di+01Ah]
	xor bp,bp
	push es
	push bp
lfl:
	cmp si,00FF7h
	jae force
	push si
	sub si,byte 2
	add si,[fat2]
	mov cx,[0000Bh]
	call diskread
noread:
	pop ax
	mov bx,ax
	add bx,bx
	add bx,ax
	shr bx,1
	mov si,[cs:bx+00400h]
	jnc nfl0
	shr si,4
nfl0:
	and si,00FFFh
	jmp short lfl
force:

	;; jump system
	mov ax,"oL"
	mov cl,[_arch]
_retf:
	retf

	;; disk read
diskread:
	xchg ax,cx
	xor dx,dx
	div word [0000Bh]
	xchg ax,cx
drl:
	push cx

	xor dx,dx
	mov ax,si
	div word [00018h]
	inc dx
	shr ax,1
	adc dh,0
	mov bx,[0000Bh]
	cmp byte [_arch],0
	jz short dr98
	cmp byte [_arch],2
	jz short drFMT
	mov ch,al
	mov cl,dl
	mov dl,[__PDA]
	xchg bx,bp
	mov ax,00201h
	int 013h
	xchg bx,bp
	jmp short drmde
dr98:
	mov cl,al
	mov ch,[__N]
	mov al,[__PDA]
	mov ah,056h
	int 01Bh
drmde:
	jnc nohalt
	jmp forever
nohalt:
	shr bx,4
	mov ax,es
	add ax,bx
	mov es,ax
	inc si
	pop cx
	loop drl
	ret

drFMT:
	push bx
	push ds
	push di
	mov cl,al
	mov al,[__PDA]
	mov ah,005h
	mov bx,0x0001
	push es
	pop ds
	mov di,bp
	db 09Ah
	dd 0FFFB0014h
	pop di
	pop ds
	pop bx
	jmp short drmde


;;  Variables
cursor  dw 0,0A000h
fat2    dw 0
__PDA   db 0
__N     db 0
_arch   db 0

        ;;  FILENAMEEXT
sysname db "OSLDR      "

	times 001FEh-($-$$) db 0
	db 055h,0AAh

end
