//
//	64bit kernel
//
//  program:
//		Sakky
//
//  modified
//      bayside
//
//	platform:
//		AMD64
//
//	license:
//		BSD License
//

//#define	puts	__kputs
//#define	putchar	__kputchar
//#define	kprint	__kkprint

#include <pekoe.h>
#include <stdio.h>
#include <string.h>

#include "kernel.h"
#include "kprintf.h"
#include "idt.h"
#include "gdt.h"

struct __gdt* g_GDT64;
struct __descriptor g_IDT64[256];

__memstat memstat;

extern "C"
void start_kernel(const __memstat* m){
	memcpy(&memstat,m,sizeof(memstat));
	
	kprintf("OrangePekoe [Free version]\n(C)2004 The Open Source Software for OrangePekoe\n");
	kprintf("Memory: %dKB\n\n",(memstat.szMidMem+memstat.szHiMem+0x3FF)>>10);
	kprintf("Hello, 64bit world!\n");
	
	g_GDT64 = (__gdt*)(intptr)(0x10000 + memstat.gdt64_Base);
	
	#if 0
	kprintf("GDT: limit = %xH, base = %xH\n", g_GDT64->limit, g_GDT64->base);
	kprintf("  limit,      base, type\n");
	for (int i = 0; i < 11; i++) {
		kprintf("%6xH, %8xH, %2xH\n", 
			g_GDT64->table[i].limitL | g_GDT64->table[i].limitH << 16, 
			g_GDT64->table[i].baseL | g_GDT64->table[i].baseM << 16 | g_GDT64->table[i].baseH << 24,
			g_GDT64->table[i].type
		);
	}
	#endif
	
	init_handler();
	
	#if 0
	kprintf("sel, offset, dpl, type\n");
	for (int i = 0; i < 255; i++) {
		kprintf("%xH, %xH, %xH, %xH\n",
			g_IDT64[i].selector, g_IDT64[i].offset_low | g_IDT64[i].offset_high << 16,
			g_IDT64[i].dpl, g_IDT64[i].type
		);
	}
	#endif
	
	// ܂EE
	//asm volatile("int $0x0 \n");
	
	for(;;){}
}
