#include <pekoe.h>
#include <stdio.h>

#include "kernel.h"
#include "kprintf.h"

extern __memstat memstat;

int kputchar(int c){
	switch(c){
	case '\n':
		memstat._col=0;
		memstat._row++;
		break;
	default:
		char* vram=(char*)(intptr)(memstat._text_vram<<4);
		vram[memstat._col*2+memstat._row*160]=c;
		memstat._col++;
	}
	return c;
}

static char kprintf_buffer[4096];

int kprintf(char* form,...){
	int r;
	va_list args;
	va_start(args,form);
	r=vsprintf(kprintf_buffer,form,args);
	for(int i=0;i<r;i++){
		kputchar(kprintf_buffer[i]);
	}
	va_end(args);
	return r;
}
