/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.impl;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.impl.PropertyTypeImpl;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.util.StringUtil;

public final class PropertyTypeUtil {
    private PropertyTypeUtil() {
    }

    public static PropertyType[] createPropertyTypes(ResultSetMetaData rsmd) throws SQLException {
        int count = rsmd.getColumnCount();
        PropertyType[] propertyTypes = new PropertyType[count];
        for (int i = 0; i < count; ++i) {
            String columnName = rsmd.getColumnLabel(i + 1);
            String propertyName = StringUtil.replace((String)columnName, (String)"_", (String)"");
            ValueType valueType = ValueTypes.getValueType(rsmd.getColumnType(i + 1));
            propertyTypes[i] = new PropertyTypeImpl(propertyName, valueType, columnName);
        }
        return propertyTypes;
    }
}

