/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.ta;

import java.lang.reflect.Array;
import java.util.Date;
import jp.sourceforge.orangesignal.ta.candle.Candlestick;
import jp.sourceforge.orangesignal.ta.result.Step;

public final class ArrayDataUtils {
    public static final int INDEX_NOT_FOUND = -1;

    private ArrayDataUtils() {
    }

    public static Number[] subarray(Number[] array, int start) {
        return (Number[])ArrayDataUtils.subarray((Object[])array, start);
    }

    public static Date[] subarray(Date[] array, int start) {
        return (Date[])ArrayDataUtils.subarray((Object[])array, start);
    }

    public static Candlestick[] subarray(Candlestick[] array, int start) {
        return (Candlestick[])ArrayDataUtils.subarray((Object[])array, start);
    }

    public static Object[] subarray(Object[] array, int start) {
        return ArrayDataUtils.subarray(array, start, Integer.MAX_VALUE);
    }

    private static Object[] subarray(Object[] array, int start, int end) {
        if (array == null) {
            return null;
        }
        int _start = Math.max(start, 0);
        int _end = Math.max(end, 0);
        int newSize = Math.min(_end - _start, array.length - _start);
        Class<?> type = array.getClass().getComponentType();
        if (newSize <= 0) {
            return (Object[])Array.newInstance(type, 0);
        }
        Object[] results = (Object[])Array.newInstance(type, newSize);
        System.arraycopy(array, _start, results, 0, newSize);
        return results;
    }

    public static Number[] extend(Number[] array, int space) {
        return (Number[])ArrayDataUtils.extend((Object[])array, space);
    }

    public static Date[] extend(Date[] array, int space) {
        return (Date[])ArrayDataUtils.extend((Object[])array, space);
    }

    public static Candlestick[] extend(Candlestick[] array, int space) {
        return (Candlestick[])ArrayDataUtils.extend((Object[])array, space);
    }

    public static Object[] extend(Object[] array, int space) {
        if (array == null) {
            return null;
        }
        if (space == 0) {
            return array;
        }
        int length = array.length;
        int abs = Math.abs(space);
        int newSize = length + abs;
        Class<?> type = array.getClass().getComponentType();
        Object[] results = (Object[])Array.newInstance(type, newSize);
        if (space > 0) {
            System.arraycopy(array, 0, results, 0, length);
        } else {
            System.arraycopy(array, 0, results, abs, length);
        }
        return results;
    }

    public static boolean isSameLength(Object[] ... arrays) {
        return ArrayDataUtils.getMinLength(arrays) == ArrayDataUtils.getMaxLength(arrays);
    }

    public static int getMinLength(Object[] ... arrays) {
        int result = 0;
        for (Object[] array : arrays) {
            if (array == null) continue;
            int length = array.length;
            if (result != 0 && length >= result) continue;
            result = length;
        }
        return result;
    }

    public static int getMaxLength(Object[] ... arrays) {
        int result = 0;
        for (Object[] array : arrays) {
            if (array == null) continue;
            int length = array.length;
            if (result != 0 && length <= result) continue;
            result = length;
        }
        return result;
    }

    public static int indexOf(Date[] array, Date find) {
        return ArrayDataUtils.indexOf(array, find, 0);
    }

    public static int indexOf(Date[] array, Date find, int start) {
        int _start;
        if (array == null) {
            return -1;
        }
        int length = array.length;
        int n = _start = start >= 0 ? start : 0;
        if (find == null) {
            for (int i = _start; i < length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = _start; i < length; ++i) {
                if (find.compareTo(array[i]) > 0) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(Date[] array, Date find) {
        return ArrayDataUtils.lastIndexOf(array, find, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(Date[] array, Date find, int start) {
        int _start;
        if (array == null || start < 0) {
            return -1;
        }
        int length = array.length;
        int n = _start = start >= length ? length - 1 : start;
        if (find == null) {
            for (int i = _start; i >= 0; --i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = _start; i >= 0; --i) {
                if (find.compareTo(array[i]) < 0) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(Step[] array, Date find) {
        return ArrayDataUtils.indexOf(array, find, 0);
    }

    public static int indexOf(Step[] array, Date find, int start) {
        int _start;
        if (array == null) {
            return -1;
        }
        int length = array.length;
        for (int i = _start = start >= 0 ? start : 0; i < length; ++i) {
            if (array[i] == null || array[i].openDate.compareTo(find) > 0 || array[i].closeDate.compareTo(find) < 0) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(Step[] array, Date find) {
        return ArrayDataUtils.lastIndexOf(array, find, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(Step[] array, Date find, int start) {
        int _start;
        if (array == null) {
            return -1;
        }
        for (int i = _start = start >= (length = array.length) ? length - 1 : start; i >= 0; --i) {
            if (array[i] == null || array[i].openDate.compareTo(find) > 0 || array[i].closeDate.compareTo(find) < 0) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfNotNull(Object[] array) {
        return ArrayDataUtils.indexOfNotNull(array, 0);
    }

    public static int indexOfNotNull(Object[] array, int start) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{array});
        for (int i = Math.max(start, 0); i < length; ++i) {
            if (array[i] == null) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfNotNull(Object[] array) {
        return ArrayDataUtils.lastIndexOfNotNull(array, Integer.MAX_VALUE);
    }

    public static int lastIndexOfNotNull(Object[] array, int start) {
        int _start;
        for (int i = _start = start < (length = ArrayDataUtils.getMinLength(new Object[][]{array})) ? start : length - 1; i >= 0; --i) {
            if (array[i] == null) continue;
            return i;
        }
        return -1;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }
}

