/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.ta.dataset.loader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;

class TextDataUtils {
    private TextDataUtils() {
    }

    public static List<String[]> read(String filename, String encoding, String separator) throws IOException {
        return TextDataUtils.read(new File(filename), encoding, separator);
    }

    public static List<String[]> read(File file, String encoding, String separator) throws IOException {
        byte[] bytes = TextDataUtils.toByteArray(file);
        switch (ContentType.valueOfExtension(FilenameUtils.getExtension((String)file.getCanonicalPath()))) {
            case ZIP: {
                return TextDataUtils.loadZip(bytes, encoding, separator);
            }
            case LHA: {
                return TextDataUtils.loadLha(bytes, encoding, separator);
            }
        }
        return TextDataUtils.loadRaw(bytes, encoding, separator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] toByteArray(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)in);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String[]> loadZip(byte[] data, String encoding, String separator) throws IOException {
        ZipInputStream zip = new ZipInputStream(new ByteArrayInputStream(data));
        try {
            ArrayList<String[]> results = new ArrayList<String[]>();
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                try {
                    results.addAll(TextDataUtils.loadRaw(IOUtils.toByteArray((InputStream)zip), encoding, separator));
                }
                finally {
                    zip.closeEntry();
                    entry = zip.getNextEntry();
                }
            }
            ArrayList<String[]> arrayList = results;
            return arrayList;
        }
        finally {
            IOUtils.closeQuietly((InputStream)zip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String[]> loadLha(byte[] data, String encoding, String separator) throws IOException {
        ArrayList<String[]> results = new ArrayList<String[]>();
        LhaInputStream lha = new LhaInputStream((InputStream)new ByteArrayInputStream(data));
        try {
            LhaHeader entry = lha.getNextEntry();
            while (entry != null) {
                results.addAll(TextDataUtils.loadRaw(IOUtils.toByteArray((InputStream)lha), encoding, separator));
                entry = lha.getNextEntry();
            }
            ArrayList<String[]> arrayList = results;
            return arrayList;
        }
        finally {
            IOUtils.closeQuietly((InputStream)lha);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String[]> loadRaw(byte[] data, String encoding, String separator) throws IOException {
        ArrayList<String[]> results = new ArrayList<String[]>();
        LineIterator iterator = IOUtils.lineIterator((InputStream)new ByteArrayInputStream(data), (String)encoding);
        try {
            while (iterator.hasNext()) {
                String line = iterator.nextLine();
                if (line == null || line.isEmpty() || line.matches("^[" + separator + "]+$")) continue;
                results.add(line.split(separator));
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
        return results;
    }

    private static enum ContentType {
        TEXT,
        LHA,
        ZIP;


        public static ContentType valueOfExtension(String ext) {
            if ("lzh".equalsIgnoreCase(ext)) {
                return LHA;
            }
            if ("zip".equalsIgnoreCase(ext)) {
                return ZIP;
            }
            return TEXT;
        }
    }
}

