/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.ValueType;

public class ObjectListSupportLimitResultSetHandler
implements ResultSetHandler {
    protected ValueType valueType;
    protected int limit;

    public ObjectListSupportLimitResultSetHandler(ValueType valueType, int limit) {
        this.valueType = valueType;
        this.setLimit(limit);
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) throws IllegalArgumentException {
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be greater than 0.");
        }
        this.limit = limit;
    }

    public Object handle(ResultSet rs) throws SQLException {
        ArrayList<Object> ret = new ArrayList<Object>(100);
        for (int i = 0; i < this.limit && rs.next(); ++i) {
            ret.add(this.valueType.getValue(rs, 1));
        }
        return ret;
    }
}

