/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import org.seasar.extension.jdbc.JdbcContext;
import org.seasar.extension.jdbc.ProcedureCall;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AbstractModuleCall;
import org.seasar.framework.util.PreparedStatementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProcedureCall<S extends ProcedureCall<S>>
extends AbstractModuleCall<S>
implements ProcedureCall<S> {
    public AbstractProcedureCall(JdbcManagerImplementor jdbcManager) {
        super(jdbcManager, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this.prepare("execute");
        this.logSql();
        JdbcContext jdbcContext = this.jdbcManager.getJdbcContext();
        try {
            CallableStatement cs = this.getCallableStatement(jdbcContext);
            if (PreparedStatementUtil.execute((PreparedStatement)cs)) {
                this.handleNonParamResultSets(cs);
            }
            this.handleOutParams(cs);
        }
        finally {
            if (!jdbcContext.isTransactional()) {
                jdbcContext.destroy();
            }
        }
    }
}

