/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.where;

import java.util.Arrays;
import java.util.LinkedList;
import org.seasar.extension.jdbc.Where;
import org.seasar.extension.jdbc.where.AbstractWhere;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexWhere
extends AbstractWhere<ComplexWhere>
implements Where {
    protected LinkedList<StringBuilder> criteriaList = CollectionsUtil.newLinkedList();

    public ComplexWhere() {
        this.criteriaList.add(this.criteriaSb);
    }

    public ComplexWhere or() {
        if (this.criteriaSb.length() > 0) {
            this.criteriaSb = new StringBuilder(100);
            this.criteriaList.addLast(this.criteriaSb);
        }
        return this;
    }

    public ComplexWhere and(Where factor) {
        String factorCriteria = factor.getCriteria();
        if (StringUtil.isEmpty((String)factorCriteria)) {
            return this;
        }
        if (this.criteriaSb.length() > 0) {
            this.criteriaSb.append(" and (");
        }
        this.criteriaSb.append(factorCriteria).append(")");
        this.paramList.addAll(Arrays.asList(factor.getParams()));
        this.propertyNameList.addAll(Arrays.asList(factor.getPropertyNames()));
        return this;
    }

    @Override
    public String getCriteria() {
        if (this.criteriaSb.length() == 0) {
            this.criteriaList.removeLast();
        }
        if (this.criteriaList.isEmpty()) {
            return "";
        }
        if (this.criteriaList.size() == 1) {
            return new String(this.criteriaList.getFirst());
        }
        int size = 0;
        for (StringBuilder buf : this.criteriaList) {
            size += buf.length();
        }
        StringBuilder buf = new StringBuilder(size + 50);
        for (StringBuilder criteria : this.criteriaList) {
            buf.append("(").append((CharSequence)criteria).append(") or ");
        }
        buf.setLength(buf.length() - 4);
        return new String(buf);
    }
}

