/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.trading.backtest.launcher;

import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import jp.sourceforge.orangesignal.trading.backtest.Backtester;
import jp.sourceforge.orangesignal.trading.backtest.BacktesterEvent;
import jp.sourceforge.orangesignal.trading.backtest.BacktesterListener;
import jp.sourceforge.orangesignal.trading.backtest.launcher.BacktesterLauncher;
import jp.sourceforge.orangesignal.trading.backtest.launcher.StringManager;
import jp.sourceforge.orangesignal.trading.stats.Summary;
import jp.sourceforge.orangesignal.trading.stats.report.Reporter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.container.annotation.tiger.Component;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

@Component
public class S2BacktesterLauncher
implements BacktesterListener {
    protected static final Log log = LogFactory.getLog(BacktesterLauncher.class);
    private static final StringManager sm = StringManager.getManager(BacktesterLauncher.class);
    protected static final String DEFAULT_CONFIG_LOCATION = "backtester.dicon";
    protected static final String OPT_HELP = "h";
    protected static final String OPT_VERSION = "v";
    protected static final String OPT_FILE = "f";
    protected static final String OPT_TIME = "t";
    protected static final String OPT_INFO = "i";
    protected static Options options = S2BacktesterLauncher.createOptions();
    @Resource
    public Backtester backtester;
    @Resource
    public List<Reporter> reporters;
    protected boolean info;

    protected static final Options createOptions() {
        Options options = new Options();
        options.addOptionGroup(S2BacktesterLauncher.createGeneralOptionGroup());
        options.addOption(new Option(OPT_TIME, "time", false, sm.getString("option.time", new Object[0])));
        options.addOption(new Option(OPT_INFO, "info", false, sm.getString("option.info", new Object[0])));
        return options;
    }

    protected static final OptionGroup createGeneralOptionGroup() {
        OptionGroup group = new OptionGroup();
        group.addOption(new Option(OPT_HELP, "help", false, sm.getString("option.help", new Object[0])));
        group.addOption(new Option(OPT_VERSION, "version", false, sm.getString("option.version", new Object[0])));
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.withDescription((String)sm.getString("option.file", new Object[0]));
        group.addOption(OptionBuilder.create((String)OPT_FILE));
        return group;
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        try {
            CommandLine commandline = new PosixParser().parse(options, args);
            if (commandline.hasOption(OPT_HELP)) {
                new HelpFormatter().printHelp(sm.getString("syntax", BacktesterLauncher.class.getSimpleName()), sm.getString("header", new Object[0]), options, null);
                return;
            }
            if (commandline.hasOption(OPT_VERSION)) {
                System.out.println(sm.getString("version", BacktesterLauncher.class.getSimpleName()));
                System.out.println(sm.getString("copyright", new Object[0]));
                return;
            }
            if (commandline.hasOption(OPT_FILE)) {
                SingletonS2ContainerFactory.setConfigPath((String)commandline.getOptionValue(OPT_FILE));
            }
            SingletonS2ContainerFactory.init();
            S2BacktesterLauncher launcher = (S2BacktesterLauncher)SingletonS2Container.getComponent(S2BacktesterLauncher.class);
            launcher.launch(commandline);
            if (commandline.hasOption(OPT_TIME)) {
                System.out.println(sm.getString("time", (System.currentTimeMillis() - start) / 1000L));
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            if (log.isErrorEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            System.exit(1);
        }
    }

    protected void launch(CommandLine commandline) throws IOException {
        if (this.reporters == null || this.reporters.isEmpty()) {
            return;
        }
        this.info = commandline.hasOption(OPT_INFO);
        this.backtester.addBacktesterListener(this);
        Summary summary = this.backtester.backtest();
        this.backtester.removeBacktesterListener(this);
        if (this.info) {
            System.out.println(sm.getString("info.process", new Object[0]));
        }
        for (Reporter reporter : this.reporters) {
            reporter.report(summary, this.backtester);
        }
        if (this.info) {
            System.out.println(sm.getString("info.complete", new Object[0]));
        }
    }

    @Override
    public void backtestStart(BacktesterEvent event) {
        if (this.info) {
            System.out.println(sm.getString("info.start", event.getSymbol(), event.getSymbolName(), event.getCount(), event.getMax()));
        }
    }

    @Override
    public void backtestProcessed(BacktesterEvent event) {
    }
}

