/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.trading.stats;

import java.io.Serializable;
import java.util.Map;
import jp.sourceforge.orangesignal.trading.stats.Stats;

public abstract class WinLossSummary
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected double initialCapital;
    protected int count;
    protected int trades;
    protected int winTrades;
    protected int lossTrades;
    protected double netProfit;

    protected WinLossSummary() {
    }

    public WinLossSummary(Map<String, Stats> statsMap, double initialCapital) {
        this.statistics(statsMap, initialCapital);
    }

    protected void statistics(Map<String, Stats> statsMap, double initialCapital) {
        this.initialCapital = initialCapital;
        for (Map.Entry<String, Stats> entry : statsMap.entrySet()) {
            Stats stats = entry.getValue();
            if (!this.isStatistics(stats)) continue;
            ++this.count;
            this.trades += stats.getTrades();
            this.winTrades += stats.getWinTrades();
            this.lossTrades += stats.getLossTrades();
            this.netProfit += stats.getNetProfit();
        }
    }

    protected abstract boolean isStatistics(Stats var1);

    public double getInitialCapital() {
        return this.initialCapital;
    }

    public double getPercent(double amount) {
        if (amount == 0.0 || this.initialCapital == 0.0) {
            return 0.0;
        }
        return amount / this.initialCapital;
    }

    public int getCount() {
        return this.count;
    }

    public double getAverage(double value) {
        if (value == 0.0 || this.count == 0) {
            return 0.0;
        }
        return value / (double)this.count;
    }

    public int getTrades() {
        return this.trades;
    }

    public double getTradeAverage(double value) {
        if (value == 0.0 || this.trades == 0) {
            return 0.0;
        }
        return value / (double)this.trades;
    }

    public int getWinTrades() {
        return this.winTrades;
    }

    public double getPercentWinTrades() {
        if (this.winTrades == 0 || this.getTrades() == 0) {
            return 0.0;
        }
        return (double)this.winTrades / (double)this.getTrades();
    }

    public int getLossTrades() {
        return this.lossTrades;
    }

    public double getPercentLossTrades() {
        if (this.lossTrades == 0 || this.getTrades() == 0) {
            return 0.0;
        }
        return (double)this.lossTrades / (double)this.getTrades();
    }

    public double getNetProfit() {
        return this.netProfit;
    }

    public double getPercentNetProfit() {
        return this.getPercent(this.getNetProfit());
    }

    public double getAverageNetProfit() {
        return this.getAverage(this.getNetProfit());
    }

    public double getPercentAverageNetProfit() {
        return this.getPercent(this.getAverageNetProfit());
    }
}

