/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.candle;

import jp.sf.orangesignal.ta.candle.Candlestick;
import jp.sf.orangesignal.ta.candle.CandlestickColor;
import jp.sf.orangesignal.ta.candle.RealBodyType;
import jp.sf.orangesignal.ta.candle.ShadowType;
import jp.sf.orangesignal.ta.candle.TrendType;

public class CandlestickPatterns {
    protected CandlestickPatterns() {
    }

    public static boolean[] bullishLongWhiteDay(Candlestick[] c) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 0; i < len; ++i) {
            if (c[i] == null) continue;
            results[i] = c[i].isLongWhite();
        }
        return results;
    }

    public static boolean[] bearishLongBlackDay(Candlestick[] c) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 0; i < len; ++i) {
            if (c[i] == null) continue;
            results[i] = c[i].isLongBlack();
        }
        return results;
    }

    public static boolean[] bullishShortWhiteDay(Candlestick[] c) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 0; i < len; ++i) {
            if (c[i] == null) continue;
            results[i] = c[i].isShortWhite();
        }
        return results;
    }

    public static boolean[] bearishShortBlackDay(Candlestick[] c) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 0; i < len; ++i) {
            if (c[i] == null) continue;
            results[i] = c[i].isShortBlack();
        }
        return results;
    }

    public static boolean[] bullishBeltHold(Candlestick[] c) {
        return CandlestickPatterns.bullishBeltHold(c, true);
    }

    public static boolean[] bullishBeltHold(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _0 = i - 1;
            int _1 = i;
            if (c[_0] == null || c[_1] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_0].gapDownBodyByBody(c[_1]) && c[_1].getColor() == CandlestickColor.WHITE && c[_1].isOpeningMarubozu();
        }
        return results;
    }

    public static boolean[] bearishBeltHold(Candlestick[] c) {
        return CandlestickPatterns.bearishBeltHold(c, true);
    }

    public static boolean[] bearishBeltHold(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _0 = i - 1;
            int _1 = i;
            if (c[_0] == null || c[_1] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_0].gapUpBodyByBody(c[_1]) && c[_1].getColor() == CandlestickColor.BLACK && c[_1].isClosingMarubozu();
        }
        return results;
    }

    public static boolean[] bullishHammer(Candlestick[] c) {
        return CandlestickPatterns.bullishHammer(c, true, false);
    }

    public static boolean[] bullishHammer(Candlestick[] c, boolean trend, boolean color) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _0 = i - 1;
            int _1 = i;
            if (c[_0] == null || c[_1] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && !color | c[_1].getColor() == CandlestickColor.WHITE && c[_1].isHangingMan();
        }
        return results;
    }

    public static boolean[] bearishHangingMan(Candlestick[] c) {
        return CandlestickPatterns.bearishHangingMan(c, true, false);
    }

    public static boolean[] bearishHangingMan(Candlestick[] c, boolean trend, boolean color) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _0 = i - 1;
            int _1 = i;
            if (c[_0] == null || c[_1] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && !color | c[_1].getColor() == CandlestickColor.BLACK && c[_1].isHangingMan();
        }
        return results;
    }

    public static boolean[] bullishDragonflyDoji(Candlestick[] c) {
        return CandlestickPatterns.bullishDragonflyDoji(c, true);
    }

    public static boolean[] bullishDragonflyDoji(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _0 = i - 1;
            int _1 = i;
            if (c[_0] == null || c[_1] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_0].gapDownBodyByBody(c[_1]) && c[_1].isDragonflyDoji();
        }
        return results;
    }

    public static boolean[] bearishDragonflyDoji(Candlestick[] c) {
        return CandlestickPatterns.bearishDragonflyDoji(c, true);
    }

    public static boolean[] bearishDragonflyDoji(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _0 = i - 1;
            int _1 = i;
            if (c[_0] == null || c[_1] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_0].gapDownBodyByBody(c[_1]) && c[_1].isDragonflyDoji();
        }
        return results;
    }

    public static boolean[] bullishLongLeggedDoji(Candlestick[] c) {
        return CandlestickPatterns.bullishLongLeggedDoji(c, true);
    }

    public static boolean[] bullishLongLeggedDoji(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _0 = i - 1;
            int _1 = i;
            if (c[_0] == null || c[_1] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_0].gapDownBodyByBody(c[_1]) && c[_1].isLongLeggedDoji();
        }
        return results;
    }

    public static boolean[] bearishLongLeggedDoji(Candlestick[] c) {
        return CandlestickPatterns.bearishLongLeggedDoji(c, true);
    }

    public static boolean[] bearishLongLeggedDoji(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _0 = i - 1;
            int _1 = i;
            if (c[_0] == null || c[_1] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_0].gapUpBodyByBody(c[_1]) && c[_1].isLongLeggedDoji();
        }
        return results;
    }

    public static boolean[] bullishInvertedHammer(Candlestick[] c) {
        return CandlestickPatterns.bullishInvertedHammer(c, true, false);
    }

    public static boolean[] bullishInvertedHammer(Candlestick[] c, boolean trend, boolean color) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _0 = i - 1;
            int _1 = i;
            if (c[_0] == null || c[_1] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_0].getColor() == CandlestickColor.BLACK && c[_0].getBodyType() == RealBodyType.LONG && (c[_1].isShootingStar() || c[_1].isGravestoneDoji()) && c[_0].gapDownBodyByBody(c[_1]) && !color | c[_1].getColor() == CandlestickColor.WHITE;
        }
        return results;
    }

    public static boolean[] bearishShootingStar(Candlestick[] c) {
        return CandlestickPatterns.bearishShootingStar(c, true, false);
    }

    public static boolean[] bearishShootingStar(Candlestick[] c, boolean trend, boolean color) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _0 = i - 1;
            int _1 = i;
            if (c[_0] == null || c[_1] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_0].getColor() == CandlestickColor.WHITE && c[_0].getBodyType() == RealBodyType.LONG && (c[_1].isShootingStar() || c[_1].isGravestoneDoji()) && c[_0].gapUpBodyByBody(c[_1]) && !color | c[_1].getColor() == CandlestickColor.BLACK;
        }
        return results;
    }

    public static boolean[] bullishHarami(Candlestick[] c) {
        return CandlestickPatterns.bullishHarami(c, true);
    }

    public static boolean[] bullishHarami(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.WHITE && c[_2].getBodyType() == RealBodyType.SMALL && c[_1].containsBodyByBody(c[_2]);
        }
        return results;
    }

    public static boolean[] bearishHarami(Candlestick[] c) {
        return CandlestickPatterns.bearishHarami(c, true);
    }

    public static boolean[] bearishHarami(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.BLACK && c[_2].getBodyType() == RealBodyType.SMALL && c[_1].containsBodyByBody(c[_2]);
        }
        return results;
    }

    public static boolean[] bullishHaramiCross(Candlestick[] c) {
        return CandlestickPatterns.bullishHaramiCross(c, true);
    }

    public static boolean[] bullishHaramiCross(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.WHITE && c[_2].getBodyType() == RealBodyType.DOJI && c[_1].containsBodyByBody(c[_2]);
        }
        return results;
    }

    public static boolean[] bearishHaramiCross(Candlestick[] c) {
        return CandlestickPatterns.bearishHaramiCross(c, true);
    }

    public static boolean[] bearishHaramiCross(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.BLACK && c[_2].getBodyType() == RealBodyType.DOJI && c[_1].containsBodyByBody(c[_2]);
        }
        return results;
    }

    public static boolean[] bullishEngulfing(Candlestick[] c) {
        return CandlestickPatterns.bullishEngulfing(c, true);
    }

    public static boolean[] bullishEngulfing(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && (c[_1].getBodyType() == RealBodyType.SMALL || c[_1].getBodyType() == RealBodyType.DOJI) && c[_2].getColor() == CandlestickColor.WHITE && c[_2].getBodyType() == RealBodyType.LONG && c[_2].containsBodyByBody(c[_1]);
        }
        return results;
    }

    public static boolean[] bearishEngulfing(Candlestick[] c) {
        return CandlestickPatterns.bearishEngulfing(c, true);
    }

    public static boolean[] bearishEngulfing(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && (c[_1].getBodyType() == RealBodyType.SMALL || c[_1].getBodyType() == RealBodyType.DOJI) && c[_2].getColor() == CandlestickColor.BLACK && c[_2].getBodyType() == RealBodyType.LONG && c[_2].containsBodyByBody(c[_1]);
        }
        return results;
    }

    public static boolean[] bullishGravestoneDoji(Candlestick[] c) {
        return CandlestickPatterns.bullishGravestoneDoji(c, true);
    }

    public static boolean[] bullishGravestoneDoji(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _0 = i - 1;
            int _1 = i;
            if (c[_0] == null || c[_1] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_0].getColor() == CandlestickColor.BLACK && c[_0].gapDownBodyByBody(c[_1]) && c[_1].isGravestoneDoji();
        }
        return results;
    }

    public static boolean[] bearishGravestoneDoji(Candlestick[] c) {
        return CandlestickPatterns.bearishGravestoneDoji(c, true);
    }

    public static boolean[] bearishGravestoneDoji(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _0 = i - 1;
            int _1 = i;
            if (c[_0] == null || c[_1] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_0].getColor() == CandlestickColor.WHITE && c[_0].gapUpBodyByBody(c[_1]) && c[_1].isGravestoneDoji();
        }
        return results;
    }

    public static boolean[] bullishCounterAttack(Candlestick[] c) {
        return CandlestickPatterns.bullishMeetingLines(c, true);
    }

    public static boolean[] bullishCounterAttack(Candlestick[] c, boolean trend) {
        return CandlestickPatterns.bullishMeetingLines(c, trend);
    }

    public static boolean[] bearishCounterAttack(Candlestick[] c) {
        return CandlestickPatterns.bearishMeetingLines(c, true);
    }

    public static boolean[] bearishCounterAttack(Candlestick[] c, boolean trend) {
        return CandlestickPatterns.bearishMeetingLines(c, trend);
    }

    public static boolean[] bullishMeetingLines(Candlestick[] c) {
        return CandlestickPatterns.bullishMeetingLines(c, true);
    }

    public static boolean[] bullishMeetingLines(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.WHITE && c[_2].getBodyType() == RealBodyType.LONG && c[_1].body() > c[_2].body() && c[_1].gapDownBodyByBody(c[_2]) && c[_2].isSameClose(c[_1].getClose());
        }
        return results;
    }

    public static boolean[] bearishMeetingLines(Candlestick[] c) {
        return CandlestickPatterns.bearishMeetingLines(c, true);
    }

    public static boolean[] bearishMeetingLines(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.BLACK && c[_2].getBodyType() == RealBodyType.LONG && c[_1].body() > c[_2].body() && c[_1].gapUpBodyByBody(c[_2]) && c[_2].isSameClose(c[_1].getClose());
        }
        return results;
    }

    public static boolean[] bullishDojiStar(Candlestick[] c) {
        return CandlestickPatterns.bullishDojiStar(c, true);
    }

    public static boolean[] bullishDojiStar(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_1].gapDownBodyByBody(c[_2]) && c[_2].getBodyType() == RealBodyType.DOJI && c[_2].getUpperShadowType() != ShadowType.LONG && c[_2].getLowerShadowType() != ShadowType.LONG;
        }
        return results;
    }

    public static boolean[] bearishDojiStar(Candlestick[] c) {
        return CandlestickPatterns.bearishDojiStar(c, true);
    }

    public static boolean[] bearishDojiStar(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_1].gapUpBodyByBody(c[_2]) && c[_2].getBodyType() == RealBodyType.DOJI && c[_2].getUpperShadowType() != ShadowType.LONG && c[_2].getLowerShadowType() != ShadowType.LONG;
        }
        return results;
    }

    public static boolean[] bullishHomingPigeon(Candlestick[] c) {
        return CandlestickPatterns.bullishHomingPigeon(c, true);
    }

    public static boolean[] bullishHomingPigeon(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.BLACK && c[_2].getBodyType() == RealBodyType.SMALL && c[_1].containsBodyByBody(c[_2]);
        }
        return results;
    }

    public static boolean[] bearishDescendingHawk(Candlestick[] c) {
        return CandlestickPatterns.bearishDescendingHawk(c, true);
    }

    public static boolean[] bearishDescendingHawk(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.WHITE && c[_2].getBodyType() == RealBodyType.SMALL && c[_1].containsBodyByBody(c[_2]);
        }
        return results;
    }

    public static boolean[] bullishMatchingLow(Candlestick[] c) {
        return CandlestickPatterns.bullishMatchingLow(c, true);
    }

    public static boolean[] bullishMatchingLow(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        boolean[] bullishHomingPigeon = CandlestickPatterns.bullishHomingPigeon(c, trend);
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = bullishHomingPigeon[_2] && c[_2].isSameClose(c[_1].getClose());
        }
        return results;
    }

    public static boolean[] bearishMatchingHigh(Candlestick[] c) {
        return CandlestickPatterns.bearishMatchingHigh(c, true);
    }

    public static boolean[] bearishMatchingHigh(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        boolean[] bearishDescendingHawk = CandlestickPatterns.bearishDescendingHawk(c, trend);
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = bearishDescendingHawk[_2] && c[_2].isSameClose(c[_1].getClose());
        }
        return results;
    }

    public static boolean[] bullishTweezerBottom(Candlestick[] c) {
        return CandlestickPatterns.bullishTweezerBottom(c, true);
    }

    public static boolean[] bullishTweezerBottom(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.WHITE && (c[_2].getBodyType() == RealBodyType.SMALL || c[_2].getBodyType() == RealBodyType.DOJI) && c[_1].contains(c[_2]) && c[_2].isSameLow(c[_1].getLow());
        }
        return results;
    }

    public static boolean[] bearishTweezerTop(Candlestick[] c) {
        return CandlestickPatterns.bearishTweezerTop(c, true);
    }

    public static boolean[] bearishTweezerTop(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.BLACK && (c[_2].getBodyType() == RealBodyType.SMALL || c[_2].getBodyType() == RealBodyType.DOJI) && c[_1].contains(c[_2]) && c[_2].isSameHigh(c[_1].getHigh());
        }
        return results;
    }

    public static boolean[] bullishKicking(Candlestick[] c) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = c[_1].getColor() == CandlestickColor.BLACK && c[_1].isMarubozu() && c[_2].getColor() == CandlestickColor.WHITE && c[_2].isMarubozu() && c[_1].gapUpBodyByBody(c[_2]);
        }
        return results;
    }

    public static boolean[] bearishKicking(Candlestick[] c) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = c[_1].getColor() == CandlestickColor.WHITE && c[_1].isMarubozu() && c[_2].getColor() == CandlestickColor.BLACK && c[_2].isMarubozu() && c[_1].gapDownBodyByBody(c[_2]);
        }
        return results;
    }

    public static boolean[] bullishPiercingLine(Candlestick[] c) {
        return CandlestickPatterns.bullishPiercingLine(c, true);
    }

    public static boolean[] bullishPiercingLine(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.WHITE && c[_2].getBodyType() == RealBodyType.LONG && c[_1].getLow() > c[_2].getOpen() && c[_1].containsBody(c[_2].getClose()) && c[_1].midpoint() < c[_2].getClose() && !c[_2].isSameClose(c[_1].getOpen());
        }
        return results;
    }

    public static boolean[] bearishDarkCloudCover(Candlestick[] c) {
        return CandlestickPatterns.bearishDarkCloudCover(c, true);
    }

    public static boolean[] bearishDarkCloudCover(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.BLACK && c[_2].getBodyType() == RealBodyType.LONG && c[_1].getHigh() < c[_2].getOpen() && c[_1].containsBody(c[_2].getClose()) && c[_1].midpoint() > c[_2].getClose() && !c[_2].isSameClose(c[_1].getOpen());
        }
        return results;
    }

    public static boolean[] bullishSeparatingLines(Candlestick[] c) {
        return CandlestickPatterns.bullishSeparatingLines(c, true);
    }

    public static boolean[] bullishSeparatingLines(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.WHITE && c[_2].getBodyType() != RealBodyType.DOJI && c[_2].getLowerShadowType() == ShadowType.NO && c[_2].isSameOpen(c[_1].getOpen());
        }
        return results;
    }

    public static boolean[] bearishSeparatingLines(Candlestick[] c) {
        return CandlestickPatterns.bearishSeparatingLines(c, true);
    }

    public static boolean[] bearishSeparatingLines(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.BLACK && c[_2].getBodyType() != RealBodyType.DOJI && c[_2].getUpperShadowType() == ShadowType.NO && c[_2].isSameOpen(c[_1].getOpen());
        }
        return results;
    }

    public static boolean[] bearishThrusting(Candlestick[] c) {
        return CandlestickPatterns.bearishThrusting(c, true);
    }

    public static boolean[] bearishThrusting(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.WHITE && c[_1].getLow() > c[_2].getOpen() && c[_1].getClose() < c[_2].getClose() && c[_1].midpoint() > c[_2].getClose() && !c[_2].isNearClose(c[_1].getClose());
        }
        return results;
    }

    public static boolean[] bearishOnNeck(Candlestick[] c) {
        return CandlestickPatterns.bearishOnNeck(c, true);
    }

    public static boolean[] bearishOnNeck(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.WHITE && c[_1].getLow() > c[_2].getOpen() && c[_1].getClose() > c[_2].getClose();
        }
        return results;
    }

    public static boolean[] bearishInNeck(Candlestick[] c) {
        return CandlestickPatterns.bearishInNeck(c, true);
    }

    public static boolean[] bearishInNeck(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 1; i < len; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.WHITE && c[_1].getLow() > c[_2].getOpen() && c[_1].getClose() < c[_2].getClose() && c[_1].midpoint() > c[_2].getClose() && c[_2].isNearClose(c[_1].getClose());
        }
        return results;
    }

    public static boolean[] bullishTriStar(Candlestick[] c) {
        return CandlestickPatterns.bullishTriStar(c, true);
    }

    public static boolean[] bullishTriStar(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getBodyType() == RealBodyType.DOJI && c[_2].getBodyType() == RealBodyType.DOJI && c[_3].getBodyType() == RealBodyType.DOJI && c[_1].gapDownBodyByBody(c[_2]) && c[_2].gapUpBodyByBody(c[_3]);
        }
        return results;
    }

    public static boolean[] bearishTriStar(Candlestick[] c) {
        return CandlestickPatterns.bearishTriStar(c, true);
    }

    public static boolean[] bearishTriStar(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getBodyType() == RealBodyType.DOJI && c[_2].getBodyType() == RealBodyType.DOJI && c[_3].getBodyType() == RealBodyType.DOJI && c[_1].gapUpBodyByBody(c[_2]) && c[_2].gapDownBodyByBody(c[_3]);
        }
        return results;
    }

    public static boolean[] bearishTwoCrows(Candlestick[] c) {
        return CandlestickPatterns.bearishTwoCrows(c, true);
    }

    public static boolean[] bearishTwoCrows(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_1].gapUpBodyByBody(c[_2]) && c[_2].getColor() == CandlestickColor.BLACK && c[_3].getColor() == CandlestickColor.BLACK && c[_2].containsBody(c[_3].getOpen()) && c[_1].containsBody(c[_3].getClose());
        }
        return results;
    }

    public static boolean[] bullishThreeStarsInTheSouth(Candlestick[] c) {
        return CandlestickPatterns.bullishThreeStarsInTheSouth(c, true);
    }

    public static boolean[] bullishThreeStarsInTheSouth(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].isOpeningMarubozu() && c[_2].getColor() == CandlestickColor.BLACK && c[_2].isSmallOpeningMarubozu() && c[_3].getColor() == CandlestickColor.BLACK && c[_3].isSmallMarubozu() && c[_1].body() > c[_2].body() && c[_2].body() > c[_3].body() && c[_1].lowerShadow() > c[_2].lowerShadow() && c[_1].contains(c[_2]) && c[_2].contains(c[_3]) && c[_1].getClose() > c[_2].getClose() && c[_2].getClose() > c[_3].getClose();
        }
        return results;
    }

    public static boolean[] bullishUniqueThreeRiverBottom(Candlestick[] c) {
        return CandlestickPatterns.bullishUniqueThreeRiverBottom(c, true);
    }

    public static boolean[] bullishUniqueThreeRiverBottom(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_2].getColor() == CandlestickColor.BLACK && c[_3].getColor() == CandlestickColor.WHITE && c[_3].getBodyType() == RealBodyType.SMALL && c[_1].containsBodyByBody(c[_2]) && c[_1].getLow() > c[_2].getLow() && c[_2].gapDownBodyByBody(c[_3]);
        }
        return results;
    }

    public static boolean[] bullishStickSandwich(Candlestick[] c) {
        return CandlestickPatterns.bullishStickSandwich(c, true);
    }

    public static boolean[] bullishStickSandwich(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_2].getColor() == CandlestickColor.WHITE && c[_3].getColor() == CandlestickColor.BLACK && c[_2].containsBody(c[_1].getOpen()) && c[_3].containsBodyByBody(c[_2]) && c[_3].isSameClose(c[_1].getClose());
        }
        return results;
    }

    public static boolean[] bearishAdvanceBlock(Candlestick[] c) {
        return CandlestickPatterns.bearishAdvanceBlock(c, true);
    }

    public static boolean[] bearishAdvanceBlock(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_2].getColor() == CandlestickColor.WHITE && c[_3].getColor() == CandlestickColor.WHITE && c[_1].getClose() < c[_2].getClose() && c[_2].getClose() < c[_3].getClose() && c[_1].containsBody(c[_2].getOpen()) && c[_2].containsBody(c[_3].getOpen()) && c[_1].body() > c[_2].body() && c[_2].body() > c[_3].body();
        }
        return results;
    }

    public static boolean[] bearishStalledPattern(Candlestick[] c) {
        return CandlestickPatterns.bearishDeliberation(c, true);
    }

    public static boolean[] bearishStalledPattern(Candlestick[] c, boolean trend) {
        return CandlestickPatterns.bearishDeliberation(c, trend);
    }

    public static boolean[] bearishDeliberation(Candlestick[] c) {
        return CandlestickPatterns.bearishDeliberation(c, true);
    }

    public static boolean[] bearishDeliberation(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.WHITE && c[_2].getBodyType() == RealBodyType.LONG && c[_1].containsBody(c[_2].getOpen()) && c[_1].getClose() < c[_2].getClose() && c[_2].gapUpBodyByBody(c[_3]) && (c[_3].getBodyType() == RealBodyType.SMALL || c[_3].getBodyType() == RealBodyType.DOJI);
        }
        return results;
    }

    public static boolean[] bullishAbandonedBaby(Candlestick[] c) {
        return CandlestickPatterns.bullishAbandonedBaby(c, true);
    }

    public static boolean[] bullishAbandonedBaby(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_1].gapDown(c[_2]) && c[_2].getBodyType() == RealBodyType.DOJI && c[_2].gapUp(c[_3]) && c[_3].getColor() == CandlestickColor.WHITE && c[_3].getBodyType() == RealBodyType.SMALL && c[_1].midpoint() < c[_3].getClose();
        }
        return results;
    }

    public static boolean[] bearishAbandonedBaby(Candlestick[] c) {
        return CandlestickPatterns.bearishAbandonedBaby(c, true);
    }

    public static boolean[] bearishAbandonedBaby(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_1].gapUp(c[_2]) && c[_2].getBodyType() == RealBodyType.DOJI && c[_2].gapDown(c[_3]) && c[_3].getColor() == CandlestickColor.BLACK && c[_3].getBodyType() == RealBodyType.SMALL && c[_1].midpoint() > c[_3].getClose();
        }
        return results;
    }

    public static boolean[] bullishMorningDojiStar(Candlestick[] c) {
        return CandlestickPatterns.bullishMorningDojiStar(c, true);
    }

    public static boolean[] bullishMorningDojiStar(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_1].gapDownBodyByBody(c[_2]) && c[_2].getBodyType() == RealBodyType.DOJI && c[_2].gapUpBodyByBody(c[_3]) && c[_3].getColor() == CandlestickColor.WHITE && c[_3].getBodyType() != RealBodyType.DOJI && c[_1].midpoint() > c[_3].getClose();
        }
        return results;
    }

    public static boolean[] bearishEveningDojiStar(Candlestick[] c) {
        return CandlestickPatterns.bearishEveningDojiStar(c, true);
    }

    public static boolean[] bearishEveningDojiStar(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_1].gapUpBodyByBody(c[_2]) && c[_2].getBodyType() == RealBodyType.DOJI && c[_2].gapDownBodyByBody(c[_3]) && c[_3].getColor() == CandlestickColor.BLACK && c[_3].getBodyType() != RealBodyType.DOJI && c[_1].midpoint() < c[_3].getClose();
        }
        return results;
    }

    public static boolean[] bullishMorningStar(Candlestick[] c) {
        return CandlestickPatterns.bullishMorningStar(c, true);
    }

    public static boolean[] bullishMorningStar(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_1].gapDownBodyByBody(c[_2]) && c[_2].getBodyType() == RealBodyType.SMALL && c[_2].gapUpBodyByBody(c[_3]) && c[_3].getColor() == CandlestickColor.WHITE && c[_3].getBodyType() != RealBodyType.DOJI && c[_1].midpoint() > c[_3].getClose();
        }
        return results;
    }

    public static boolean[] bearishEveningStar(Candlestick[] c) {
        return CandlestickPatterns.bearishEveningStar(c, true);
    }

    public static boolean[] bearishEveningStar(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_1].gapUpBodyByBody(c[_2]) && c[_2].getBodyType() == RealBodyType.SMALL && c[_2].gapDownBodyByBody(c[_3]) && c[_3].getColor() == CandlestickColor.BLACK && c[_3].getBodyType() != RealBodyType.DOJI && c[_1].midpoint() < c[_3].getClose();
        }
        return results;
    }

    public static boolean[] bullishThreeOutsideUp(Candlestick[] c) {
        return CandlestickPatterns.bullishThreeOutsideUp(c, true);
    }

    public static boolean[] bullishThreeOutsideUp(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        boolean[] bullishEngulfing = CandlestickPatterns.bullishEngulfing(c, trend);
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = bullishEngulfing[_2] && c[_3].getColor() == CandlestickColor.WHITE && c[_2].midpoint() < c[_3].getOpen() && c[_2].getClose() < c[_3].getClose();
        }
        return results;
    }

    public static boolean[] bearishThreeOutsideDown(Candlestick[] c) {
        return CandlestickPatterns.bearishThreeOutsideDown(c, true);
    }

    public static boolean[] bearishThreeOutsideDown(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        boolean[] bearishEngulfing = CandlestickPatterns.bearishEngulfing(c, trend);
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = bearishEngulfing[_2] && c[_3].getColor() == CandlestickColor.BLACK && c[_2].midpoint() > c[_3].getOpen() && c[_2].getClose() > c[_3].getClose();
        }
        return results;
    }

    public static boolean[] bullishThreeInsideUp(Candlestick[] c) {
        return CandlestickPatterns.bullishThreeInsideUp(c, true);
    }

    public static boolean[] bullishThreeInsideUp(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        boolean[] bullishHarami = CandlestickPatterns.bullishHarami(c, trend);
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = bullishHarami[_2] && c[_3].getColor() == CandlestickColor.WHITE && c[_2].midpoint() < c[_3].getOpen() && c[_2].getClose() < c[_3].getClose();
        }
        return results;
    }

    public static boolean[] bearishThreeInsideDown(Candlestick[] c) {
        return CandlestickPatterns.bearishThreeInsideDown(c, true);
    }

    public static boolean[] bearishThreeInsideDown(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        boolean[] bearishHarami = CandlestickPatterns.bearishHarami(c, trend);
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = bearishHarami[_2] && c[_3].getColor() == CandlestickColor.BLACK && c[_2].midpoint() > c[_3].getOpen() && c[_2].getClose() > c[_3].getClose();
        }
        return results;
    }

    public static boolean[] bearishUpsideGapTwoCrows(Candlestick[] c) {
        return CandlestickPatterns.bearishUpsideGapTwoCrows(c, true);
    }

    public static boolean[] bearishUpsideGapTwoCrows(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_1].gapUpBodyByBody(c[_2]) && c[_2].getColor() == CandlestickColor.BLACK && c[_3].getColor() == CandlestickColor.BLACK && c[_3].containsBodyByBody(c[_2]) && c[_3].contains(c[_2]) && c[_1].getClose() < c[_3].getClose();
        }
        return results;
    }

    public static boolean[] bullishThreeWhiteSoldiers(Candlestick[] c) {
        return CandlestickPatterns.bullishThreeWhiteSoldiers(c, true);
    }

    public static boolean[] bullishThreeWhiteSoldiers(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 3; i < len; ++i) {
            int _0 = i - 3;
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_0] == null || c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.WHITE && c[_2].getBodyType() == RealBodyType.LONG && c[_3].getColor() == CandlestickColor.WHITE && c[_3].getBodyType() == RealBodyType.LONG && c[_1].getClose() < c[_2].getClose() && c[_2].getClose() < c[_3].getClose() && c[_1].containsBody(c[_2].getOpen()) && c[_2].containsBody(c[_3].getOpen());
        }
        return results;
    }

    public static boolean[] bearishThreeBlackCrows(Candlestick[] c) {
        return CandlestickPatterns.bearishThreeBlackCrows(c, true);
    }

    public static boolean[] bearishThreeBlackCrows(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 3; i < len; ++i) {
            int _0 = i - 3;
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_0] == null || c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.BLACK && c[_2].getBodyType() == RealBodyType.LONG && c[_3].getColor() == CandlestickColor.BLACK && c[_3].getBodyType() == RealBodyType.LONG && c[_1].getClose() > c[_2].getClose() && c[_2].getClose() > c[_3].getClose() && c[_1].containsBody(c[_2].getOpen()) && c[_2].containsBody(c[_3].getOpen());
        }
        return results;
    }

    public static boolean[] bearishIdenticalThreeCrows(Candlestick[] c) {
        return CandlestickPatterns.bearishIdenticalThreeCrows(c, true);
    }

    public static boolean[] bearishIdenticalThreeCrows(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.BLACK && c[_2].getBodyType() == RealBodyType.LONG && c[_3].getColor() == CandlestickColor.BLACK && c[_3].getBodyType() == RealBodyType.LONG && c[_1].getClose() > c[_2].getClose() && c[_2].getClose() > c[_3].getClose() && c[_2].isSameOpen(c[_1].getClose()) && c[_3].isSameOpen(c[_2].getClose());
        }
        return results;
    }

    public static boolean[] bullishUpsideTasukiGap(Candlestick[] c) {
        return CandlestickPatterns.bullishUpsideTasukiGap(c, true);
    }

    public static boolean[] bullishUpsideTasukiGap(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.WHITE && c[_2].getBodyType() == RealBodyType.LONG && c[_3].getColor() == CandlestickColor.BLACK && c[_1].gapUpBodyByBody(c[_2]) && c[_2].containsBody(c[_3].getOpen()) && c[_1].getClose() < c[_3].getClose() && c[_2].getOpen() > c[_3].getClose() && c[_3].isFarClose(c[_1].getClose());
        }
        return results;
    }

    public static boolean[] bearishDownsideTasukiGap(Candlestick[] c) {
        return CandlestickPatterns.bearishDownsideTasukiGap(c, true);
    }

    public static boolean[] bearishDownsideTasukiGap(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.BLACK && c[_2].getBodyType() == RealBodyType.LONG && c[_3].getColor() == CandlestickColor.WHITE && c[_1].gapDownBodyByBody(c[_2]) && c[_2].containsBody(c[_3].getOpen()) && c[_1].getClose() > c[_3].getClose() && c[_2].getOpen() < c[_3].getClose() && c[_3].isFarClose(c[_1].getClose());
        }
        return results;
    }

    public static boolean[] bullishUpsideGapThreeMethods(Candlestick[] c) {
        return CandlestickPatterns.bullishUpsideGapThreeMethods(c, true);
    }

    public static boolean[] bullishUpsideGapThreeMethods(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.WHITE && c[_2].getBodyType() == RealBodyType.LONG && c[_3].getColor() == CandlestickColor.BLACK && c[_1].gapUpBodyByBody(c[_2]) && c[_2].containsBody(c[_3].getOpen()) && c[_1].getClose() > c[_3].getClose();
        }
        return results;
    }

    public static boolean[] bearishDownsideGapThreeMethods(Candlestick[] c) {
        return CandlestickPatterns.bearishDownsideGapThreeMethods(c, true);
    }

    public static boolean[] bearishDownsideGapThreeMethods(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_2].getColor() == CandlestickColor.BLACK && c[_2].getBodyType() == RealBodyType.LONG && c[_3].getColor() == CandlestickColor.WHITE && c[_1].gapDownBodyByBody(c[_2]) && c[_2].containsBody(c[_3].getOpen()) && c[_1].getClose() < c[_3].getClose();
        }
        return results;
    }

    public static boolean[] bearishSideBySideWhiteLines(Candlestick[] c) {
        return CandlestickPatterns.bearishSideBySideWhiteLines(c, true);
    }

    public static boolean[] bearishSideBySideWhiteLines(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_2].getColor() == CandlestickColor.WHITE && c[_3].getColor() == CandlestickColor.WHITE && c[_1].gapDownBodyByBody(c[_2]) && c[_3].isSameOpen(c[_2].getOpen()) && c[_3].isSameClose(c[_2].getClose()) && c[_2].getLow() > c[_3].getLow();
        }
        return results;
    }

    public static boolean[] bullishSideBySideWhiteLines(Candlestick[] c) {
        return CandlestickPatterns.bullishSideBySideWhiteLines(c, true);
    }

    public static boolean[] bullishSideBySideWhiteLines(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 2; i < len; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_2].getColor() == CandlestickColor.WHITE && c[_3].getColor() == CandlestickColor.WHITE && c[_1].gapUpBodyByBody(c[_2]) && c[_3].isSameOpen(c[_2].getOpen()) && c[_3].isSameClose(c[_2].getClose()) && c[_2].getHigh() < c[_3].getHigh();
        }
        return results;
    }

    public static boolean[] bullishConcealingBabySwallow(Candlestick[] c) {
        return CandlestickPatterns.bullishConcealingBabySwallow(c, true);
    }

    public static boolean[] bullishConcealingBabySwallow(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 3; i < len; ++i) {
            int _1 = i - 3;
            int _2 = i - 2;
            int _3 = i - 1;
            int _4 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null || c[_4] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].isMarubozu() && c[_2].getColor() == CandlestickColor.BLACK && c[_2].isMarubozu() && c[_3].getColor() == CandlestickColor.BLACK && c[_3].getUpperShadowType() == ShadowType.LONG && c[_4].getColor() == CandlestickColor.BLACK && c[_4].isMarubozu() && c[_2].containsBody(c[_3].getHigh()) && c[_2].gapDownBodyByBody(c[_3]) && c[_4].containsBody(c[_3]);
        }
        return results;
    }

    public static boolean[] bullishThreeLineStrike(Candlestick[] c) {
        return CandlestickPatterns.bullishThreeLineStrike(c, true);
    }

    public static boolean[] bullishThreeLineStrike(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        boolean[] threeWhiteSoldiers = CandlestickPatterns.bullishThreeWhiteSoldiers(c, false);
        for (int i = 3; i < len; ++i) {
            int _1 = i - 3;
            int _2 = i - 2;
            int _3 = i - 1;
            int _4 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null || c[_4] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && threeWhiteSoldiers[_3] && c[_4].getColor() == CandlestickColor.BLACK && c[_4].getOpen() > c[_3].getClose() && c[_4].getClose() < c[_1].getOpen();
        }
        return results;
    }

    public static boolean[] bearishThreeLineStrike(Candlestick[] c) {
        return CandlestickPatterns.bearishThreeLineStrike(c, true);
    }

    public static boolean[] bearishThreeLineStrike(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        boolean[] threeBlackCrows = CandlestickPatterns.bearishThreeBlackCrows(c, false);
        for (int i = 3; i < len; ++i) {
            int _1 = i - 3;
            int _2 = i - 2;
            int _3 = i - 1;
            int _4 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null || c[_4] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && threeBlackCrows[_3] && c[_4].getColor() == CandlestickColor.WHITE && c[_4].getOpen() < c[_3].getClose() && c[_4].getClose() > c[_1].getOpen();
        }
        return results;
    }

    public static boolean[] bullishThreeGaps(Candlestick[] c) {
        return CandlestickPatterns.bullishThreeGaps(c, true);
    }

    public static boolean[] bullishThreeGaps(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 3; i < len; ++i) {
            int _1 = i - 3;
            int _2 = i - 2;
            int _3 = i - 1;
            int _4 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null || c[_4] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_1].gapUpBodyByBody(c[_2]) && c[_2].getColor() == CandlestickColor.WHITE && c[_2].gapUpBodyByBody(c[_3]) && c[_3].getColor() == CandlestickColor.WHITE && c[_3].gapUpBodyByBody(c[_4]) && c[_4].getColor() == CandlestickColor.WHITE;
        }
        return results;
    }

    public static boolean[] bearishThreeGaps(Candlestick[] c) {
        return CandlestickPatterns.bearishThreeGaps(c, true);
    }

    public static boolean[] bearishThreeGaps(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 3; i < len; ++i) {
            int _1 = i - 3;
            int _2 = i - 2;
            int _3 = i - 1;
            int _4 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null || c[_4] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_1].gapDownBodyByBody(c[_2]) && c[_2].getColor() == CandlestickColor.BLACK && c[_2].gapDownBodyByBody(c[_3]) && c[_3].getColor() == CandlestickColor.BLACK && c[_3].gapDownBodyByBody(c[_4]) && c[_4].getColor() == CandlestickColor.BLACK;
        }
        return results;
    }

    public static boolean[] bullishBreakaway(Candlestick[] c) {
        return CandlestickPatterns.bullishBreakaway(c, true);
    }

    public static boolean[] bullishBreakaway(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 4; i < len; ++i) {
            int _1 = i - 4;
            int _2 = i - 3;
            int _3 = i - 2;
            int _4 = i - 1;
            int _5 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null || c[_4] == null || c[_5] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getColor() == CandlestickColor.BLACK && c[_2].getColor() == CandlestickColor.BLACK && c[_4].getColor() == CandlestickColor.BLACK && c[_5].getColor() == CandlestickColor.WHITE && c[_1].getBodyType() == RealBodyType.LONG && c[_5].getBodyType() == RealBodyType.LONG && c[_1].gapDownBodyByBody(c[_2]) && c[_2].getHigh() > c[_3].getHigh() && c[_3].getHigh() > c[_4].getHigh() && c[_2].getLow() > c[_3].getLow() && c[_3].getLow() > c[_4].getLow() && c[_5].getClose() > c[_2].upperBody() && c[_5].getClose() < c[_1].lowerBody();
        }
        return results;
    }

    public static boolean[] bearishBreakaway(Candlestick[] c) {
        return CandlestickPatterns.bearishBreakaway(c, true);
    }

    public static boolean[] bearishBreakaway(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 4; i < len; ++i) {
            int _1 = i - 4;
            int _2 = i - 3;
            int _3 = i - 2;
            int _4 = i - 1;
            int _5 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null || c[_4] == null || c[_5] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getColor() == CandlestickColor.WHITE && c[_2].getColor() == CandlestickColor.WHITE && c[_4].getColor() == CandlestickColor.WHITE && c[_5].getColor() == CandlestickColor.BLACK && c[_1].getBodyType() == RealBodyType.LONG && c[_5].getBodyType() == RealBodyType.LONG && c[_1].gapUpBodyByBody(c[_2]) && c[_2].getHigh() < c[_3].getHigh() && c[_3].getHigh() < c[_4].getHigh() && c[_2].getLow() < c[_3].getLow() && c[_3].getLow() < c[_4].getLow() && c[_5].getClose() < c[_2].lowerBody() && c[_5].getClose() > c[_1].upperBody();
        }
        return results;
    }

    public static boolean[] bullishLadderBottom(Candlestick[] c) {
        return CandlestickPatterns.bullishLadderBottom(c, true);
    }

    public static boolean[] bullishLadderBottom(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        boolean[] threeBlackCrows = CandlestickPatterns.bearishThreeBlackCrows(c, false);
        boolean[] invertedHammer = CandlestickPatterns.bullishInvertedHammer(c, trend, false);
        for (int i = 4; i < len; ++i) {
            int _1 = i - 4;
            int _2 = i - 3;
            int _3 = i - 2;
            int _4 = i - 1;
            int _5 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null || c[_4] == null || c[_5] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && threeBlackCrows[_3] && invertedHammer[_4] && c[_4].getColor() == CandlestickColor.BLACK && c[_5].getColor() == CandlestickColor.WHITE && c[_4].upperBody() < c[_5].getOpen();
        }
        return results;
    }

    public static boolean[] bullishRisingThreeMethods(Candlestick[] c) {
        return CandlestickPatterns.bullishRisingThreeMethods(c, true);
    }

    public static boolean[] bullishRisingThreeMethods(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 4; i < len; ++i) {
            int _1 = i - 4;
            int _2 = i - 3;
            int _3 = i - 2;
            int _4 = i - 1;
            int _5 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null || c[_4] == null || c[_5] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getBodyType() == RealBodyType.LONG && c[_1].getColor() == CandlestickColor.WHITE && c[_2].getBodyType() == RealBodyType.SMALL && c[_2].getColor() == CandlestickColor.BLACK && c[_3].getBodyType() == RealBodyType.SMALL && c[_4].getBodyType() == RealBodyType.SMALL && c[_4].getColor() == CandlestickColor.BLACK && c[_5].getBodyType() == RealBodyType.LONG && c[_5].getColor() == CandlestickColor.WHITE && c[_2].upperBody() > c[_3].upperBody() && c[_3].upperBody() > c[_4].upperBody() && c[_2].lowerBody() > c[_3].lowerBody() && c[_3].lowerBody() > c[_4].lowerBody() && c[_1].containsBody(c[_2].getClose()) && c[_1].containsBody(c[_3].getClose()) && c[_1].containsBody(c[_4].getClose()) && c[_1].getClose() < c[_5].getClose();
        }
        return results;
    }

    public static boolean[] bearishFallingThreeMethods(Candlestick[] c) {
        return CandlestickPatterns.bearishFallingThreeMethods(c, true);
    }

    public static boolean[] bearishFallingThreeMethods(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 4; i < len; ++i) {
            int _1 = i - 4;
            int _2 = i - 3;
            int _3 = i - 2;
            int _4 = i - 1;
            int _5 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null || c[_4] == null || c[_5] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN && c[_1].getBodyType() == RealBodyType.LONG && c[_1].getColor() == CandlestickColor.BLACK && c[_2].getBodyType() == RealBodyType.SMALL && c[_2].getColor() == CandlestickColor.WHITE && c[_3].getBodyType() == RealBodyType.SMALL && c[_4].getBodyType() == RealBodyType.SMALL && c[_4].getColor() == CandlestickColor.WHITE && c[_5].getBodyType() == RealBodyType.LONG && c[_5].getColor() == CandlestickColor.BLACK && c[_2].upperBody() < c[_3].upperBody() && c[_3].upperBody() < c[_4].upperBody() && c[_2].lowerBody() < c[_3].lowerBody() && c[_3].lowerBody() < c[_4].lowerBody() && c[_1].containsBody(c[_2].getClose()) && c[_1].containsBody(c[_3].getClose()) && c[_1].containsBody(c[_4].getClose()) && c[_1].getClose() > c[_5].getClose();
        }
        return results;
    }

    public static boolean[] bullishMatHold(Candlestick[] c) {
        return CandlestickPatterns.bullishMatHold(c, true);
    }

    public static boolean[] bullishMatHold(Candlestick[] c, boolean trend) {
        int len = c.length;
        boolean[] results = new boolean[len];
        for (int i = 4; i < len; ++i) {
            int _1 = i - 4;
            int _2 = i - 3;
            int _3 = i - 2;
            int _4 = i - 1;
            int _5 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null || c[_4] == null || c[_5] == null) continue;
            results[i] = !trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getBodyType() == RealBodyType.LONG && c[_1].getColor() == CandlestickColor.WHITE && c[_1].gapUpBodyByBody(c[_2]) && c[_2].getBodyType() == RealBodyType.SMALL && c[_2].getColor() == CandlestickColor.BLACK && c[_3].getBodyType() == RealBodyType.SMALL && c[_4].getBodyType() == RealBodyType.SMALL && c[_5].getColor() == CandlestickColor.WHITE && c[_1].getClose() > c[_3].lowerBody() && c[_1].getClose() > c[_4].lowerBody() && c[_2].getOpen() > c[_3].upperBody() && c[_3].upperBody() > c[_4].upperBody() && c[_4].getClose() < c[_5].getOpen() && c[_2].getHigh() < c[_5].getClose() && c[_3].getHigh() < c[_5].getClose() && c[_4].getHigh() < c[_5].getClose();
        }
        return results;
    }
}

