/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.dangan.io.CachedInputStream;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;

public class PreLz5Decoder
implements PreLzssDecoder {
    private static final int DictionarySize = 4096;
    private static final int MaxMatch = 18;
    private static final int Threshold = 3;
    private InputStream in;
    private int position;
    private int matchPos;
    private int matchLen;
    private int flagByte;
    private int flagBit;
    private int markPosition;
    private int markMatchPos;
    private int markMatchLen;
    private int markFlagByte;
    private int markFlagBit;

    private PreLz5Decoder() {
    }

    public PreLz5Decoder(InputStream in) {
        if (in == null) {
            throw new NullPointerException("in");
        }
        this.in = in instanceof CachedInputStream ? (CachedInputStream)in : new CachedInputStream(in);
        this.position = 0;
        this.matchPos = 0;
        this.matchLen = 0;
        this.flagByte = 0;
        this.flagBit = 256;
        this.markPosition = 0;
        this.markMatchPos = 0;
        this.markMatchLen = 0;
        this.markFlagByte = 0;
        this.markFlagBit = 0;
    }

    public int readCode() throws IOException {
        if (this.flagBit == 256) {
            this.flagByte = this.in.read();
            if (this.flagByte >= 0) {
                this.flagBit = 1;
            } else {
                throw new EOFException();
            }
        }
        if ((this.flagByte & this.flagBit) != 0) {
            this.flagBit <<= 1;
            ++this.position;
            int ret = this.in.read();
            if (ret >= 0) {
                return ret;
            }
            throw new EOFException();
        }
        this.flagBit <<= 1;
        int c1 = this.in.read();
        int c2 = this.in.read();
        if (c1 >= 0) {
            this.matchPos = (c2 & 0xF0) << 4 | c1;
            this.matchLen = c2 & 0xF;
            return this.matchLen | 0x100;
        }
        throw new EOFException();
    }

    public int readOffset() throws IOException {
        int offset = this.position - this.matchPos - 1 - 18 & 0xFFF;
        this.position += this.matchLen + 3;
        return offset;
    }

    public void mark(int readLimit) {
        this.in.mark((readLimit * 9 + 7) / 8 + 2);
        this.markPosition = this.position;
        this.markMatchLen = this.matchLen;
        this.markMatchPos = this.matchPos;
        this.markFlagByte = this.flagByte;
        this.markFlagBit = this.flagBit;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.position = this.markPosition;
        this.matchLen = this.markMatchLen;
        this.matchPos = this.markMatchPos;
        this.flagByte = this.markFlagByte;
        this.flagBit = this.markFlagBit;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int available() throws IOException {
        return Math.max(this.in.available() * 8 / 9 - 2, 0);
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
    }

    public int getDictionarySize() {
        return 4096;
    }

    public int getMaxMatch() {
        return 18;
    }

    public int getThreshold() {
        return 3;
    }
}

