/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.util;

import java.util.Collection;
import java.util.Map;

public abstract class Assert {
    public static void isTrue(boolean expression, String message) throws IllegalArgumentException {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isTrue(boolean expression) throws IllegalArgumentException {
        Assert.isTrue(expression, "[Assertion failed] - this expression must be true");
    }

    public static void isFalse(boolean expression, String message) throws IllegalArgumentException {
        if (expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isFalse(boolean expression) throws IllegalArgumentException {
        Assert.isFalse(expression, "[Assertion failed] - this expression must be false");
    }

    public static void isNull(Object object, String message) throws IllegalArgumentException {
        if (object != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isNull(Object object) throws IllegalArgumentException {
        Assert.isNull(object, "[Assertion failed] - the object argument must be null");
    }

    public static void notNull(Object object, String message) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object object) throws IllegalArgumentException {
        Assert.notNull(object, "[Assertion failed] - this argument is required; it must not be null");
    }

    public static void isEmpty(String str, String message) throws IllegalArgumentException {
        if (str != null && !str.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isEmpty(String str) throws IllegalArgumentException {
        Assert.isEmpty(str, "[Assertion failed] - this String argument must be null or empty");
    }

    public static void isEmpty(Object[] array, String message) throws IllegalArgumentException {
        if (array != null && array.length > 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isEmpty(Object[] array) throws IllegalArgumentException {
        Assert.isEmpty(array, "[Assertion failed] - this array must be empty");
    }

    public static void isEmpty(Collection<?> collection, String message) throws IllegalArgumentException {
        if (collection != null && collection.size() > 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isEmpty(Collection<?> collection) throws IllegalArgumentException {
        Assert.isEmpty(collection, "[Assertion failed] - this collection must be empty");
    }

    public static void isEmpty(Map<?, ?> map, String message) throws IllegalArgumentException {
        if (map != null && map.size() > 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isEmpty(Map<?, ?> map) throws IllegalArgumentException {
        Assert.isEmpty(map, "[Assertion failed] - this map must be empty");
    }

    public static void notEmpty(String str, String message) throws IllegalArgumentException {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(String str) throws IllegalArgumentException {
        Assert.notEmpty(str, "[Assertion failed] - this String argument must have length; it must not be null or empty");
    }

    public static void notEmpty(Object[] array, String message) throws IllegalArgumentException {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array) throws IllegalArgumentException {
        Assert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element");
    }

    public static void notEmpty(Collection<?> collection, String message) throws IllegalArgumentException {
        if (collection == null || collection.size() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Collection<?> collection) throws IllegalArgumentException {
        Assert.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element");
    }

    public static void notEmpty(Map<?, ?> map, String message) throws IllegalArgumentException {
        if (map == null || map.size() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Map<?, ?> map) throws IllegalArgumentException {
        Assert.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry");
    }

    public static void noNullElements(Object[] array, String message) throws IllegalArgumentException {
        if (array != null) {
            for (Object obj : array) {
                if (obj != null) continue;
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static void noNullElements(Object[] array) throws IllegalArgumentException {
        Assert.noNullElements(array, "[Assertion failed] - this array must not contain any null elements");
    }

    public static void noNullElements(Collection<?> collection, String message) throws IllegalArgumentException {
        if (collection != null) {
            for (Object obj : collection) {
                if (obj != null) continue;
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static void noNullElements(Collection<?> collection) throws IllegalArgumentException {
        Assert.noNullElements(collection, "[Assertion failed] - this Collection must not contain any null elements");
    }

    public static void state(boolean expression, String message) throws IllegalStateException {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void state(boolean expression) throws IllegalStateException {
        Assert.state(expression, "[Assertion failed] - this state invariant must be true");
    }
}

