/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.candle.generator;

/**
 * ローソク足情報にトレンド情報を結びつけるトレンド処理のインターフェースです。
 * 
 * @author 杉澤 浩二
 */
public interface TrendProcessor {

	/**
	 * 指定されたローソク足情報へトレンド情報を付与します。
	 * 
	 * @param c ローソク足
	 * @throws TrendProcessorException トレンド情報の付与に必要な情報がなく付与に失敗した場合
	 */
	public void execute(DefaultCandlestick[] c) throws TrendProcessorException;

}
