/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.data.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 依存するフィールドの型が、{@link CharSequence} やそのサブクラスの日時データである場合の日付/時刻の解析方法を示します。
 * 
 * <pre>
 * 例:
 * &#064;DatePattern(&quot;yyyy/MM/dd&quot;)
 * &#064;DatePattern(value = &quot;yyyy/MM/dd&quot;, language = &quot;ja&quot;)
 * &#064;DatePattern(value = &quot;yyyy/MM/dd&quot;, language = &quot;ja&quot;, country = &quot;JP&quot;)
 * &#064;DatePattern(value = &quot;yyyy/MM/dd HH:mm:ss&quot;, timezone = &quot;Asia/Tokyo&quot;)
 * &#064;DatePattern(value = &quot;yyyy/MM/dd HH:mm:ss&quot;, language = &quot;ja&quot;, country = &quot;JP&quot;, timezone = &quot;Asia/Tokyo&quot;)
 * </pre>
 * 
 * @author 杉澤 浩二
 * @since 2.1
 */
@Target(value = { ElementType.TYPE, ElementType.FIELD })
@Retention(RetentionPolicy.RUNTIME)
public @interface DatePattern {

	/**
	 * 日付/時刻の書式形式文字列を返します。
	 * 
	 * @return 日付/時刻の書式形式
	 */
	public String value();

	/**
	 * 日付/時刻の書式形式文字列の {@link java.util.Locale} として使用する言語コード (2 桁の小文字からなる ISO-639 コード) を返します。
	 * 
	 * @return 言語コード (2 桁の小文字からなる ISO-639 コード)
	 */
	public String language() default "";

	/**
	 * 日付/時刻の書式形式文字列の {@link java.util.Locale} として使用する国コード (2 桁の大文字からなる ISO-3166 コード) を返します。
	 * 
	 * @return 国コード (2 桁の大文字からなる ISO-3166 コード)
	 */
	public String country() default "";

	/**
	 * {@link java.util.TimeZone} として使用するタイムゾーン ID を返します。
	 * 
	 * @return タイムゾーン ID
	 */
	public String timezone() default "";

}
