/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.data.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 依存するフィールドの型が、{@link CharSequence} やそのサブクラスの数値データである場合の数値/通貨の解析方法を示します。
 * 
 * <pre>
 * 例:
 * &#064;NumberPattern("#,##0")
 * &#064;NumberPattern(value = "#,##0", country = "JP")
 * &#064;NumberPattern(value = "#,##0", language = "ja", country = "JP")
 * &#064;NumberPattern(value = "\u00A4\u00A4 #,##0", currency = "USD")
 * &#064;NumberPattern(value = "\u00A4\u00A4 #,##0", language = "ja", country = "JP", currency = "USD")
 * </pre>
 * 
 * @author 杉澤 浩二
 * @since 2.1
 */
@Target(value = { ElementType.TYPE, ElementType.FIELD })
@Retention(RetentionPolicy.RUNTIME)
public @interface NumberPattern {

	/**
	 * 数値の書式形式文字列を返します。
	 * 
	 * @return 数値の書式形式
	 */
	public String value();

	/**
	 * 数値の書式形式文字列の {@link java.util.Locale} として使用する言語コード (2 桁の小文字からなる ISO-639 コード) を返します。
	 * 
	 * @return 言語コード (2 桁の小文字からなる ISO-639 コード)
	 */
	public String language() default "";

	/**
	 * 数値の書式形式文字列の {@link java.util.Locale} として使用する国コード (2 桁の大文字からなる ISO-3166 コード) を返します。
	 * 
	 * @return 国コード (2 桁の大文字からなる ISO-3166 コード)
	 */
	public String country() default "";

	/**
	 * 数値の書式形式文字列の {@link java.util.Currency} として使用する通貨コード (ISO 4217 コード) を返します。
	 * 
	 * @return 通貨コード (ISO 4217 コード)
	 */
	public String currency() default "";

}
