/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.dataset;

import jp.sf.orangesignal.ta.data.CompressType;

/**
 * 既定のデータの種類を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum DefaultDataType implements DataType {

	/**
	 * <p>始値を表します。</p>
	 * {@link #getCompressType()} の実装は常に {@link CompressType#FIRST} を返します。
	 */
	OPEN { @Override public CompressType getCompressType() { return CompressType.FIRST; } },

	/**
	 * <p>高値を表します。</p>
	 * {@link #getCompressType()} の実装は常に {@link CompressType#HIGHEST} を返します。
	 */
	HIGH { @Override public CompressType getCompressType() { return CompressType.HIGHEST; } },

	/**
	 * <p>安値を表します。</p>
	 * {@link #getCompressType()} の実装は常に {@link CompressType#LOWEST} を返します。
	 */
	LOW { @Override public CompressType getCompressType() { return CompressType.LOWEST; } },

	/**
	 * <p>終値を表します。</p>
	 * {@link #getCompressType()} の実装は常に {@link CompressType#LAST} を返します。
	 */
	CLOSE { @Override public CompressType getCompressType() { return CompressType.LAST; } },

	/**
	 * <p>出来高を表します。</p>
	 * {@link #getCompressType()} の実装は常に {@link CompressType#SUM} を返します。
	 */
	VOLUME { @Override public CompressType getCompressType() { return CompressType.SUM; } },

	/**
	 * <p>テクニカル指標計算用始値を表します。</p>
	 * {@link #getCompressType()} の実装は常に {@link CompressType#FIRST} を返します。
	 */
	TECHNICAL_OPEN { @Override public CompressType getCompressType() { return CompressType.FIRST; } },

	/**
	 * <p>テクニカル指標計算用高値を表します。</p>
	 * {@link #getCompressType()} の実装は常に {@link CompressType#HIGHEST} を返します。
	 */
	TECHNICAL_HIGH { @Override public CompressType getCompressType() { return CompressType.HIGHEST; } },

	/**
	 * <p>テクニカル指標計算用安値を表します。</p>
	 * {@link #getCompressType()} の実装は常に {@link CompressType#LOWEST} を返します。
	 */
	TECHNICAL_LOW { @Override public CompressType getCompressType() { return CompressType.LOWEST; } },

	/**
	 * <p>テクニカル指標計算用終値を表します。</p>
	 * {@link #getCompressType()} の実装は常に {@link CompressType#LAST} を返します。
	 */
	TECHNICAL_CLOSE { @Override public CompressType getCompressType() { return CompressType.LAST; } },

	/**
	 * <p>テクニカル指標計算用出来高を表します。</p>
	 * {@link #getCompressType()} の実装は常に {@link CompressType#SUM} を返します。
	 */
	TECHNICAL_VOLUME { @Override public CompressType getCompressType() { return CompressType.SUM; } },

	/**
	 * <p>信用売残を表します。</p>
	 * {@link #getCompressType()} の実装は常に {@link CompressType#SUM} を返します。
	 */
	SOLD { @Override public CompressType getCompressType() { return CompressType.SUM; } },

	/**
	 * <p>信用買残を表します。</p>
	 * {@link #getCompressType()} の実装は常に {@link CompressType#SUM} を返します。
	 */
	BOUGHT { @Override public CompressType getCompressType() { return CompressType.SUM; } },

	/**
	 * <p>株式分割数を表します。</p>
	 * {@link #getCompressType()} の実装は常に {@link CompressType#SUM} を返します。
	 */
	SPLIT { @Override public CompressType getCompressType() { return CompressType.SUM; } };

}
