/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.dataset;

/**
 * 足の単位を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum IntervalType {

	/**
	 * <p>分足を表します。</p>
	 * {@link #getMaxPeriod()} は常に <code>60</code> を返します。
	 */
	MINUTELY { @Override public int getMaxPeriod() { return 60; } },

	/**
	 * <p>時足を表します。</p>
	 * {@link #getMaxPeriod()} は常に <code>24</code> を返します。
	 */
	HOURLY { @Override public int getMaxPeriod() { return 24; } },

	/**
	 * <p>日足を表します。</p>
	 * {@link #getMaxPeriod()} は常に <code>365</code> を返します。
	 */
	DAILY { @Override public int getMaxPeriod() { return 365; } },

	/**
	 * <p>週足を表します。</p>
	 * {@link #getMaxPeriod()} は常に <code>52</code> を返します。
	 */
	WEEKLY { @Override public int getMaxPeriod() { return 52; } },

	/**
	 * <p>月足を表します。</p>
	 * {@link #getMaxPeriod()} は常に <code>12</code> を返します。
	 */
	MONTHLY { @Override public int getMaxPeriod() { return 12; } };

	/**
	 * この足単位の最大期間を返します。
	 * 
	 * @return 最大期間
	 */
	public abstract int getMaxPeriod();

}
