/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.dataset;

import java.util.Date;

/**
 * 価格データのインターフェースを提供します。
 * 
 * @author 杉澤 浩二
 */
public interface PriceData {

	/**
	 * <p>日時を返します。</p>
	 * 
	 * @return 日時
	 */
	public Date getDate();

	/**
	 * 始値を返します。
	 * 
	 * @return 始値
	 */
	public Number getOpen();

	/**
	 * 高値を返します。
	 * 
	 * @return 高値
	 */
	public Number getHigh();

	/**
	 * 安値を返します。
	 * 
	 * @return 安値
	 */
	public Number getLow();

	/**
	 * 終値を返します。
	 * 
	 * @return 終値
	 */
	public Number getClose();

}
