/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.result;

/**
 * 上下に3本のバンドと中央に1本のバンドを持つ計算結果の種類を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum Bands7 {

	/**
	 * 最上位バンド
	 */
	UPPER_BAND3,

	/**
	 * 上位バンド2
	 */
	UPPER_BAND2,

	/**
	 * 上位バンド1
	 */
	UPPER_BAND1,

	/**
	 * 中央バンド
	 */
	MIDDLE_BAND,

	/**
	 * 下位バンド1
	 */
	LOWER_BAND1,

	/**
	 * 下位バンド2
	 */
	LOWER_BAND2,

	/**
	 * 最下位バンド
	 */
	LOWER_BAND3;

}
