/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.util;

/**
 * 文字列操作に関するユーティリティを提供します。
 * 
 * @author 杉澤 浩二
 * @since 2.1
 */
public abstract class StringUtils {

	/**
	 * 空の文字列です。
	 */
	public static final String EMPTY = "";

	/**
	 * 指定された文字列が空または <code>null</code> であるかどうかを返します。
	 * 
	 * @param str 文字列
	 * @return 文字列が空または <code>null</code> の場合は <code>true</code> それ以外の場合は <code>false</code>
	 */
	public static boolean isEmpty(final String str) {
		return str == null || str.isEmpty();
	}

	/**
	 * 指定された文字列が空や <code>null</code> でないかどうかを返します。
	 * 
	 * @param str 文字列
	 * @return 文字列が空や <code>null</code> でない場合は <code>true</code> それ以外の場合は <code>false</code>
	 */
	public static boolean isNotEmpty(final String str) {
		return !isEmpty(str);
	}

	/**
	 * 指定された文字列が <code>null</code> でない場合は、指定された文字列を返し、
	 * 指定された文字列が <code>null</code> の場合は、空の文字列を返します。
	 * 
	 * @param str 文字列
	 * @return 文字列または空の文字列
	 */
	public static String defaultString(final String str) {
		return defaultString(str, EMPTY);
	}

	/**
	 * 指定された文字列が <code>null</code> でない場合は、指定された文字列を返し、
	 * 指定された文字列が <code>null</code> の場合は、デフォルトの文字列を返します。
	 * 
	 * @param str 文字列
	 * @param defaultStr デフォルトの文字列
	 * @return 文字列またはデフォルトの文字列
	 */
	public static String defaultString(final String str, final String defaultStr) {
		return (str == null) ? defaultStr : str;
	}

	/**
	 * 指定された文字列が <code>null</code> または空の文字列でない場合は、指定された文字列を返し、
	 * 指定された文字列が <code>null</code> または空の文字列の場合は、デフォルトの文字列を返します。
	 * 
	 * @param str 文字列
	 * @param defaultStr デフォルトの文字列
	 * @return 文字列またはデフォルトの文字列
	 */
	public static String defaultIfEmpty(final String str, final String defaultStr) {
		return (str == null || str.isEmpty()) ? defaultStr : str;
	}

	//-----------------------------------------------------------------------
	// Case conversion

	public static String capitalize(final String str) {
		final int strLen;
		if (str == null || (strLen = str.length()) == 0) {
			return str;
		}
		return new StringBuffer(strLen)
			.append(Character.toTitleCase(str.charAt(0)))
			.append(str.substring(1))
			.toString();
	}

	public static String uncapitalize(final String str) {
		final int strLen;
		if (str == null || (strLen = str.length()) == 0) {
			return str;
		}
		return new StringBuffer(strLen)
			.append(Character.toLowerCase(str.charAt(0)))
			.append(str.substring(1))
			.toString();
	}

}
