/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxf.binding.nmr.interceptors;

import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.helpers.NSStack;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.servicemix.cxf.binding.nmr.NMRFault;
import org.apache.servicemix.cxf.binding.nmr.NMRMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NMRFaultOutInterceptor
extends AbstractPhaseInterceptor<NMRMessage> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(NMRFaultOutInterceptor.class);

    public NMRFaultOutInterceptor() {
        super("marshal");
    }

    public void handleMessage(NMRMessage message) throws Fault {
        message.put(Message.RESPONSE_CODE, new Integer(500));
        NSStack nsStack = new NSStack();
        nsStack.push();
        try {
            XMLStreamWriter writer = this.getWriter(message);
            Fault fault = this.getFault(message);
            NMRFault jbiFault = NMRFault.createFault(fault);
            nsStack.add("http://cxf.apache.org/bindings/nmr");
            String prefix = nsStack.getPrefix("http://cxf.apache.org/bindings/nmr");
            StaxUtils.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"NMRFault", (String)"http://cxf.apache.org/bindings/nmr");
            if (!jbiFault.hasDetails()) {
                writer.writeEmptyElement("fault");
            } else {
                Element detail = jbiFault.getDetail();
                NodeList details = detail.getChildNodes();
                for (int i = 0; i < details.getLength(); ++i) {
                    if (!(details.item(i) instanceof Element)) continue;
                    StaxUtils.writeNode((Node)details.item(i), (XMLStreamWriter)writer, (boolean)true);
                    break;
                }
            }
            writer.writeEndElement();
            writer.flush();
        }
        catch (XMLStreamException xe) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("XML_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)xe);
        }
    }

    protected Fault getFault(NMRMessage message) {
        Exception e = (Exception)message.getContent(Exception.class);
        if (e == null) {
            throw new IllegalStateException(new org.apache.cxf.common.i18n.Message("NO_EXCEPTION", BUNDLE, new Object[0]).toString());
        }
        Fault fault = e instanceof Fault ? (Fault)e : new Fault((Throwable)e);
        return fault;
    }

    protected XMLStreamWriter getWriter(NMRMessage message) {
        XMLStreamWriter writer = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
        if (writer == null) {
            throw new IllegalStateException(new org.apache.cxf.common.i18n.Message("NO_XML_STREAM_WRITER", BUNDLE, new Object[0]).toString());
        }
        return writer;
    }
}

