/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCS;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskGroup;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskObject;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.Messages;
import org.eclipse.ui.forms.widgets.Form;

public class CompCSGroupValidator {
    private Form fForm;
    private HashSet fGroups;
    private String fErrorCategory;

    public CompCSGroupValidator(ICompCS cheatsheet, Form form, String errorCategory) {
        this.fForm = form;
        this.fErrorCategory = errorCategory;
        this.fGroups = new HashSet();
        this.populateGroups(cheatsheet);
    }

    private void populateGroups(ICompCS cheatsheet) {
        if (cheatsheet.getFieldTaskObject().getType() == 1) {
            this.addGroup((ICompCSTaskGroup)cheatsheet.getFieldTaskObject());
        }
    }

    public void addGroup(ICompCSTaskGroup group) {
        this.fGroups.add(group);
        if (!group.hasFieldTaskObjects()) {
            return;
        }
        ICompCSTaskObject[] taskObjects = group.getFieldTaskObjects();
        int i = 0;
        while (i < taskObjects.length) {
            if (taskObjects[i].getType() == 1) {
                this.addGroup((ICompCSTaskGroup)taskObjects[i]);
            }
            ++i;
        }
    }

    public void removeGroup(ICompCSTaskGroup group) {
        this.fGroups.remove(group);
        if (!group.hasFieldTaskObjects()) {
            return;
        }
        ICompCSTaskObject[] taskObjects = group.getFieldTaskObjects();
        int i = 0;
        while (i < taskObjects.length) {
            if (taskObjects[i].getType() == 1) {
                this.removeGroup((ICompCSTaskGroup)taskObjects[i]);
            }
            ++i;
        }
    }

    public boolean validate() {
        if (this.fGroups.isEmpty()) {
            this.fForm.setMessage(null);
            return true;
        }
        Iterator iterator = this.fGroups.iterator();
        while (iterator.hasNext()) {
            ICompCSTaskGroup group = (ICompCSTaskGroup)iterator.next();
            if (this.validate(group)) continue;
            return false;
        }
        this.fForm.setMessage(null);
        return true;
    }

    private boolean validate(ICompCSTaskGroup group) {
        if (group.getFieldTaskObjectCount() == 0) {
            String message = String.valueOf('[') + this.fErrorCategory + ']' + ' ' + PDETextHelper.translateReadText((String)group.getFieldName()) + ':' + ' ' + Messages.CompCSGroupValidator_errorChildlessGroup;
            this.fForm.setMessage(message, 1);
            return false;
        }
        return true;
    }
}

