/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver.backend.local;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.internal.resolver.backend.local.WSDLManager;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLManagerImpl
implements WSDLManager {
    private static final Log LOG = LogFactory.getLog(WSDLManagerImpl.class);
    final WSDLFactory factory;
    final Map<QName, Collection<Definition>> portTypeToDefinitionsMap;
    final Map<Object, Definition> urlToDefinitionMap;
    final Map<Object, Collection<Service>> serviceMap;

    public WSDLManagerImpl() {
        try {
            this.factory = WSDLFactory.newInstance();
        }
        catch (WSDLException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.portTypeToDefinitionsMap = new HashMap<QName, Collection<Definition>>();
        this.urlToDefinitionMap = new HashMap<Object, Definition>();
        this.serviceMap = new HashMap<Object, Collection<Service>>();
    }

    public WSDLFactory getWSDLFactory() {
        return this.factory;
    }

    @Override
    public void setupWSDLs(URL wsdlPath) throws WSDLException, IOException {
        String wsdlUrl = wsdlPath.toString();
        if (!wsdlUrl.endsWith(".zip")) {
            LOG.info((Object)("the path of wsdl file is " + wsdlUrl));
            this.getDefinition(wsdlUrl);
        } else {
            InputStream wsdlIs = wsdlPath.openStream();
            try {
                ZipEntry entry;
                ZipInputStream wsdlZipIs = new ZipInputStream(wsdlIs);
                while ((entry = wsdlZipIs.getNextEntry()) != null) {
                    if (entry.isDirectory() || entry.getName().startsWith("_") || entry.getName().startsWith(".") || !entry.getName().endsWith(".wsdl")) continue;
                    String entryName = entry.getName();
                    byte[] bytes = WSDLManagerImpl.streamToByteArray(wsdlZipIs);
                    InputSource src = new InputSource(new ByteArrayInputStream(bytes));
                    this.loadDefinition(entryName, src);
                }
            }
            finally {
                wsdlIs.close();
            }
        }
        for (QName qname : this.portTypeToDefinitionsMap.keySet()) {
            if (!(qname instanceof QName)) continue;
            LOG.info((Object)("portType = " + qname));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Definition> getDefinitions(QName portType) throws WSDLException {
        Map<QName, Collection<Definition>> map = this.portTypeToDefinitionsMap;
        synchronized (map) {
            if (this.portTypeToDefinitionsMap.containsKey(portType)) {
                return this.portTypeToDefinitionsMap.get(portType);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition getDefinition(URL url) throws WSDLException {
        Map<Object, Definition> map = this.urlToDefinitionMap;
        synchronized (map) {
            if (this.urlToDefinitionMap.containsKey(url)) {
                return this.urlToDefinitionMap.get(url);
            }
        }
        Definition def = this.loadDefinition(url.toString());
        Map<Object, Definition> map2 = this.urlToDefinitionMap;
        synchronized (map2) {
            this.urlToDefinitionMap.put(url, def);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Definition getDefinition(String url) throws WSDLException {
        Map<Object, Definition> map = this.urlToDefinitionMap;
        synchronized (map) {
            if (this.urlToDefinitionMap.containsKey(url)) {
                return this.urlToDefinitionMap.get(url);
            }
        }
        return this.loadDefinition(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDefinition(String urlName, Definition wsdl) {
        Map<Object, Definition> map = this.urlToDefinitionMap;
        synchronized (map) {
            this.urlToDefinitionMap.put(urlName, wsdl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDefinition(URL url, Definition wsdl) {
        Map<Object, Definition> map = this.urlToDefinitionMap;
        synchronized (map) {
            this.urlToDefinitionMap.put(url, wsdl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDefinition(Definition wsdl) {
        Map<Object, Definition> map = this.urlToDefinitionMap;
        synchronized (map) {
            ArrayList<Object> urlKeys = new ArrayList<Object>();
            QName portType = null;
            for (Map.Entry<Object, Definition> entry : this.urlToDefinitionMap.entrySet()) {
                if (entry.getValue() != wsdl) continue;
                urlKeys.add(entry.getKey());
            }
            for (Map.Entry<Object, Object> entry : this.portTypeToDefinitionsMap.entrySet()) {
                if (entry.getValue() != wsdl) continue;
                portType = (QName)entry.getKey();
                break;
            }
            for (Map.Entry<Object, Object> entry : urlKeys) {
                this.urlToDefinitionMap.remove(entry);
                Collection<Service> servicesToRemove = this.serviceMap.remove(entry);
                Collection<Service> services = this.serviceMap.get(portType);
                block6: for (Service s : servicesToRemove) {
                    Iterator<Service> i = services.iterator();
                    while (i.hasNext()) {
                        if (!s.equals(i.next())) continue;
                        i.remove();
                        continue block6;
                    }
                }
                if (!services.isEmpty()) continue;
                this.serviceMap.remove(portType);
            }
        }
    }

    private Definition loadDefinition(String url) throws WSDLException {
        return this.loadDefinition(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Definition loadDefinition(String name, InputSource src) throws WSDLException {
        WSDLReader reader = this.factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", src != null);
        Definition def = src == null ? reader.readWSDL(name) : reader.readWSDL("", src);
        QName portType = (QName)def.getPortTypes().keySet().iterator().next();
        this.addDefinition(name, def);
        this.addDefinition(portType, def);
        for (Service serv : def.getServices().values()) {
            if (serv == null) continue;
            Map<Object, Collection<Service>> map = this.serviceMap;
            synchronized (map) {
                this.addService(name, serv);
                this.addService(portType, serv);
                break;
            }
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDefinition(QName portType, Definition wsdl) {
        if (portType == null || wsdl == null) {
            throw new IllegalArgumentException();
        }
        Map<QName, Collection<Definition>> map = this.portTypeToDefinitionsMap;
        synchronized (map) {
            Collection<Definition> definitions = this.portTypeToDefinitionsMap.get(portType);
            if (definitions == null) {
                definitions = new LinkedList<Definition>();
                this.portTypeToDefinitionsMap.put(portType, definitions);
            }
            definitions.add(wsdl);
        }
    }

    private static byte[] streamToByteArray(InputStream is) throws IOException {
        int bytesRead;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = is.read(buffer, 0, 1024)) != -1) {
            bos.write(buffer, 0, bytesRead);
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addService(Object key, Service service) {
        if (key == null || service == null) {
            throw new IllegalArgumentException();
        }
        Map<Object, Collection<Service>> map = this.serviceMap;
        synchronized (map) {
            Collection<Service> services = this.serviceMap.get(key);
            if (services == null) {
                services = new LinkedList<Service>();
                this.serviceMap.put(key, services);
            }
            services.add(service);
        }
    }
}

