/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils;

import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.staxutils.AbstractDOMStreamReader;
import org.apache.cxf.staxutils.W3CNamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public class W3CDOMStreamReader
extends AbstractDOMStreamReader {
    private Node content;
    private Document document;
    private W3CNamespaceContext context;

    public W3CDOMStreamReader(Element element) {
        super(new AbstractDOMStreamReader.ElementFrame(element, null));
        this.newFrame(this.getCurrentFrame());
        this.document = element.getOwnerDocument();
    }

    public W3CDOMStreamReader(Document doc) {
        super(new AbstractDOMStreamReader.ElementFrame(doc));
        this.document = doc;
    }

    public Document getDocument() {
        return this.document;
    }

    protected final void newFrame(AbstractDOMStreamReader.ElementFrame frame) {
        Node element = this.getCurrentNode();
        frame.uris = new ArrayList<String>();
        frame.prefixes = new ArrayList<String>();
        frame.attributes = new ArrayList<Object>();
        if (this.context == null) {
            this.context = new W3CNamespaceContext();
        }
        if (element instanceof Element) {
            this.context.setElement((Element)element);
        }
        NamedNodeMap nodes = element.getAttributes();
        String ePrefix = element.getPrefix();
        if (ePrefix == null) {
            ePrefix = "";
        }
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String prefix = node.getPrefix();
                String localName = node.getLocalName();
                String value = node.getNodeValue();
                String name = node.getNodeName();
                if (prefix == null) {
                    prefix = "";
                }
                if (name != null && "xmlns".equals(name)) {
                    frame.uris.add(value);
                    frame.prefixes.add("");
                    continue;
                }
                if (prefix.length() > 0 && "xmlns".equals(prefix)) {
                    frame.uris.add(value);
                    frame.prefixes.add(localName);
                    continue;
                }
                if (name.startsWith("xmlns:")) {
                    prefix = name.substring(6);
                    frame.uris.add(value);
                    frame.prefixes.add(prefix);
                    continue;
                }
                frame.attributes.add(node);
            }
        }
    }

    protected void endElement() {
        super.endElement();
    }

    public final Node getCurrentNode() {
        return (Node)this.getCurrentFrame().element;
    }

    public final Element getCurrentElement() {
        return (Element)this.getCurrentFrame().element;
    }

    protected AbstractDOMStreamReader.ElementFrame getChildFrame(int currentChild) {
        return new AbstractDOMStreamReader.ElementFrame(this.getCurrentNode().getChildNodes().item(currentChild), this.getCurrentFrame());
    }

    protected int getChildCount() {
        return this.getCurrentNode().getChildNodes().getLength();
    }

    protected int moveToChild(int currentChild) {
        this.content = this.getCurrentNode().getFirstChild();
        while (currentChild > 0 && this.content != null) {
            this.content = this.content.getNextSibling();
            --currentChild;
        }
        if (this.content instanceof Element) {
            return 1;
        }
        if (this.content instanceof CDATASection) {
            return 12;
        }
        if (this.content instanceof Comment) {
            return 5;
        }
        if (this.content instanceof Text) {
            return 4;
        }
        if (this.content instanceof EntityReference) {
            return 9;
        }
        throw new IllegalStateException("Found type: " + this.content.getClass().getName());
    }

    public String getElementText() throws XMLStreamException {
        String result = DOMUtils.getContent(this.content);
        AbstractDOMStreamReader.ElementFrame frame = this.getCurrentFrame();
        frame.ended = true;
        this.currentEvent = 2;
        this.endElement();
        return result != null ? result : "";
    }

    public String getNamespaceURI(String prefix) {
        AbstractDOMStreamReader.ElementFrame frame = this.getCurrentFrame();
        while (null != frame) {
            int index = frame.prefixes.indexOf(prefix);
            if (index != -1) {
                return frame.uris.get(index);
            }
            if (frame.parent == null) {
                return ((Element)frame.getElement()).lookupNamespaceURI(prefix);
            }
            frame = frame.parent;
        }
        return null;
    }

    public String getAttributeValue(String ns, String local) {
        Attr at = ns == null || ns.equals("") ? this.getCurrentElement().getAttributeNode(local) : this.getCurrentElement().getAttributeNodeNS(ns, local);
        if (at == null) {
            return null;
        }
        return DOMUtils.getContent(at);
    }

    public int getAttributeCount() {
        return this.getCurrentFrame().attributes.size();
    }

    Attr getAttribute(int i) {
        return (Attr)this.getCurrentFrame().attributes.get(i);
    }

    private String getLocalName(Attr attr) {
        String name = attr.getLocalName();
        if (name == null) {
            name = attr.getNodeName();
        }
        return name;
    }

    public QName getAttributeName(int i) {
        Attr at = this.getAttribute(i);
        String prefix = at.getPrefix();
        String ln = this.getLocalName(at);
        String ns = at.getNamespaceURI();
        if (prefix == null) {
            return new QName(ns, ln);
        }
        return new QName(ns, ln, prefix);
    }

    public String getAttributeNamespace(int i) {
        return this.getAttribute(i).getNamespaceURI();
    }

    public String getAttributeLocalName(int i) {
        Attr attr = this.getAttribute(i);
        return this.getLocalName(attr);
    }

    public String getAttributePrefix(int i) {
        return this.getAttribute(i).getPrefix();
    }

    public String getAttributeType(int i) {
        Attr attr = this.getAttribute(i);
        if (attr.isId()) {
            return "ID";
        }
        TypeInfo schemaType = attr.getSchemaTypeInfo();
        return schemaType == null ? "CDATA" : (schemaType.getTypeName() == null ? "CDATA" : schemaType.getTypeName());
    }

    public String getAttributeValue(int i) {
        return this.getAttribute(i).getValue();
    }

    public boolean isAttributeSpecified(int i) {
        return this.getAttribute(i).getValue() != null;
    }

    public int getNamespaceCount() {
        return this.getCurrentFrame().prefixes.size();
    }

    public String getNamespacePrefix(int i) {
        return this.getCurrentFrame().prefixes.get(i);
    }

    public String getNamespaceURI(int i) {
        return this.getCurrentFrame().uris.get(i);
    }

    public NamespaceContext getNamespaceContext() {
        return this.context;
    }

    public String getText() {
        if (this.content instanceof Text) {
            return ((Text)this.content).getData();
        }
        return DOMUtils.getRawContent(this.getCurrentNode());
    }

    public char[] getTextCharacters() {
        return this.getText().toCharArray();
    }

    public int getTextStart() {
        return 0;
    }

    public int getTextLength() {
        return this.getText().length();
    }

    public String getEncoding() {
        return null;
    }

    public QName getName() {
        Node el = this.getCurrentNode();
        String prefix = this.getPrefix();
        String ln = this.getLocalName();
        if (prefix == null) {
            return new QName(el.getNamespaceURI(), ln);
        }
        return new QName(el.getNamespaceURI(), ln, prefix);
    }

    public String getLocalName() {
        String ln = this.getCurrentNode().getLocalName();
        if (ln == null) {
            ln = this.getCurrentNode().getNodeName();
        }
        return ln;
    }

    public String getNamespaceURI() {
        String ln = this.getCurrentNode().getLocalName();
        if (ln == null) {
            ln = this.getCurrentNode().getNodeName();
            ln = ln.indexOf(":") == -1 ? this.getNamespaceURI("") : this.getNamespaceURI(ln.substring(0, ln.indexOf(":")));
            return ln;
        }
        return this.getCurrentNode().getNamespaceURI();
    }

    public String getPrefix() {
        String prefix = this.getCurrentNode().getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        return prefix;
    }

    public String getPITarget() {
        throw new UnsupportedOperationException();
    }

    public String getPIData() {
        throw new UnsupportedOperationException();
    }
}

