/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director.app;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.console.ProvisioningHelper;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.director.app.Activator;
import org.eclipse.equinox.internal.p2.director.app.Messages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.PlanExecutionHelper;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.LatestIUVersionQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.CompositeQuery;
import org.eclipse.equinox.internal.provisional.p2.query.CompoundQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class Application
implements IApplication {
    private static final Integer EXIT_ERROR = new Integer(13);
    private static final String ANT_PROPERTY_PREFIX = "${";
    private static final String FLAVOR_DEFAULT = "tooling";
    private static final String EXEMPLARY_SETUP = "org.eclipse.equinox.p2.exemplarysetup";
    private static final String FRAMEWORKADMIN_EQUINOX = "org.eclipse.equinox.frameworkadmin.equinox";
    private static final String SIMPLE_CONFIGURATOR_MANIPULATOR = "org.eclipse.equinox.simpleconfigurator.manipulator";
    public static final int COMMAND_INSTALL = 0;
    public static final int COMMAND_UNINSTALL = 1;
    public static final int COMMAND_LIST = 2;
    public static final String[] COMMAND_NAMES = new String[]{"-installIU", "-uninstallIU", "-list"};
    private Path destination;
    private URI[] artifactRepositoryLocations;
    private URI[] metadataRepositoryLocations;
    private URI[] metadataReposForRemoval;
    private URI[] artifactReposForRemoval;
    private IArtifactRepositoryManager artifactManager;
    private IMetadataRepositoryManager metadataManager;
    private String root;
    private Version version = null;
    private String flavor;
    private String profileId;
    private String profileProperties;
    private String bundlePool = null;
    private String nl;
    private String os;
    private String arch;
    private String ws;
    private boolean roamingProfile = false;
    private IPlanner planner;
    private IEngine engine;
    private boolean noProfileId = false;
    private int command = -1;
    private ServiceReference packageAdminRef;
    private PackageAdmin packageAdmin;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    private void ambigousCommand(int cmd1, int cmd2) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Ambigous_Command, (Object[])new Object[]{COMMAND_NAMES[cmd1], COMMAND_NAMES[cmd2]})));
    }

    private ProfileChangeRequest buildProvisioningRequest(IProfile profile, Collector roots, boolean install) {
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        this.markRoots(request, roots);
        if (install) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            request.addInstallableUnits((IInstallableUnit[])roots.toArray((Class)clazz));
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            request.removeInstallableUnits((IInstallableUnit[])roots.toArray((Class)clazz));
        }
        return request;
    }

    synchronized Bundle getBundle(String symbolicName) {
        if (this.packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = this.packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    private String getEnvironmentProperty() {
        Properties values = new Properties();
        if (this.os != null) {
            values.put("osgi.os", this.os);
        }
        if (this.nl != null) {
            values.put("osgi.nl", this.nl);
        }
        if (this.ws != null) {
            values.put("osgi.ws", this.ws);
        }
        if (this.arch != null) {
            values.put("osgi.arch", this.arch);
        }
        if (values.isEmpty()) {
            return null;
        }
        return this.toString(values);
    }

    private IProfile initializeProfile() throws CoreException {
        IProfile profile;
        if (this.profileId == null) {
            this.profileId = "_SELF_";
            this.noProfileId = true;
        }
        if ((profile = ProvisioningHelper.getProfile((String)this.profileId)) == null) {
            String currentFlavor;
            String env;
            if (this.destination == null) {
                this.missingArgument("destination");
            }
            if (this.flavor == null) {
                this.flavor = System.getProperty("eclipse.p2.configurationFlavor", FLAVOR_DEFAULT);
            }
            Properties props = new Properties();
            props.setProperty("org.eclipse.equinox.p2.installFolder", this.destination.toOSString());
            props.setProperty("org.eclipse.equinox.p2.flavor", this.flavor);
            if (this.bundlePool == null || this.bundlePool.equals(Messages.destination_commandline)) {
                props.setProperty("org.eclipse.equinox.p2.cache", this.destination.toOSString());
            } else {
                props.setProperty("org.eclipse.equinox.p2.cache", this.bundlePool);
            }
            if (this.roamingProfile) {
                props.setProperty("org.eclipse.equinox.p2.roaming", Boolean.TRUE.toString());
            }
            if ((env = this.getEnvironmentProperty()) != null) {
                props.setProperty("org.eclipse.equinox.p2.environments", env);
            }
            if (this.profileProperties != null) {
                this.putProperties(this.profileProperties, props);
            }
            if ((currentFlavor = (profile = ProvisioningHelper.addProfile((String)this.profileId, (Properties)props)).getProperty("org.eclipse.equinox.p2.flavor")) != null && !currentFlavor.endsWith(this.flavor)) {
                throw new RuntimeException(NLS.bind((String)"Install flavor {0} not consistent with profile flavor {1}", (Object)this.flavor, (Object)currentFlavor));
            }
        }
        return profile;
    }

    private void initializeRepositories(boolean throwException) throws CoreException {
        int i;
        boolean anyValid;
        int removalIdx;
        if (this.artifactRepositoryLocations == null) {
            if (throwException) {
                this.missingArgument("artifactRepository");
            }
        } else {
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.artifactManager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
            if (this.artifactManager == null) {
                if (throwException) {
                    throw new ProvisionException(Messages.Application_NoManager);
                }
            } else {
                removalIdx = 0;
                anyValid = false;
                this.artifactReposForRemoval = new URI[this.artifactRepositoryLocations.length];
                i = 0;
                while (i < this.artifactRepositoryLocations.length) {
                    try {
                        if (!this.artifactManager.contains(this.artifactRepositoryLocations[i])) {
                            this.artifactManager.loadRepository(this.artifactRepositoryLocations[i], null);
                            this.artifactReposForRemoval[removalIdx++] = this.artifactRepositoryLocations[i];
                        }
                        anyValid = true;
                    }
                    catch (ProvisionException e) {
                        LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", String.valueOf(this.artifactRepositoryLocations[i].toString()) + " failed to load", (Throwable)e));
                    }
                    ++i;
                }
                if (throwException && !anyValid) {
                    throw new ProvisionException(Messages.Application_NoRepositories);
                }
            }
        }
        if (this.metadataRepositoryLocations == null) {
            if (throwException) {
                this.missingArgument("metadataRepository");
            }
        } else {
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.metadataManager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
            if (this.metadataManager == null) {
                if (throwException) {
                    throw new ProvisionException(Messages.Application_NoManager);
                }
            } else {
                removalIdx = 0;
                anyValid = false;
                this.metadataReposForRemoval = new URI[this.metadataRepositoryLocations.length];
                i = 0;
                while (i < this.metadataRepositoryLocations.length) {
                    try {
                        if (!this.metadataManager.contains(this.metadataRepositoryLocations[i])) {
                            this.metadataManager.loadRepository(this.metadataRepositoryLocations[i], null);
                            this.metadataReposForRemoval[removalIdx++] = this.metadataRepositoryLocations[i];
                        }
                        anyValid = true;
                    }
                    catch (ProvisionException e) {
                        LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", String.valueOf(this.metadataRepositoryLocations[i].toString()) + " failed to load", (Throwable)e));
                    }
                    ++i;
                }
                if (throwException && !anyValid) {
                    throw new ProvisionException(Messages.Application_NoRepositories);
                }
            }
        }
    }

    private void initializeServices() {
        IDirector director;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IDirector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((director = (IDirector)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new RuntimeException(Messages.Missing_director);
        }
        BundleContext bundleContext2 = Activator.getContext();
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IPlanner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.planner = (IPlanner)ServiceHelper.getService((BundleContext)bundleContext2, (String)clazz2.getName());
        if (this.planner == null) {
            throw new RuntimeException(Messages.Missing_planner);
        }
        this.engine = (IEngine)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IEngine.SERVICE_NAME);
        if (this.engine == null) {
            throw new RuntimeException(Messages.Missing_Engine);
        }
    }

    private void markRoots(ProfileChangeRequest request, Collector roots) {
        Iterator iterator = roots.iterator();
        while (iterator.hasNext()) {
            request.setInstallableUnitProfileProperty((IInstallableUnit)iterator.next(), "org.eclipse.equinox.p2.type.root", (Object)Boolean.TRUE.toString());
        }
    }

    private void missingArgument(String argumentName) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Missing_Required_Argument, (Object)argumentName)));
    }

    private IStatus planAndExecute(IProfile profile, ProvisioningContext context, ProfileChangeRequest request) {
        ProvisioningPlan result = this.planner.getProvisioningPlan(request, context, (IProgressMonitor)new NullProgressMonitor());
        IStatus operationStatus = !result.getStatus().isOK() ? result.getStatus() : PlanExecutionHelper.executePlan((ProvisioningPlan)result, (IEngine)this.engine, (ProvisioningContext)context, (IProgressMonitor)new NullProgressMonitor());
        return operationStatus;
    }

    private void printRequest(ProfileChangeRequest request) {
        IInstallableUnit[] toAdd = request.getAddedInstallableUnits();
        IInstallableUnit[] toRemove = request.getRemovedInstallableUnits();
        int i = 0;
        while (i < toAdd.length) {
            System.out.println(NLS.bind((String)Messages.Installing, (Object)toAdd[i].getId(), (Object)toAdd[i].getVersion()));
            ++i;
        }
        i = 0;
        while (i < toRemove.length) {
            System.out.println(NLS.bind((String)Messages.Uninstalling, (Object)toRemove[i].getId(), (Object)toRemove[i].getVersion()));
            ++i;
        }
    }

    public void processArguments(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            String opt = args[i];
            if (opt.equals("-roaming")) {
                this.roamingProfile = true;
            }
            if (opt.equals(COMMAND_NAMES[2])) {
                if (this.command != -1) {
                    this.ambigousCommand(2, this.command);
                }
                this.command = 2;
            }
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (opt.equalsIgnoreCase("-profile")) {
                    this.profileId = arg;
                }
                if (opt.equalsIgnoreCase("-profileProperties") || opt.equalsIgnoreCase("-props")) {
                    this.profileProperties = arg;
                }
                if (opt.equalsIgnoreCase("-destination") || opt.equalsIgnoreCase("-dest")) {
                    if (arg.startsWith("file:")) {
                        arg = arg.substring(5);
                    }
                    this.destination = new Path(arg);
                }
                if (opt.equalsIgnoreCase("-bundlepool") || opt.equalsIgnoreCase("-bp")) {
                    if (arg.startsWith("file:")) {
                        arg = arg.substring(5);
                    }
                    this.bundlePool = new Path(arg).toOSString();
                }
                if (opt.equalsIgnoreCase("-metadataRepository") || opt.equalsIgnoreCase("-metadataRepositories") || opt.equalsIgnoreCase("-mr")) {
                    this.metadataRepositoryLocations = Application.getURIs(arg);
                }
                if (opt.equalsIgnoreCase("-artifactRepository") || opt.equalsIgnoreCase("-artifactRepositories") || opt.equalsIgnoreCase("-ar")) {
                    this.artifactRepositoryLocations = Application.getURIs(arg);
                }
                if (opt.equalsIgnoreCase("-flavor")) {
                    this.flavor = arg;
                }
                if (opt.equalsIgnoreCase(COMMAND_NAMES[0])) {
                    if (this.command != -1) {
                        this.ambigousCommand(0, this.command);
                    }
                    this.root = arg;
                    this.command = 0;
                }
                if (opt.equalsIgnoreCase("-version") && arg != null && !arg.startsWith(ANT_PROPERTY_PREFIX)) {
                    this.version = new Version(arg);
                }
                if (opt.equalsIgnoreCase(COMMAND_NAMES[1])) {
                    if (this.command != -1) {
                        this.ambigousCommand(1, this.command);
                    }
                    this.root = arg;
                    this.command = 1;
                }
                if (opt.equalsIgnoreCase("-p2.os")) {
                    this.os = arg;
                }
                if (opt.equalsIgnoreCase("-p2.ws")) {
                    this.ws = arg;
                }
                if (opt.equalsIgnoreCase("-p2.nl")) {
                    this.nl = arg;
                }
                if (opt.equalsIgnoreCase("-p2.arch")) {
                    this.arch = arg;
                }
            }
            ++i;
        }
    }

    private void putProperties(String pairs, Properties properties) {
        StringTokenizer tok = new StringTokenizer(pairs, ",", true);
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken().trim();
            int i = next.indexOf(61);
            if (i <= 0 || i >= next.length() - 1) continue;
            String tag = next.substring(0, i).trim();
            String value = next.substring(i + 1, next.length()).trim();
            if (tag.length() <= 0 || value.length() <= 0) continue;
            properties.put(tag, value);
        }
    }

    public Object run(String[] args) throws Exception {
        System.out.println("This application is deprecated. Please use the org.eclipse.equinox.p2.director application.");
        long time = -System.currentTimeMillis();
        this.initializeServices();
        this.processArguments(args);
        IStatus operationStatus = Status.OK_STATUS;
        try {
            this.initializeRepositories(this.command == 0);
            switch (this.command) {
                case 0: 
                case 1: {
                    IProfile profile = this.initializeProfile();
                    InstallableUnitQuery query = new InstallableUnitQuery(this.root, this.version == null ? VersionRange.emptyRange : new VersionRange(this.version, true, this.version, true));
                    Collector roots = this.collectRootIUs(this.metadataRepositoryLocations, (Query)new CompositeQuery(new Query[]{query, new LatestIUVersionQuery()}), new Collector());
                    if (roots.size() <= 0) {
                        roots = profile.query((Query)query, roots, (IProgressMonitor)new NullProgressMonitor());
                    }
                    if (roots.size() <= 0) {
                        System.out.println(NLS.bind((String)Messages.Missing_IU, (Object)this.root));
                        this.logFailure((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Missing_IU, (Object)this.root)));
                        Integer n = EXIT_ERROR;
                        return n;
                    }
                    boolean wasRoaming = Boolean.valueOf(profile.getProperty("org.eclipse.equinox.p2.roaming"));
                    try {
                        IStatus updateRoamStatus = this.updateRoamingProperties(profile);
                        if (!updateRoamStatus.isOK()) {
                            MultiStatus multi = new MultiStatus("org.eclipse.equinox.p2.director.app", 4, NLS.bind((String)Messages.Cant_change_roaming, (Object)profile.getProfileId()), null);
                            multi.add(updateRoamStatus);
                            System.out.println(multi.getMessage());
                            System.out.println(updateRoamStatus.getMessage());
                            this.logFailure((IStatus)multi);
                            Integer n = EXIT_ERROR;
                            return n;
                        }
                        ProvisioningContext context = new ProvisioningContext(this.metadataRepositoryLocations);
                        context.setArtifactRepositories(this.artifactRepositoryLocations);
                        ProfileChangeRequest request = this.buildProvisioningRequest(profile, roots, this.command == 0);
                        this.printRequest(request);
                        operationStatus = this.planAndExecute(profile, context, request);
                        break;
                    }
                    finally {
                        if (wasRoaming && !Boolean.valueOf(profile.getProperty("org.eclipse.equinox.p2.roaming")).booleanValue()) {
                            this.setRoaming(profile);
                        }
                    }
                }
                case 2: {
                    InstallableUnitQuery query = new InstallableUnitQuery(null, VersionRange.emptyRange);
                    if (this.metadataRepositoryLocations == null) {
                        this.missingArgument("metadataRepository");
                    }
                    Collector roots = this.collectRootIUs(this.metadataRepositoryLocations, (Query)query, null);
                    Iterator unitIterator = roots.iterator();
                    while (unitIterator.hasNext()) {
                        IInstallableUnit iu = (IInstallableUnit)unitIterator.next();
                        System.out.println(iu.getId());
                    }
                    break block5;
                }
            }
        }
        finally {
            this.cleanupRepositories();
        }
        time += System.currentTimeMillis();
        if (!operationStatus.isOK()) {
            System.out.println(Messages.Operation_failed);
            this.logFailure(operationStatus);
            return EXIT_ERROR;
        }
        System.out.println(NLS.bind((String)Messages.Operation_complete, (Object)new Long(time)));
        return IApplication.EXIT_OK;
    }

    private void cleanupRepositories() {
        int i;
        if (this.artifactReposForRemoval != null && this.artifactManager != null) {
            i = 0;
            while (i < this.artifactReposForRemoval.length && this.artifactReposForRemoval[i] != null) {
                this.artifactManager.removeRepository(this.artifactReposForRemoval[i]);
                ++i;
            }
        }
        if (this.metadataReposForRemoval != null && this.metadataManager != null) {
            i = 0;
            while (i < this.metadataReposForRemoval.length && this.metadataReposForRemoval[i] != null) {
                this.metadataManager.removeRepository(this.metadataReposForRemoval[i]);
                ++i;
            }
        }
    }

    private Collector collectRootIUs(URI[] locations, Query query, Collector collector) {
        NullProgressMonitor nullMonitor = new NullProgressMonitor();
        if (locations == null || locations.length == 0) {
            return ProvisioningHelper.getInstallableUnits(null, (Query)query, (Collector)collector, (IProgressMonitor)nullMonitor);
        }
        Collector result = collector != null ? collector : new Collector();
        IQueryable[] locationQueryables = new IQueryable[locations.length];
        int i = 0;
        while (i < locations.length) {
            locationQueryables[i] = new LocationQueryable(locations[i]);
            ++i;
        }
        return new CompoundQueryable(locationQueryables).query(query, result, (IProgressMonitor)nullMonitor);
    }

    private synchronized void setPackageAdmin(PackageAdmin service) {
        this.packageAdmin = service;
    }

    private boolean startEarly(String bundleName) throws BundleException {
        Bundle bundle = this.getBundle(bundleName);
        if (bundle == null) {
            return false;
        }
        bundle.start(1);
        return true;
    }

    public Object start(IApplicationContext context) throws Exception {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.packageAdminRef = bundleContext.getServiceReference(clazz.getName());
        this.setPackageAdmin((PackageAdmin)Activator.getContext().getService(this.packageAdminRef));
        if (!this.startEarly(EXEMPLARY_SETUP)) {
            this.logFailure((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Missing_bundle, (Object)EXEMPLARY_SETUP)));
            return EXIT_ERROR;
        }
        if (!this.startEarly(SIMPLE_CONFIGURATOR_MANIPULATOR)) {
            this.logFailure((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Missing_bundle, (Object)SIMPLE_CONFIGURATOR_MANIPULATOR)));
            return EXIT_ERROR;
        }
        if (!this.startEarly(FRAMEWORKADMIN_EQUINOX)) {
            this.logFailure((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Missing_bundle, (Object)FRAMEWORKADMIN_EQUINOX)));
            return EXIT_ERROR;
        }
        return this.run((String[])context.getArguments().get("application.args"));
    }

    public void stop() {
        this.setPackageAdmin(null);
        Activator.getContext().ungetService(this.packageAdminRef);
    }

    private String toString(Properties context) {
        StringBuffer result = new StringBuffer();
        Enumeration<Object> iter = context.keys();
        while (iter.hasMoreElements()) {
            String key = (String)iter.nextElement();
            result.append(key);
            result.append('=');
            result.append(context.get(key));
            if (!iter.hasMoreElements()) continue;
            result.append(',');
        }
        return result.toString();
    }

    private IStatus updateRoamingProperties(IProfile profile) {
        if (this.destination == null) {
            return Status.OK_STATUS;
        }
        if (this.noProfileId) {
            return new Status(4, "org.eclipse.equinox.p2.director.app", Messages.Missing_profileid);
        }
        if (!Boolean.valueOf(profile.getProperty("org.eclipse.equinox.p2.roaming")).booleanValue()) {
            return Status.OK_STATUS;
        }
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        File destinationFile = this.destination.toFile();
        if (!destinationFile.equals(new File(profile.getProperty("org.eclipse.equinox.p2.installFolder")))) {
            request.setProfileProperty("org.eclipse.equinox.p2.installFolder", (Object)this.destination.toOSString());
        }
        if (!destinationFile.equals(new File(profile.getProperty("org.eclipse.equinox.p2.cache")))) {
            request.setProfileProperty("org.eclipse.equinox.p2.cache", (Object)this.destination.toOSString());
        }
        if (request.getProfileProperties().size() == 0) {
            return Status.OK_STATUS;
        }
        request.setProfileProperty("org.eclipse.equinox.p2.roaming", (Object)"false");
        ProvisioningContext context = new ProvisioningContext(new URI[0]);
        context.setArtifactRepositories(new URI[0]);
        ProvisioningPlan result = this.planner.getProvisioningPlan(request, context, (IProgressMonitor)new NullProgressMonitor());
        return PlanExecutionHelper.executePlan((ProvisioningPlan)result, (IEngine)this.engine, (ProvisioningContext)context, (IProgressMonitor)new NullProgressMonitor());
    }

    private IStatus setRoaming(IProfile profile) {
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.setProfileProperty("org.eclipse.equinox.p2.roaming", (Object)"true");
        ProvisioningContext context = new ProvisioningContext(new URI[0]);
        context.setArtifactRepositories(new URI[0]);
        ProvisioningPlan result = this.planner.getProvisioningPlan(request, context, (IProgressMonitor)new NullProgressMonitor());
        return PlanExecutionHelper.executePlan((ProvisioningPlan)result, (IEngine)this.engine, (ProvisioningContext)context, (IProgressMonitor)new NullProgressMonitor());
    }

    private static URI[] getURIs(String spec) {
        if (spec == null) {
            return null;
        }
        String[] urlSpecs = Application.getArrayFromString(spec, ",");
        ArrayList<URI> result = new ArrayList<URI>(urlSpecs.length);
        int i = 0;
        while (i < urlSpecs.length) {
            try {
                result.add(URIUtil.fromString((String)urlSpecs[i]));
            }
            catch (URISyntaxException uRISyntaxException) {
                LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Ignored_repo, (Object)urlSpecs[i])));
            }
            ++i;
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new URI[result.size()]);
    }

    public static String[] getArrayFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    private void logFailure(IStatus status) {
        FrameworkLog log;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((log = (FrameworkLog)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) != null) {
            System.err.println("Application failed, log file location: " + log.getFile());
        }
        LogHelper.log((IStatus)status);
    }

    class LocationQueryable
    implements IQueryable {
        private URI location;

        public LocationQueryable(URI location) {
            this.location = location;
        }

        public Collector query(Query query, Collector collector, IProgressMonitor monitor) {
            return ProvisioningHelper.getInstallableUnits((URI)this.location, (Query)query, (Collector)collector, (IProgressMonitor)monitor);
        }
    }
}

